/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.distribution;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.distribution.api.DownloadDistributionService;
import org.opencastproject.distribution.api.StreamingDistributionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.search.api.SearchException;
import org.opencastproject.search.api.SearchService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.handler.distribution.RetractEngageWorkflowOperationHandler;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Engage Partial Retraction Workflow Operation Handler", "workflow.operation=retract-partial"})
public class PartialRetractEngageWorkflowOperationHandler
extends RetractEngageWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(PartialRetractEngageWorkflowOperationHandler.class);
    private static final String RETRACT_FLAVORS = "retract-flavors";
    private static final String RETRACT_TAGS = "retract-tags";

    @Override
    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
    }

    @Override
    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        WorkflowOperationInstance op = workflowInstance.getCurrentOperation();
        String retractTargetTags = StringUtils.trimToEmpty((String)op.getConfiguration(RETRACT_TAGS));
        String retractTargetFlavors = StringUtils.trimToEmpty((String)op.getConfiguration(RETRACT_FLAVORS));
        String[] retractTags = StringUtils.split((String)retractTargetTags, (String)",");
        String[] retractFlavors = StringUtils.split((String)retractTargetFlavors, (String)",");
        SimpleElementSelector retractElementSelector = new SimpleElementSelector();
        for (String flavor : retractFlavors) {
            MediaPackageElementFlavor f = MediaPackageElementFlavor.parseFlavor((String)flavor);
            logger.debug("Selecting for flavor {}", (Object)f);
            retractElementSelector.addFlavor(f);
        }
        for (String tag : retractTags) {
            logger.debug("Selecting for tag {}", (Object)tag);
            retractElementSelector.addTag(tag);
        }
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        MediaPackage searchMP = null;
        logger.info("Partially retracting {}", (Object)mediaPackage.getIdentifier());
        try {
            try {
                searchMP = this.searchService.get(mediaPackage.getIdentifier().toString());
            }
            catch (NotFoundException e) {
                logger.info("The search service doesn't know media package {}", (Object)mediaPackage);
                return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
            }
            catch (UnauthorizedException e) {
                throw new WorkflowOperationException("Not allowed to access media package " + String.valueOf(mediaPackage));
            }
            Collection retractElements = retractElementSelector.select(searchMP, false);
            Set<String> retractElementIds = retractElements.stream().map(MediaPackageElement::getIdentifier).collect(Collectors.toSet());
            logger.debug("Found {} matching elements", (Object)retractElementIds.size());
            List<Job> jobs = this.retractElements(retractElementIds, searchMP);
            if (jobs.size() < 1) {
                logger.debug("No matching elements found");
                return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
            }
            for (MediaPackageElement element : retractElements) {
                logger.debug("Removing {} from mediapackage", (Object)element.getIdentifier());
                mediaPackage.remove(element);
                searchMP.remove(element);
            }
            if (!this.waitForStatus(jobs.toArray(new Job[0])).isSuccess()) {
                throw new WorkflowOperationException("The retract jobs did not complete successfully");
            }
            Job deleteSearchJob = null;
            logger.info("Retracting publication for mediapackage: {}", (Object)mediaPackage.getIdentifier().toString());
            deleteSearchJob = this.searchService.delete(mediaPackage.getIdentifier().toString());
            if (!this.waitForStatus(new Job[]{deleteSearchJob}).isSuccess()) {
                throw new WorkflowOperationException("Mediapackage " + String.valueOf(mediaPackage.getIdentifier()) + " could not be retracted");
            }
            logger.info("Retraction operations complete, republishing updated mediapackage");
            if (!this.isPublishable(mediaPackage)) {
                throw new WorkflowOperationException("Media package does not meet criteria for publication");
            }
            Job publishJob = null;
            try {
                publishJob = this.searchService.add(searchMP);
                if (!this.waitForStatus(new Job[]{publishJob}).isSuccess()) {
                    throw new WorkflowOperationException("Mediapackage " + String.valueOf(mediaPackage.getIdentifier()) + " could not be published");
                }
            }
            catch (SearchException e) {
                throw new WorkflowOperationException("Error publishing media package", (Throwable)e);
            }
            catch (MediaPackageException e) {
                throw new WorkflowOperationException("Error parsing media package", (Throwable)e);
            }
            logger.info("Publication of {} complete", (Object)mediaPackage.getIdentifier());
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        catch (Exception e) {
            if (e instanceof WorkflowOperationException) {
                throw (WorkflowOperationException)e;
            }
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    private Publication findPublicationElement(MediaPackage mediaPackage) throws WorkflowOperationException {
        for (Publication element : mediaPackage.getPublications()) {
            if (!"engage-player".equals(element.getChannel())) continue;
            logger.debug("Found the publication element");
            return element;
        }
        throw new WorkflowOperationException("Unable to find publication element!");
    }

    private boolean isPublishable(MediaPackage mp) {
        boolean hasTracks;
        boolean hasTitle;
        boolean bl = hasTitle = !StringUtils.isBlank((CharSequence)mp.getTitle());
        if (!hasTitle) {
            logger.warn("Media package does not meet criteria for publication: There is no title");
        }
        if (!(hasTracks = mp.hasTracks())) {
            logger.warn("Media package does not meet criteria for publication: There are no tracks");
        }
        return hasTitle && hasTracks;
    }

    @Override
    @Reference(target="(distribution.channel=download)")
    public void setDownloadDistributionService(DownloadDistributionService downloadDistributionService) {
        super.setDownloadDistributionService(downloadDistributionService);
    }

    @Override
    @Reference
    public void setSearchService(SearchService searchService) {
        super.setSearchService(searchService);
    }

    @Override
    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    @Override
    @Reference(target="(distribution.channel=streaming)")
    public void setStreamingDistributionService(StreamingDistributionService streamingDistributionService) {
        super.setStreamingDistributionService(streamingDistributionService);
    }
}

