/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.distribution;

import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.distribution.api.DownloadDistributionService;
import org.opencastproject.distribution.api.StreamingDistributionService;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.RequireUtil;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.handler.distribution.ConfigurableWorkflowOperationHandlerBase;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Configurable Retraction Workflow Handler", "workflow.operation=retract-configure"})
public class ConfigurableRetractWorkflowOperationHandler
extends ConfigurableWorkflowOperationHandlerBase {
    private static final String CHANNEL_ID_KEY = "channel-id";
    static final String RETRACT_STREAMING = "retract-streaming";
    static final boolean RETRACT_STREAMING_DEFAULT = false;
    private DownloadDistributionService downloadDistributionService;
    private StreamingDistributionService streamingDistributionService;

    @Reference(target="(distribution.channel=download)")
    void setDownloadDistributionService(DownloadDistributionService distributionService) {
        this.downloadDistributionService = distributionService;
    }

    @Reference(target="(distribution.channel=streaming)")
    void setStreamingDistributionService(StreamingDistributionService distributionService) {
        this.streamingDistributionService = distributionService;
    }

    @Override
    protected DownloadDistributionService getDownloadDistributionService() {
        assert (this.downloadDistributionService != null);
        return this.downloadDistributionService;
    }

    @Override
    protected StreamingDistributionService getStreamingDistributionService() {
        assert (this.streamingDistributionService != null);
        return this.streamingDistributionService;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        RequireUtil.notNull((Object)workflowInstance, (String)"workflowInstance");
        boolean retractStreaming = false;
        WorkflowOperationInstance op = workflowInstance.getCurrentOperation();
        String retractStreamingString = op.getConfiguration(RETRACT_STREAMING);
        if (retractStreamingString != null) {
            retractStreaming = BooleanUtils.toBoolean((String)StringUtils.trimToEmpty((String)retractStreamingString));
        }
        MediaPackage mp = workflowInstance.getMediaPackage();
        String channelId = StringUtils.trimToEmpty((String)workflowInstance.getCurrentOperation().getConfiguration(CHANNEL_ID_KEY));
        if (StringUtils.isBlank((CharSequence)channelId)) {
            throw new WorkflowOperationException("Unable to retract this mediapackage as the configuration key channel-id is missing. Unable to determine from where to retract these elements.");
        }
        this.retract(mp, channelId, retractStreaming);
        return this.createResult(mp, WorkflowOperationResult.Action.CONTINUE);
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

