/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.distribution;

import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.publication.api.YouTubePublicationService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=YouTube Retraction Workflow Operation Handler", "workflow.operation=retract-youtube"})
public class RetractYouTubeWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(RetractYouTubeWorkflowOperationHandler.class);
    private YouTubePublicationService publicationService = null;

    @Reference
    public void setPublicationService(YouTubePublicationService publicationService) {
        this.publicationService = publicationService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        super.activate(cc);
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        try {
            logger.info("Retracting media package {} from youtube publication channel", (Object)mediaPackage);
            Job retractJob = this.publicationService.retract(mediaPackage);
            if (!this.waitForStatus(new Job[]{retractJob}).isSuccess()) {
                throw new WorkflowOperationException("The youtube retract job did not complete successfully");
            }
            logger.debug("Retraction from youtube operation complete");
            Job job = this.serviceRegistry.getJob(retractJob.getId());
            if (job.getPayload() == null) {
                logger.info("No youtube publication found to retract in mediapackage {}!", (Object)mediaPackage);
                return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
            }
            logger.info("Removing youtube publication element from media package {}", (Object)mediaPackage);
            Publication retractedElement = (Publication)MediaPackageElementParser.getFromXml((String)job.getPayload());
            mediaPackage.remove((MediaPackageElement)retractedElement);
            logger.debug("Remove youtube publication element '{}' complete", (Object)retractedElement);
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        catch (Throwable t) {
            throw new WorkflowOperationException(t);
        }
    }
}

