/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.distribution;

import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.Opt;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.distribution.api.StreamingDistributionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageSupport;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.PublicationImpl;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.publication.api.OaiPmhPublicationService;
import org.opencastproject.publication.api.PublicationException;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.MimeType;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.data.Collections;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.functions.Strings;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=OAI-PMH Publication Workflow Handler", "workflow.operation=publish-oaipmh"})
public class PublishOaiPmhWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(PublishOaiPmhWorkflowOperationHandler.class);
    private static final String DOWNLOAD_FLAVORS = "download-flavors";
    private static final String DOWNLOAD_TAGS = "download-tags";
    private static final String STREAMING_TAGS = "streaming-tags";
    private static final String STREAMING_FLAVORS = "streaming-flavors";
    private static final String CHECK_AVAILABILITY = "check-availability";
    private static final String REPOSITORY = "repository";
    private static final String EXTERNAL_TEMPLATE = "external-template";
    private static final String EXTERNAL_CHANNEL_NAME = "external-channel";
    private static final String EXTERNAL_MIME_TYPE = "external-mime-type";
    private OaiPmhPublicationService publicationService = null;
    private StreamingDistributionService streamingDistributionService = null;

    @Reference
    public void setPublicationService(OaiPmhPublicationService publicationService) {
        this.publicationService = publicationService;
    }

    @Reference(target="(distribution.channel=streaming)")
    protected void setStreamingDistributionService(StreamingDistributionService streamingDistributionService) {
        this.streamingDistributionService = streamingDistributionService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    @Activate
    public void activate(ComponentContext cc) {
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        Collection streamingElements;
        logger.debug("Running distribution workflow operation");
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        String downloadTags = StringUtils.trimToEmpty((String)workflowInstance.getCurrentOperation().getConfiguration(DOWNLOAD_TAGS));
        String downloadFlavors = StringUtils.trimToEmpty((String)workflowInstance.getCurrentOperation().getConfiguration(DOWNLOAD_FLAVORS));
        String streamingTags = StringUtils.trimToEmpty((String)workflowInstance.getCurrentOperation().getConfiguration(STREAMING_TAGS));
        String streamingFlavors = StringUtils.trimToEmpty((String)workflowInstance.getCurrentOperation().getConfiguration(STREAMING_FLAVORS));
        boolean checkAvailability = (Boolean)Option.option((Object)workflowInstance.getCurrentOperation().getConfiguration(CHECK_AVAILABILITY)).bind(Strings.trimToNone).map(Strings.toBool).getOrElse((Object)true);
        String repository = StringUtils.trimToNull((String)workflowInstance.getCurrentOperation().getConfiguration(REPOSITORY));
        Opt externalChannel = this.getOptConfig(workflowInstance.getCurrentOperation(), EXTERNAL_CHANNEL_NAME);
        Opt externalTempalte = this.getOptConfig(workflowInstance.getCurrentOperation(), EXTERNAL_TEMPLATE);
        Opt externalMimetype = this.getOptConfig(workflowInstance.getCurrentOperation(), EXTERNAL_MIME_TYPE).bind(MimeTypes.toMimeType);
        if (repository == null) {
            throw new IllegalArgumentException("No repository has been specified");
        }
        String[] sourceDownloadTags = StringUtils.split((String)downloadTags, (String)",");
        String[] sourceDownloadFlavors = StringUtils.split((String)downloadFlavors, (String)",");
        String[] sourceStreamingTags = StringUtils.split((String)streamingTags, (String)",");
        String[] sourceStreamingFlavors = StringUtils.split((String)streamingFlavors, (String)",");
        if (sourceDownloadTags.length == 0 && sourceDownloadFlavors.length == 0 && sourceStreamingTags.length == 0 && sourceStreamingFlavors.length == 0) {
            logger.warn("No tags or flavors have been specified, so nothing will be published to the engage");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        SimpleElementSelector downloadElementSelector = new SimpleElementSelector();
        for (String string : sourceDownloadFlavors) {
            downloadElementSelector.addFlavor(MediaPackageElementFlavor.parseFlavor((String)string));
        }
        for (String string : sourceDownloadTags) {
            downloadElementSelector.addTag(string);
        }
        Collection downloadElements = downloadElementSelector.select(mediaPackage, false);
        if (this.streamingDistributionService != null && this.streamingDistributionService.publishToStreaming()) {
            SimpleElementSelector streamingElementSelector = new SimpleElementSelector();
            for (String flavor : sourceStreamingFlavors) {
                streamingElementSelector.addFlavor(MediaPackageElementFlavor.parseFlavor((String)flavor));
            }
            for (String tag : sourceStreamingTags) {
                streamingElementSelector.addTag(tag);
            }
            streamingElements = streamingElementSelector.select(mediaPackage, false);
        } else {
            streamingElements = Collections.list((Object[])new MediaPackageElement[0]);
        }
        try {
            HashSet<String> downloadElementIds = new HashSet<String>();
            HashSet<String> hashSet = new HashSet<String>();
            for (MediaPackageElement elem : downloadElements) {
                downloadElementIds.add(elem.getIdentifier());
            }
            for (MediaPackageElement elem : streamingElements) {
                hashSet.add(elem.getIdentifier());
            }
            Job publishJob = null;
            try {
                publishJob = this.publicationService.publish(mediaPackage, repository, downloadElementIds, hashSet, checkAvailability);
            }
            catch (MediaPackageException e) {
                throw new WorkflowOperationException("Error parsing media package", (Throwable)e);
            }
            catch (PublicationException e) {
                throw new WorkflowOperationException("Error parsing media package", (Throwable)e);
            }
            if (!this.waitForStatus(new Job[]{publishJob}).isSuccess()) {
                throw new WorkflowOperationException("Mediapackage " + mediaPackage.getIdentifier() + " could not be published to OAI-PMH repository " + repository);
            }
            Job job = this.serviceRegistry.getJob(publishJob.getId());
            if (job.getPayload() == null) {
                logger.warn("Publish to OAI-PMH repository '{}' failed, no payload from publication job: {}", (Object)repository, (Object)job);
                return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
            }
            Publication newElement = null;
            try {
                newElement = (Publication)MediaPackageElementParser.getFromXml((String)job.getPayload());
            }
            catch (MediaPackageException e) {
                throw new WorkflowOperationException((Throwable)e);
            }
            if (newElement == null) {
                logger.warn("Publication to OAI-PMH repository '{}' failed, unable to parse the payload '{}' from job '{}' to a mediapackage element", new Object[]{repository, job.getPayload(), job.toString()});
                return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
            }
            for (Publication existingPublication : Stream.$((Object[])mediaPackage.getPublications()).find(MediaPackageSupport.Filters.ofChannel((String)newElement.getChannel()).toFn())) {
                mediaPackage.remove((MediaPackageElement)existingPublication);
            }
            mediaPackage.add((MediaPackageElement)newElement);
            if (externalChannel.isSome() && externalMimetype.isSome() && externalTempalte.isSome()) {
                String template = ((String)externalTempalte.get()).replace("{event}", mediaPackage.getIdentifier().toString());
                if (StringUtils.isNotBlank((CharSequence)mediaPackage.getSeries())) {
                    template = template.replace("{series}", mediaPackage.getSeries());
                }
                Publication externalElement = PublicationImpl.publication((String)UUID.randomUUID().toString(), (String)((String)externalChannel.get()), (URI)URI.create(template), (MimeType)((MimeType)externalMimetype.get()));
                for (Publication existingPublication : Stream.$((Object[])mediaPackage.getPublications()).find(MediaPackageSupport.Filters.ofChannel((String)((String)externalChannel.get())).toFn())) {
                    mediaPackage.remove((MediaPackageElement)existingPublication);
                }
                mediaPackage.add((MediaPackageElement)externalElement);
            }
            logger.debug("Publication to OAI-PMH repository '{}' operation completed", (Object)repository);
        }
        catch (Exception e) {
            if (e instanceof WorkflowOperationException) {
                throw (WorkflowOperationException)e;
            }
            throw new WorkflowOperationException((Throwable)e);
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }
}

