/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.crop.endpoint;

import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.crop.api.CropException;
import org.opencastproject.crop.api.CropService;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="")
@RestService(name="crop", title="Video CROP Service", abstractText="This service is not ready", notes={"This is a note"})
@Component(immediate=true, service={CropRestEndpoint.class}, property={"service.description=Video Crop REST Endpoint", "opencast.service.type=org.opencastproject.crop", "opencast.service.path=/crop", "opencast.service.jobproducer=true"})
public class CropRestEndpoint
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(CropRestEndpoint.class);
    protected String docs;
    protected CropService cropService;
    protected ServiceRegistry serviceRegistry = null;

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    protected void setCropService(CropService cropService) {
        this.cropService = cropService;
    }

    @POST
    @Path(value="")
    @Produces(value={"text/xml"})
    @RestQuery(name="crop", description="Submit a track for cropping", restParameters={@RestParameter(description="The track to crop.", isRequired=true, name="track", type=RestParameter.Type.FILE)}, responses={@RestResponse(description="The job ID to use when polling for the resulting mpeg7 catalog.", responseCode=200), @RestResponse(description="The \"crop\" is NULL or not a valid track type.", responseCode=400), @RestResponse(description="The underlying service could not crop the video.", responseCode=500)}, returnDescription="The job ID to use when polling for the resulting mpeg7 catalog.")
    public Response crop(@FormParam(value="track") String trackAsXml) throws Exception {
        if (StringUtils.isBlank((CharSequence)trackAsXml)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"track must not be null").build();
        }
        MediaPackageElement sourceTrack = MediaPackageElementParser.getFromXml((String)trackAsXml);
        if (!Track.TYPE.equals((Object)sourceTrack.getElementType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"mediapackage element must be of type track").build();
        }
        try {
            Job job = this.cropService.crop((Track)sourceTrack);
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (CropException e) {
            logger.warn("cropping failed: :" + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="docs")
    public String getDocs() {
        return this.docs;
    }

    public JobProducer getService() {
        if (this.cropService instanceof JobProducer) {
            return (JobProducer)this.cropService;
        }
        return null;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

