/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.coverimage.impl.xsl;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public final class XsltHelper {
    private static final String LINE_SEPARATOR = "<newline>";

    private XsltHelper() {
    }

    public static String split(String text, int maxChars, int line, boolean isLastLine) {
        if (text == null || line < 1) {
            return null;
        }
        if (maxChars > text.length() && line == 1 || maxChars == 0) {
            return text;
        }
        String textWithSeparator = WordUtils.wrap((String)text, (int)maxChars, (String)LINE_SEPARATOR, (boolean)true);
        String[] lines = textWithSeparator.split(LINE_SEPARATOR);
        if (lines.length >= line) {
            if (isLastLine && lines.length > line && maxChars > 3) {
                String lastLine = lines[line - 1] + "...";
                return StringUtils.abbreviate((String)lastLine, (int)maxChars).trim();
            }
            return lines[line - 1].trim();
        }
        return null;
    }
}

