/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.composer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.AdaptivePlaylist;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Function2;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Sanitize Adaptive Workflow Operation Handler", "workflow.operation=sanitize-adaptive"})
public class SanitizeAdaptiveWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(SanitizeAdaptiveWorkflowOperationHandler.class);
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    private Workspace workspace = null;

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running HLS Check workflow operation on workflow {}", (Object)workflowInstance.getId());
        try {
            return this.sanitizeHLS(workflowInstance);
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    private WorkflowOperationResult sanitizeHLS(WorkflowInstance wi) throws EncoderException, WorkflowOperationException, NotFoundException, MediaPackageException, IOException, URISyntaxException {
        AdaptivePlaylist.HLSMediaPackageCheck hlstree;
        MediaPackage src = wi.getMediaPackage();
        final MediaPackage mediaPackage = (MediaPackage)src.clone();
        WorkflowOperationInstance operation = wi.getCurrentOperation();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(wi, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.one, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.one);
        MediaPackageElementFlavor sourceFlavor = tagsAndFlavors.getSingleSrcFlavor();
        List targetTrackTags = tagsAndFlavors.getTargetTags();
        final MediaPackageElementFlavor targetFlavor = tagsAndFlavors.getSingleTargetFlavor();
        final ArrayList<String> removeTags = new ArrayList<String>();
        final ArrayList<String> addTags = new ArrayList<String>();
        final ArrayList<String> overrideTags = new ArrayList<String>();
        if (!targetTrackTags.isEmpty()) {
            for (String tag : targetTrackTags) {
                if (tag.startsWith(MINUS)) {
                    removeTags.add(tag);
                    continue;
                }
                if (tag.startsWith(PLUS)) {
                    addTags.add(tag);
                    continue;
                }
                overrideTags.add(tag);
            }
        }
        TrackSelector trackSelector = new TrackSelector();
        trackSelector.addFlavor(sourceFlavor);
        Collection tracks = trackSelector.select(mediaPackage, false);
        ArrayList tracklist = new ArrayList(tracks);
        if (!tracklist.stream().filter(AdaptivePlaylist.isHLSTrackPred).findAny().isPresent()) {
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, 0L);
        }
        try {
            hlstree = new AdaptivePlaylist.HLSMediaPackageCheck(tracklist, (Function)new Function<URI, File>(){

                @Override
                public File apply(URI uri) {
                    try {
                        return SanitizeAdaptiveWorkflowOperationHandler.this.workspace.get(uri);
                    }
                    catch (IOException | NotFoundException e1) {
                        logger.error("Cannot get {} from workspace", (Object)uri, (Object)e1);
                        return null;
                    }
                }
            });
        }
        catch (URISyntaxException e1) {
            throw new MediaPackageException("Cannot process tracks from workspace");
        }
        Function2<File, Track, Track> replaceHLSPlaylistInWS = new Function2<File, Track, Track>(){

            public Track apply(File file, Track track) {
                try {
                    FileInputStream inputStream = new FileInputStream(file);
                    URI uri = SanitizeAdaptiveWorkflowOperationHandler.this.workspace.put(mediaPackage.getIdentifier().toString(), track.getIdentifier(), file.getName(), (InputStream)inputStream);
                    track.setURI(uri);
                    SanitizeAdaptiveWorkflowOperationHandler.this.handleTags(track, targetFlavor, overrideTags, removeTags, addTags);
                    return track;
                }
                catch (Exception e) {
                    logger.error("Cannot add track file to mediapackage in workspace: {} {} ", (Object)mediaPackage.getIdentifier().toString(), (Object)file);
                    return null;
                }
            }
        };
        Function<Track, Void> removeFromWS = new Function<Track, Void>(){

            @Override
            public Void apply(Track track) {
                try {
                    SanitizeAdaptiveWorkflowOperationHandler.this.workspace.delete(track.getURI());
                }
                catch (NotFoundException e) {
                    logger.error("Cannot delete from workspace: File not found {} ", (Object)track);
                }
                catch (IOException e) {
                    logger.error("Cannot delete from workspace: IO Error {} ", (Object)track);
                }
                return null;
            }
        };
        if (hlstree.needsRewriting()) {
            try {
                hlstree.rewriteHLS(mediaPackage, (Function2)replaceHLSPlaylistInWS, (Function)removeFromWS);
            }
            catch (Exception e) {
                logger.error("Error: cannot rewrite HLS renditions", (Throwable)e);
                throw new WorkflowOperationException((Throwable)e);
            }
            for (Track track : tracks) {
                if (AdaptivePlaylist.isPlaylist((String)track.getURI().getPath())) continue;
                this.handleTags(track, targetFlavor, overrideTags, removeTags, addTags);
                logger.info("Set flavor {} and tags to {} ", (Object)track, (Object)targetFlavor);
            }
        } else {
            for (Track track : tracks) {
                this.handleTags(track, targetFlavor, overrideTags, removeTags, addTags);
                logger.info("Set flavor {} and tags to {} ", (Object)track, (Object)targetFlavor);
            }
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, 0L);
    }

    private void handleTags(Track track, MediaPackageElementFlavor targetFlavor, List<String> overrideTags, List<String> removeTags, List<String> addTags) {
        if (targetFlavor != null) {
            String flavorType = targetFlavor.getType();
            String flavorSubtype = targetFlavor.getSubtype();
            if ("*".equals(flavorType)) {
                flavorType = track.getFlavor().getType();
            }
            if ("*".equals(flavorSubtype)) {
                flavorSubtype = track.getFlavor().getSubtype();
            }
            track.setFlavor(new MediaPackageElementFlavor(flavorType, flavorSubtype));
            logger.debug("Composed track has flavor '{}'", (Object)track.getFlavor());
        }
        if (overrideTags.size() > 0) {
            track.clearTags();
            for (String tag : overrideTags) {
                logger.trace("Tagging composed track with '{}'", (Object)tag);
                track.addTag(tag);
            }
        } else {
            for (String tag : removeTags) {
                logger.trace("Remove tagging '{}' from composed track", (Object)tag);
                track.removeTag(tag.substring(MINUS.length()));
            }
            for (String tag : addTags) {
                logger.trace("Add tagging '{}' to composed track", (Object)tag);
                track.addTag(tag.substring(PLUS.length()));
            }
        }
    }
}

