/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.composer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.composer.layout.Dimension;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Stream;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.TrackSupport;
import org.opencastproject.mediapackage.VideoStream;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.smil.api.util.SmilUtil;
import org.opencastproject.util.JobUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Collections;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.data.VCell;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.smil.SMILDocument;
import org.w3c.dom.smil.SMILElement;
import org.w3c.dom.smil.SMILMediaElement;
import org.w3c.dom.smil.SMILParElement;
import org.xml.sax.SAXException;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Partial import Workflow Operation Handler", "workflow.operation=partial-import"})
public class PartialImportWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final String SOURCE_PRESENTER_FLAVOR = "source-presenter-flavor";
    private static final String SOURCE_PRESENTATION_FLAVOR = "source-presentation-flavor";
    private static final String SOURCE_SMIL_FLAVOR = "source-smil-flavor";
    private static final String TARGET_PRESENTER_FLAVOR = "target-presenter-flavor";
    private static final String TARGET_PRESENTATION_FLAVOR = "target-presentation-flavor";
    private static final String CONCAT_ENCODING_PROFILE = "concat-encoding-profile";
    private static final String CONCAT_OUTPUT_FRAMERATE = "concat-output-framerate";
    private static final String TRIM_ENCODING_PROFILE = "trim-encoding-profile";
    private static final String FORCE_ENCODING_PROFILE = "force-encoding-profile";
    private static final String PREENCODE_ENCODING_PROFILE = "preencode-encoding-profile";
    private static final String FORCE_ENCODING = "force-encoding";
    private static final String REQUIRED_EXTENSIONS = "required-extensions";
    private static final String ENFORCE_DIVISIBLE_BY_TWO = "enforce-divisible-by-two";
    private static final Logger logger = LoggerFactory.getLogger(PartialImportWorkflowOperationHandler.class);
    private static final String EMPTY_VALUE = "";
    private static final String NODE_TYPE_AUDIO = "audio";
    private static final String NODE_TYPE_VIDEO = "video";
    private static final String FLAVOR_AUDIO_SUFFIX = "-audio";
    private static final String COLLECTION_ID = "composer";
    private static final String UNKNOWN_KEY = "unknown";
    private static final String PRESENTER_KEY = "presenter";
    private static final String PRESENTATION_KEY = "presentation";
    private static final String DEFAULT_REQUIRED_EXTENSION = "mp4";
    private static final String PREVIEW_PROFILE = "import.preview";
    private static final String IMAGE_FRAME_PROFILE = "import.image-frame";
    private static final String SILENT_AUDIO_PROFILE = "import.silent";
    private static final String IMAGE_MOVIE_PROFILE = "image-movie.work";
    private ComposerService composerService = null;
    private Workspace workspace = null;

    @Reference
    public void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running partial import workflow operation on workflow {}", (Object)workflowInstance.getId());
        ArrayList<MediaPackageElement> elementsToClean = new ArrayList<MediaPackageElement>();
        try {
            WorkflowOperationResult workflowOperationResult = this.concat(workflowInstance.getMediaPackage(), workflowInstance.getCurrentOperation(), elementsToClean);
            return workflowOperationResult;
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        finally {
            for (MediaPackageElement elem : elementsToClean) {
                try {
                    this.workspace.delete(elem.getURI());
                }
                catch (Exception e) {
                    logger.warn("Unable to delete element {}", (Object)elem, (Object)e);
                }
            }
        }
    }

    private WorkflowOperationResult concat(MediaPackage src, WorkflowOperationInstance operation, List<MediaPackageElement> elementsToClean) throws EncoderException, IOException, NotFoundException, MediaPackageException, WorkflowOperationException, ServiceRegistryException {
        SMILDocument smilDocument;
        EncodingProfile trimProfile;
        MediaPackage mediaPackage = (MediaPackage)src.clone();
        Long operationId = operation.getId();
        Optional<String> presenterFlavor = Optional.ofNullable((String)this.getOptConfig(operation, SOURCE_PRESENTER_FLAVOR).orNull());
        Optional<String> presentationFlavor = Optional.ofNullable((String)this.getOptConfig(operation, SOURCE_PRESENTATION_FLAVOR).orNull());
        MediaPackageElementFlavor smilFlavor = MediaPackageElementFlavor.parseFlavor((String)this.getConfig(operation, SOURCE_SMIL_FLAVOR));
        String concatEncodingProfile = this.getConfig(operation, CONCAT_ENCODING_PROFILE);
        Optional<String> concatOutputFramerate = Optional.ofNullable((String)this.getOptConfig(operation, CONCAT_OUTPUT_FRAMERATE).orNull());
        String trimEncodingProfile = this.getConfig(operation, TRIM_ENCODING_PROFILE);
        MediaPackageElementFlavor targetPresenterFlavor = this.parseTargetFlavor(this.getConfig(operation, TARGET_PRESENTER_FLAVOR), PRESENTER_KEY);
        MediaPackageElementFlavor targetPresentationFlavor = this.parseTargetFlavor(this.getConfig(operation, TARGET_PRESENTATION_FLAVOR), PRESENTATION_KEY);
        boolean forceEncoding = BooleanUtils.toBoolean((String)((String)this.getOptConfig(operation, FORCE_ENCODING).getOr((Object)"false")));
        Optional<EncodingProfile> forceProfile = this.getForceEncodingProfile(operation, forceEncoding);
        boolean forceDivisible = BooleanUtils.toBoolean((String)((String)this.getOptConfig(operation, ENFORCE_DIVISIBLE_BY_TWO).getOr((Object)"false")));
        List<String> requiredExtensions = this.getRequiredExtensions(operation);
        String preencodeEncodingProfile = this.getConfig(operation, PREENCODE_ENCODING_PROFILE);
        if (presenterFlavor.isEmpty() && presentationFlavor.isEmpty()) {
            logger.warn("No presenter and presentation flavor has been set.");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        EncodingProfile preencodeProfile = this.composerService.getProfile(preencodeEncodingProfile);
        if (preencodeProfile == null) {
            throw new WorkflowOperationException("Preencode encoding profile '" + preencodeEncodingProfile + "' was not found");
        }
        EncodingProfile concatProfile = this.composerService.getProfile(concatEncodingProfile);
        if (concatProfile == null) {
            throw new WorkflowOperationException("Concat encoding profile '" + concatEncodingProfile + "' was not found");
        }
        float outputFramerate = -1.0f;
        if (concatOutputFramerate.isPresent()) {
            if (NumberUtils.isNumber((String)concatOutputFramerate.get())) {
                logger.info("Using concat output framerate");
                outputFramerate = NumberUtils.toFloat((String)concatOutputFramerate.get());
            } else {
                throw new WorkflowOperationException("Unable to parse concat output frame rate!");
            }
        }
        if ((trimProfile = this.composerService.getProfile(trimEncodingProfile)) == null) {
            throw new WorkflowOperationException("Trim encoding profile '" + trimEncodingProfile + "' was not found");
        }
        TrackSelector presenterTrackSelector = this.mkTrackSelector(presenterFlavor);
        TrackSelector presentationTrackSelector = this.mkTrackSelector(presentationFlavor);
        List<Track> originalTracks = new ArrayList<Track>();
        for (Track t : presenterTrackSelector.select(mediaPackage, false)) {
            logger.info("Found partial presenter track {}", (Object)t);
            originalTracks.add(t);
        }
        for (Track t : presentationTrackSelector.select(mediaPackage, false)) {
            logger.info("Found partial presentation track {}", (Object)t);
            originalTracks.add(t);
        }
        logger.info("Starting preencoding");
        originalTracks = this.preencode(preencodeProfile, originalTracks);
        HashMap<String, Job> jobs = new HashMap<String, Job>();
        try {
            smilDocument = SmilUtil.getSmilDocumentFromMediaPackage((MediaPackage)mediaPackage, (MediaPackageElementFlavor)smilFlavor, (Workspace)this.workspace);
        }
        catch (SAXException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        SMILParElement parallel = (SMILParElement)smilDocument.getBody().getChildNodes().item(0);
        NodeList sequences = parallel.getTimeChildren();
        float trackDurationInSeconds = parallel.getDur();
        long trackDurationInMs = Math.round(trackDurationInSeconds * 1000.0f);
        for (int i = 0; i < sequences.getLength(); ++i) {
            SMILElement item = (SMILElement)sequences.item(i);
            for (String mediaType : new String[]{NODE_TYPE_AUDIO, NODE_TYPE_VIDEO}) {
                double extendingTime;
                ArrayList<Track> tracks = new ArrayList<Track>();
                VCell sourceType = VCell.cell((Object)EMPTY_VALUE);
                long position = this.processChildren(0L, tracks, item.getChildNodes(), originalTracks, (VCell<String>)sourceType, mediaType, elementsToClean, operationId);
                if (tracks.isEmpty()) {
                    logger.debug("The tracks list was empty.");
                    continue;
                }
                Track lastTrack = (Track)tracks.get(tracks.size() - 1);
                if (position < trackDurationInMs && (extendingTime = (double)(trackDurationInMs - position) / 1000.0) > 0.0) {
                    if (!lastTrack.hasVideo()) {
                        logger.info("Extending {} audio track end by {} seconds with silent audio", sourceType.get(), (Object)extendingTime);
                        tracks.add(this.getSilentAudio(extendingTime, elementsToClean, operationId));
                    } else {
                        logger.info("Extending {} track end with last image frame by {} seconds", sourceType.get(), (Object)extendingTime);
                        Attachment tempLastImageFrame = this.extractLastImageFrame(lastTrack, elementsToClean);
                        tracks.add(this.createVideoFromImage(tempLastImageFrame, extendingTime, elementsToClean));
                    }
                }
                if (tracks.size() < 2) {
                    logger.debug("There were less than 2 tracks, copying track...");
                    if (((String)sourceType.get()).startsWith(PRESENTER_KEY)) {
                        this.createCopyOfTrack(mediaPackage, (Track)tracks.get(0), targetPresenterFlavor);
                        continue;
                    }
                    if (((String)sourceType.get()).startsWith(PRESENTATION_KEY)) {
                        this.createCopyOfTrack(mediaPackage, (Track)tracks.get(0), targetPresentationFlavor);
                        continue;
                    }
                    logger.warn("Can't handle unkown source type '{}' for unprocessed track", sourceType.get());
                    continue;
                }
                for (Track t : tracks) {
                    if (t.hasVideo() || t.hasAudio()) continue;
                    logger.error("No audio or video stream available in the track with flavor {}! {}", (Object)t.getFlavor(), (Object)t);
                    throw new WorkflowOperationException("No audio or video stream available in the track " + t.toString());
                }
                if (((String)sourceType.get()).startsWith(PRESENTER_KEY)) {
                    logger.info("Concatenating {} track", (Object)PRESENTER_KEY);
                    jobs.put((String)sourceType.get(), this.startConcatJob(concatProfile, tracks, outputFramerate, forceDivisible));
                    continue;
                }
                if (((String)sourceType.get()).startsWith(PRESENTATION_KEY)) {
                    logger.info("Concatenating {} track", (Object)PRESENTATION_KEY);
                    jobs.put((String)sourceType.get(), this.startConcatJob(concatProfile, tracks, outputFramerate, forceDivisible));
                    continue;
                }
                logger.warn("Can't handle unknown source type '{}'!", sourceType.get());
            }
        }
        if (jobs.size() > 0) {
            if (!JobUtil.waitForJobs((ServiceRegistry)this.serviceRegistry, jobs.values()).isSuccess()) {
                throw new WorkflowOperationException("One of the concat jobs did not complete successfully");
            }
        } else {
            logger.info("No concatenating needed for presenter and presentation tracks, took partial source elements");
        }
        long queueTime = 0L;
        MediaPackageElementFlavor adjustedTargetPresenterFlavor = targetPresenterFlavor;
        MediaPackageElementFlavor adjustedTargetPresentationFlavor = targetPresentationFlavor;
        for (Map.Entry job : jobs.entrySet()) {
            Optional<Job> concatJob = Optional.of((Job)JobUtil.update((ServiceRegistry)this.serviceRegistry, (Job)((Job)job.getValue())).orNull());
            if (concatJob.isPresent()) {
                String concatPayload = concatJob.get().getPayload();
                if (concatPayload != null) {
                    String fileName;
                    Track concatTrack;
                    try {
                        concatTrack = (Track)MediaPackageElementParser.getFromXml((String)concatPayload);
                    }
                    catch (MediaPackageException e) {
                        throw new WorkflowOperationException((Throwable)e);
                    }
                    if (((String)job.getKey()).startsWith(PRESENTER_KEY)) {
                        if (!concatTrack.hasVideo()) {
                            fileName = PRESENTER_KEY.concat(FLAVOR_AUDIO_SUFFIX);
                            adjustedTargetPresenterFlavor = this.deriveAudioFlavor(targetPresenterFlavor);
                        } else {
                            fileName = PRESENTER_KEY;
                            adjustedTargetPresenterFlavor = targetPresenterFlavor;
                        }
                        concatTrack.setFlavor(adjustedTargetPresenterFlavor);
                    } else if (((String)job.getKey()).startsWith(PRESENTATION_KEY)) {
                        if (!concatTrack.hasVideo()) {
                            fileName = PRESENTATION_KEY.concat(FLAVOR_AUDIO_SUFFIX);
                            adjustedTargetPresentationFlavor = this.deriveAudioFlavor(targetPresentationFlavor);
                        } else {
                            fileName = PRESENTATION_KEY;
                            adjustedTargetPresentationFlavor = targetPresentationFlavor;
                        }
                        concatTrack.setFlavor(adjustedTargetPresentationFlavor);
                    } else {
                        fileName = UNKNOWN_KEY;
                    }
                    concatTrack.setURI(this.workspace.moveTo(concatTrack.getURI(), mediaPackage.getIdentifier().toString(), concatTrack.getIdentifier(), fileName + "." + FilenameUtils.getExtension((String)concatTrack.getURI().toString())));
                    logger.info("Concatenated track {} got flavor '{}'", (Object)concatTrack, (Object)concatTrack.getFlavor());
                    mediaPackage.add(concatTrack);
                    queueTime += concatJob.get().getQueueTime().longValue();
                    continue;
                }
                logger.warn("Concat job {} does not contain a payload", concatJob);
                continue;
            }
            logger.warn("Concat job {} could not be updated since it cannot be found", job.getValue());
        }
        queueTime += this.checkForTrimming(mediaPackage, trimProfile, targetPresentationFlavor, Float.valueOf(trackDurationInSeconds), elementsToClean);
        queueTime += this.checkForTrimming(mediaPackage, trimProfile, this.deriveAudioFlavor(targetPresentationFlavor), Float.valueOf(trackDurationInSeconds), elementsToClean);
        queueTime += this.checkForTrimming(mediaPackage, trimProfile, targetPresenterFlavor, Float.valueOf(trackDurationInSeconds), elementsToClean);
        queueTime += this.checkForTrimming(mediaPackage, trimProfile, this.deriveAudioFlavor(targetPresenterFlavor), Float.valueOf(trackDurationInSeconds), elementsToClean);
        queueTime += this.checkForMuxing(mediaPackage, targetPresenterFlavor, this.deriveAudioFlavor(targetPresenterFlavor), false, elementsToClean);
        queueTime += this.checkForMuxing(mediaPackage, targetPresentationFlavor, this.deriveAudioFlavor(targetPresentationFlavor), false, elementsToClean);
        this.adjustAudioTrackTargetFlavor(mediaPackage, targetPresenterFlavor);
        this.adjustAudioTrackTargetFlavor(mediaPackage, targetPresentationFlavor);
        queueTime += this.checkForMuxing(mediaPackage, targetPresenterFlavor, targetPresentationFlavor, false, elementsToClean);
        WorkflowOperationResult result = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, queueTime += this.checkForEncodeToStandard(mediaPackage, forceEncoding, forceProfile, requiredExtensions, targetPresenterFlavor, targetPresentationFlavor, elementsToClean));
        logger.debug("Partial import operation completed");
        return result;
    }

    protected long checkForEncodeToStandard(MediaPackage mediaPackage, boolean forceEncoding, Optional<EncodingProfile> forceProfile, List<String> requiredExtensions, MediaPackageElementFlavor targetPresenterFlavor, MediaPackageElementFlavor targetPresentationFlavor, List<MediaPackageElement> elementsToClean) throws EncoderException, IOException, MediaPackageException, NotFoundException, ServiceRegistryException, WorkflowOperationException {
        long queueTime = 0L;
        if (forceProfile.isPresent()) {
            Track[] targetPresenterTracks;
            for (Track track : targetPresenterTracks = mediaPackage.getTracks(targetPresenterFlavor)) {
                if (!forceEncoding && !PartialImportWorkflowOperationHandler.trackNeedsTobeEncodedToStandard(track, requiredExtensions)) continue;
                logger.debug("Encoding '{}' flavored track '{}' with standard encoding profile {}", new Object[]{targetPresenterFlavor, track.getURI(), forceProfile.get()});
                queueTime += this.encodeToStandard(mediaPackage, forceProfile.get(), targetPresenterFlavor, track);
                elementsToClean.add((MediaPackageElement)track);
                mediaPackage.remove(track);
            }
            if (!targetPresenterFlavor.toString().equalsIgnoreCase(targetPresentationFlavor.toString())) {
                Track[] targetPresentationTracks;
                for (Track track : targetPresentationTracks = mediaPackage.getTracks(targetPresentationFlavor)) {
                    if (!forceEncoding && !PartialImportWorkflowOperationHandler.trackNeedsTobeEncodedToStandard(track, requiredExtensions)) continue;
                    logger.debug("Encoding '{}' flavored track '{}' with standard encoding profile {}", new Object[]{targetPresentationFlavor, track.getURI(), forceProfile.get()});
                    queueTime += this.encodeToStandard(mediaPackage, forceProfile.get(), targetPresentationFlavor, track);
                    elementsToClean.add((MediaPackageElement)track);
                    mediaPackage.remove(track);
                }
            }
        }
        return queueTime;
    }

    private void createCopyOfTrack(MediaPackage mediaPackage, Track track, MediaPackageElementFlavor targetFlavor) throws IllegalArgumentException, NotFoundException, IOException {
        MediaPackageElementFlavor targetCopyFlavor = null;
        targetCopyFlavor = track.hasVideo() ? targetFlavor : this.deriveAudioFlavor(targetFlavor);
        logger.debug("Copying track {} with flavor {} using target flavor {}", new Object[]{track.getURI(), track.getFlavor(), targetCopyFlavor});
        this.copyPartialToSource(mediaPackage, targetCopyFlavor, track);
    }

    private void adjustAudioTrackTargetFlavor(MediaPackage mediaPackage, MediaPackageElementFlavor targetFlavor) throws IllegalArgumentException, NotFoundException, IOException {
        Track[] targetAudioTracks;
        for (Track track : targetAudioTracks = mediaPackage.getTracks(this.deriveAudioFlavor(targetFlavor))) {
            logger.debug("Adding {} to finished audio tracks.", (Object)track.getURI());
            mediaPackage.remove(track);
            track.setFlavor(targetFlavor);
            mediaPackage.add(track);
        }
    }

    private TrackSelector mkTrackSelector(Optional<String> flavor) throws WorkflowOperationException {
        TrackSelector s = new TrackSelector();
        if (flavor.isPresent()) {
            try {
                MediaPackageElementFlavor f = MediaPackageElementFlavor.parseFlavor((String)flavor.get());
                s.addFlavor(f);
                s.addFlavor(this.deriveAudioFlavor(f));
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowOperationException("Flavor '" + flavor.get() + "' is malformed");
            }
        }
        return s;
    }

    protected Job startConcatJob(EncodingProfile profile, List<Track> tracks, float outputFramerate, boolean forceDivisible) throws MediaPackageException, EncoderException {
        Dimension dim = this.determineDimension(tracks, forceDivisible);
        if ((double)outputFramerate > 0.0) {
            return this.composerService.concat(profile.getIdentifier(), dim, outputFramerate, true, (Track[])Collections.toArray(Track.class, tracks));
        }
        return this.composerService.concat(profile.getIdentifier(), dim, true, (Track[])Collections.toArray(Track.class, tracks));
    }

    protected static boolean trackNeedsTobeEncodedToStandard(Track track, List<String> requiredExtensions) {
        String extension = FilenameUtils.getExtension((String)track.getURI().toString());
        for (String requiredExtension : requiredExtensions) {
            if (!requiredExtension.equalsIgnoreCase(extension)) continue;
            return false;
        }
        return true;
    }

    protected List<String> getRequiredExtensions(WorkflowOperationInstance operation) {
        ArrayList<String> requiredExtensions = new ArrayList<String>();
        String configExtensions = null;
        try {
            configExtensions = StringUtils.trimToNull((String)this.getConfig(operation, REQUIRED_EXTENSIONS));
        }
        catch (WorkflowOperationException e) {
            logger.info("Required extensions configuration key not specified so will be using default '{}'. Any input file not matching this extension will be re-encoded.", (Object)DEFAULT_REQUIRED_EXTENSION);
        }
        if (configExtensions != null) {
            String[] extensions;
            for (String extension : extensions = configExtensions.split(",")) {
                requiredExtensions.add(extension);
            }
        }
        if (requiredExtensions.size() == 0) {
            requiredExtensions.add(DEFAULT_REQUIRED_EXTENSION);
        }
        return requiredExtensions;
    }

    protected Optional<EncodingProfile> getForceEncodingProfile(WorkflowOperationInstance woi, boolean forceEncoding) throws WorkflowOperationException {
        if (!forceEncoding) {
            return Optional.empty();
        }
        Optional<String> profileNameOpt = Optional.ofNullable((String)this.getOptConfig(woi, FORCE_ENCODING_PROFILE).orNull());
        if (forceEncoding && profileNameOpt.isEmpty()) {
            throw new WorkflowOperationException("Force encoding profile must be set!");
        }
        String profileName = profileNameOpt.get();
        EncodingProfile profile = this.composerService.getProfile(profileName);
        if (profile == null) {
            throw new WorkflowOperationException("Force encoding profile '" + profileName + "' was not found");
        }
        return Optional.of(profile);
    }

    private MediaPackageElementFlavor parseTargetFlavor(String flavor, String flavorType) throws WorkflowOperationException {
        MediaPackageElementFlavor targetFlavor;
        try {
            targetFlavor = MediaPackageElementFlavor.parseFlavor((String)flavor);
            if ("*".equals(targetFlavor.getType()) || "*".equals(targetFlavor.getSubtype())) {
                throw new WorkflowOperationException(String.format("Target %s flavor must have a type and a subtype, '*' are not allowed!", flavorType));
            }
        }
        catch (IllegalArgumentException e) {
            throw new WorkflowOperationException(String.format("Target %s flavor '%s' is malformed", flavorType, flavor));
        }
        return targetFlavor;
    }

    private MediaPackageElementFlavor deriveAudioFlavor(MediaPackageElementFlavor flavor) {
        return MediaPackageElementFlavor.flavor((String)flavor.getType().concat(FLAVOR_AUDIO_SUFFIX), (String)flavor.getSubtype());
    }

    private Dimension determineDimension(List<Track> tracks, boolean forceDivisible) {
        Tuple<Track, Dimension> trackDimension = this.getLargestTrack(tracks);
        if (trackDimension == null) {
            return null;
        }
        if (forceDivisible && (((Dimension)trackDimension.getB()).getHeight() % 2 != 0 || ((Dimension)trackDimension.getB()).getWidth() % 2 != 0)) {
            Dimension scaledDimension = Dimension.dimension((int)(((Dimension)trackDimension.getB()).getWidth() / 2 * 2), (int)(((Dimension)trackDimension.getB()).getHeight() / 2 * 2));
            logger.info("Determined output dimension {} scaled down from {} for track {}", new Object[]{scaledDimension, trackDimension.getB(), trackDimension.getA()});
            return scaledDimension;
        }
        logger.info("Determined output dimension {} for track {}", trackDimension.getB(), trackDimension.getA());
        return (Dimension)trackDimension.getB();
    }

    private Tuple<Track, Dimension> getLargestTrack(List<Track> tracks) {
        Track track = null;
        Dimension dimension = null;
        for (Track t : tracks) {
            if (!t.hasVideo()) continue;
            VideoStream[] videoStreams = (VideoStream[])TrackSupport.byType((Stream[])t.getStreams(), VideoStream.class);
            int frameWidth = videoStreams[0].getFrameWidth();
            int frameHeight = videoStreams[0].getFrameHeight();
            if (dimension != null && frameWidth * frameHeight <= dimension.getWidth() * dimension.getHeight()) continue;
            dimension = Dimension.dimension((int)frameWidth, (int)frameHeight);
            track = t;
        }
        if (track == null || dimension == null) {
            return null;
        }
        return Tuple.tuple(track, dimension);
    }

    private long checkForTrimming(MediaPackage mediaPackage, EncodingProfile trimProfile, MediaPackageElementFlavor targetFlavor, Float videoDuration, List<MediaPackageElement> elementsToClean) throws EncoderException, MediaPackageException, WorkflowOperationException, NotFoundException, ServiceRegistryException, IOException {
        MediaPackageElement[] elements = mediaPackage.getElementsByFlavor(targetFlavor);
        if (elements.length == 0) {
            return 0L;
        }
        Track trackToTrim = (Track)elements[0];
        if (elements.length == 1 && (float)(trackToTrim.getDuration() / 1000L) > videoDuration.floatValue()) {
            Long trimSeconds = (long)((float)(trackToTrim.getDuration() / 1000L) - videoDuration.floatValue());
            logger.info("Shorten track {} to target duration {} by {} seconds", new Object[]{trackToTrim.toString(), videoDuration.toString(), trimSeconds.toString()});
            return this.trimEnd(mediaPackage, trimProfile, trackToTrim, videoDuration.floatValue(), elementsToClean);
        }
        if (elements.length > 1) {
            logger.warn("Multiple tracks with flavor {} found! Trimming not possible!", (Object)targetFlavor);
        }
        return 0L;
    }

    private List<Track> getPureVideoTracks(MediaPackage mediaPackage, MediaPackageElementFlavor videoFlavor) {
        return Arrays.stream(mediaPackage.getTracks()).filter(track -> track.getFlavor().matches(videoFlavor)).filter(Track::hasVideo).filter(track -> !track.hasAudio()).collect(Collectors.toList());
    }

    private List<Track> getPureAudioTracks(MediaPackage mediaPackage, MediaPackageElementFlavor audioFlavor) {
        return Arrays.stream(mediaPackage.getTracks()).filter(track -> track.getFlavor().matches(audioFlavor)).filter(Track::hasAudio).filter(track -> !track.hasVideo()).collect(Collectors.toList());
    }

    protected long checkForMuxing(MediaPackage mediaPackage, MediaPackageElementFlavor targetPresentationFlavor, MediaPackageElementFlavor targetPresenterFlavor, boolean useSuffix, List<MediaPackageElement> elementsToClean) throws EncoderException, MediaPackageException, WorkflowOperationException, NotFoundException, ServiceRegistryException, IOException {
        long queueTime = 0L;
        List<Track> videoElements = this.getPureVideoTracks(mediaPackage, targetPresentationFlavor);
        List<Track> audioElements = useSuffix ? this.getPureAudioTracks(mediaPackage, this.deriveAudioFlavor(targetPresentationFlavor)) : this.getPureAudioTracks(mediaPackage, targetPresentationFlavor);
        Track videoTrack = null;
        Track audioTrack = null;
        if (videoElements.size() == 1 && audioElements.size() == 0) {
            videoTrack = videoElements.get(0);
        } else if (videoElements.size() == 0 && audioElements.size() == 1) {
            audioTrack = audioElements.get(0);
        }
        videoElements = this.getPureVideoTracks(mediaPackage, targetPresenterFlavor);
        audioElements = useSuffix ? this.getPureAudioTracks(mediaPackage, this.deriveAudioFlavor(targetPresenterFlavor)) : this.getPureAudioTracks(mediaPackage, targetPresenterFlavor);
        if (videoElements.size() == 1 && audioElements.size() == 0) {
            videoTrack = videoElements.get(0);
        } else if (videoElements.size() == 0 && audioElements.size() == 1) {
            audioTrack = audioElements.get(0);
        }
        logger.debug("Check for mux between '{}' and '{}' flavors and found video track '{}' and audio track '{}'", new Object[]{targetPresentationFlavor, targetPresenterFlavor, videoTrack, audioTrack});
        if (videoTrack != null && audioTrack != null) {
            return queueTime += this.mux(mediaPackage, videoTrack, audioTrack, elementsToClean);
        }
        return queueTime;
    }

    protected long mux(MediaPackage mediaPackage, Track video, Track audio, List<MediaPackageElement> elementsToClean) throws EncoderException, MediaPackageException, WorkflowOperationException, NotFoundException, ServiceRegistryException, IOException {
        logger.debug("Muxing video {} and audio {}", (Object)video.getURI(), (Object)audio.getURI());
        Job muxJob = this.composerService.mux(video, audio, "mux-av.copy");
        if (!this.waitForStatus(new Job[]{muxJob}).isSuccess()) {
            throw new WorkflowOperationException("Muxing of audio " + String.valueOf(audio) + " and video " + String.valueOf(video) + " failed");
        }
        Track muxed = (Track)MediaPackageElementParser.getFromXml((String)(muxJob = this.serviceRegistry.getJob(muxJob.getId())).getPayload());
        if (muxed == null) {
            throw new WorkflowOperationException("Muxed job " + String.valueOf(muxJob) + " returned no payload!");
        }
        muxed.setFlavor(video.getFlavor());
        muxed.setURI(this.workspace.moveTo(muxed.getURI(), mediaPackage.getIdentifier().toString(), muxed.getIdentifier(), FilenameUtils.getName((String)video.getURI().toString())));
        elementsToClean.add((MediaPackageElement)audio);
        mediaPackage.remove(audio);
        elementsToClean.add((MediaPackageElement)video);
        mediaPackage.remove(video);
        mediaPackage.add(muxed);
        return muxJob.getQueueTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPartialToSource(MediaPackage mediaPackage, MediaPackageElementFlavor targetFlavor, Track track) throws NotFoundException, IOException {
        FileInputStream in = null;
        try {
            Track copyTrack = (Track)track.clone();
            File originalFile = this.workspace.get(copyTrack.getURI());
            in = new FileInputStream(originalFile);
            String elementID = UUID.randomUUID().toString();
            copyTrack.setURI(this.workspace.put(mediaPackage.getIdentifier().toString(), elementID, FilenameUtils.getName((String)copyTrack.getURI().toString()), (InputStream)in));
            copyTrack.setFlavor(targetFlavor);
            copyTrack.setIdentifier(elementID);
            copyTrack.referTo((MediaPackageElement)track);
            mediaPackage.add(copyTrack);
            logger.info("Copied partial source element {} to {} with target flavor {}", new Object[]{track.toString(), copyTrack.toString(), targetFlavor.toString()});
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    private List<Track> preencode(EncodingProfile profile, List<Track> tracks) throws MediaPackageException, EncoderException, WorkflowOperationException, NotFoundException, ServiceRegistryException {
        ArrayList<Track> encodedTracks = new ArrayList<Track>();
        for (Track track : tracks) {
            logger.info("Preencoding track {}", (Object)track.getIdentifier());
            Job encodeJob = this.composerService.encode(track, profile.getIdentifier());
            if (!this.waitForStatus(new Job[]{encodeJob}).isSuccess()) {
                throw new WorkflowOperationException("Encoding of track " + String.valueOf(track) + " failed");
            }
            Track encodedTrack = (Track)MediaPackageElementParser.getFromXml((String)(encodeJob = this.serviceRegistry.getJob(encodeJob.getId())).getPayload());
            if (encodedTrack == null) {
                throw new WorkflowOperationException("Encoded track " + String.valueOf(track) + " failed to produce a track");
            }
            encodedTrack.setIdentifier(track.getIdentifier());
            encodedTrack.setFlavor(track.getFlavor());
            encodedTracks.add(encodedTrack);
        }
        return encodedTracks;
    }

    private long encodeToStandard(MediaPackage mp, EncodingProfile profile, MediaPackageElementFlavor targetFlavor, Track track) throws EncoderException, MediaPackageException, WorkflowOperationException, NotFoundException, ServiceRegistryException, IOException {
        Job encodeJob = this.composerService.encode(track, profile.getIdentifier());
        if (!this.waitForStatus(new Job[]{encodeJob}).isSuccess()) {
            throw new WorkflowOperationException("Encoding of track " + String.valueOf(track) + " failed");
        }
        Track encodedTrack = (Track)MediaPackageElementParser.getFromXml((String)(encodeJob = this.serviceRegistry.getJob(encodeJob.getId())).getPayload());
        if (encodedTrack == null) {
            throw new WorkflowOperationException("Encoded track " + String.valueOf(track) + " failed to produce a track");
        }
        URI uri = FilenameUtils.getExtension((String)encodedTrack.getURI().toString()).equalsIgnoreCase(FilenameUtils.getExtension((String)track.getURI().toString())) ? this.workspace.moveTo(encodedTrack.getURI(), mp.getIdentifier().toString(), encodedTrack.getIdentifier(), FilenameUtils.getName((String)track.getURI().toString())) : this.workspace.moveTo(encodedTrack.getURI(), mp.getIdentifier().toString(), encodedTrack.getIdentifier(), FilenameUtils.getBaseName((String)track.getURI().toString()) + "." + FilenameUtils.getExtension((String)encodedTrack.getURI().toString()));
        encodedTrack.setURI(uri);
        encodedTrack.setFlavor(targetFlavor);
        mp.add(encodedTrack);
        return encodeJob.getQueueTime();
    }

    private long trimEnd(MediaPackage mediaPackage, EncodingProfile trimProfile, Track track, double duration, List<MediaPackageElement> elementsToClean) throws EncoderException, MediaPackageException, WorkflowOperationException, NotFoundException, ServiceRegistryException, IOException {
        Job trimJob = this.composerService.trim(track, trimProfile.getIdentifier(), 0L, (long)(duration * 1000.0));
        if (!this.waitForStatus(new Job[]{trimJob}).isSuccess()) {
            throw new WorkflowOperationException("Trimming of track " + String.valueOf(track) + " failed");
        }
        Track trimmedTrack = (Track)MediaPackageElementParser.getFromXml((String)(trimJob = this.serviceRegistry.getJob(trimJob.getId())).getPayload());
        if (trimmedTrack == null) {
            throw new WorkflowOperationException("Trimming track " + String.valueOf(track) + " failed to produce a track");
        }
        URI uri = this.workspace.moveTo(trimmedTrack.getURI(), mediaPackage.getIdentifier().toString(), trimmedTrack.getIdentifier(), FilenameUtils.getName((String)track.getURI().toString()));
        trimmedTrack.setURI(uri);
        trimmedTrack.setFlavor(track.getFlavor());
        elementsToClean.add((MediaPackageElement)track);
        mediaPackage.remove(track);
        mediaPackage.add(trimmedTrack);
        return trimJob.getQueueTime();
    }

    private long processChildren(long position, List<Track> tracks, NodeList children, List<Track> originalTracks, VCell<String> type, String mediaType, List<MediaPackageElement> elementsToClean, Long operationId) throws EncoderException, MediaPackageException, WorkflowOperationException, NotFoundException, IOException {
        for (int j = 0; j < children.getLength(); ++j) {
            Track track;
            Node item = children.item(j);
            if (item.hasChildNodes()) {
                position = this.processChildren(position, tracks, item.getChildNodes(), originalTracks, type, mediaType, elementsToClean, operationId);
                continue;
            }
            SMILMediaElement e = (SMILMediaElement)item;
            if (!mediaType.equals(e.getNodeName())) continue;
            try {
                track = this.getFromOriginal(e.getId(), originalTracks, type);
            }
            catch (IllegalStateException exception) {
                logger.debug("Skipping smil entry, reason: " + exception.getMessage());
                continue;
            }
            double beginInSeconds = e.getBegin().item(0).getResolvedOffset();
            long beginInMs = Math.round(beginInSeconds * 1000.0);
            if (beginInMs > position) {
                double positionInSeconds = (double)position / 1000.0;
                if (position == 0L) {
                    if (NODE_TYPE_AUDIO.equals(e.getNodeName())) {
                        logger.info("Extending {} audio track start by {} seconds silent audio", type.get(), (Object)beginInSeconds);
                        tracks.add(this.getSilentAudio(beginInSeconds, elementsToClean, operationId));
                    } else {
                        logger.info("Extending {} track start image frame by {} seconds", type.get(), (Object)beginInSeconds);
                        Attachment tempFirstImageFrame = this.extractImage(track, 0.0, elementsToClean);
                        tracks.add(this.createVideoFromImage(tempFirstImageFrame, beginInSeconds, elementsToClean));
                    }
                    position += beginInMs;
                } else {
                    double fillTime = (double)(beginInMs - position) / 1000.0;
                    if (NODE_TYPE_AUDIO.equals(e.getNodeName())) {
                        logger.info("Fill {} audio track gap from {} to {} with silent audio", new Object[]{type.get(), Double.toString(positionInSeconds), Double.toString(beginInSeconds)});
                        tracks.add(this.getSilentAudio(fillTime, elementsToClean, operationId));
                    } else {
                        logger.info("Fill {} track gap from {} to {} with image frame", new Object[]{type.get(), Double.toString(positionInSeconds), Double.toString(beginInSeconds)});
                        Track previousTrack = tracks.get(tracks.size() - 1);
                        Attachment tempLastImageFrame = this.extractLastImageFrame(previousTrack, elementsToClean);
                        tracks.add(this.createVideoFromImage(tempLastImageFrame, fillTime, elementsToClean));
                    }
                    position = beginInMs;
                }
            }
            tracks.add(track);
            position += (long)Math.round(e.getDur() * 1000.0f);
        }
        return position;
    }

    private Track getFromOriginal(String trackId, List<Track> originalTracks, VCell<String> type) {
        for (Track t : originalTracks) {
            if (!t.getIdentifier().contains(trackId)) continue;
            logger.debug("Track-Id from smil found in Mediapackage ID: " + t.getIdentifier());
            if (EMPTY_VALUE.equals(type.get())) {
                String suffix = t.hasAudio() && !t.hasVideo() ? FLAVOR_AUDIO_SUFFIX : EMPTY_VALUE;
                type.set((Object)(t.getFlavor().getType() + suffix));
            }
            originalTracks.remove(t);
            return t;
        }
        throw new IllegalStateException("No track matching smil Track-id: " + trackId);
    }

    private Track getSilentAudio(double time, List<MediaPackageElement> elementsToClean, Long operationId) throws EncoderException, MediaPackageException, WorkflowOperationException, NotFoundException, IOException {
        URI uri = this.workspace.putInCollection(COLLECTION_ID, operationId + "-silent", (InputStream)new ByteArrayInputStream(EMPTY_VALUE.getBytes()));
        Attachment emptyAttachment = (Attachment)MediaPackageElementBuilderFactory.newInstance().newElementBuilder().elementFromURI(uri, MediaPackageElement.Type.Attachment, MediaPackageElementFlavor.parseFlavor((String)"audio/silent"));
        elementsToClean.add((MediaPackageElement)emptyAttachment);
        Job silentAudioJob = this.composerService.imageToVideo(emptyAttachment, SILENT_AUDIO_PROFILE, time);
        if (!this.waitForStatus(new Job[]{silentAudioJob}).isSuccess()) {
            throw new WorkflowOperationException("Silent audio job did not complete successfully");
        }
        try {
            Iterator iterator = JobUtil.getPayload((ServiceRegistry)this.serviceRegistry, (Job)silentAudioJob).iterator();
            if (iterator.hasNext()) {
                String payload = (String)iterator.next();
                Track silentAudio = (Track)MediaPackageElementParser.getFromXml((String)payload);
                elementsToClean.add((MediaPackageElement)silentAudio);
                return silentAudio;
            }
            throw new WorkflowOperationException(String.format("Job %s has no payload or cannot be updated", silentAudioJob));
        }
        catch (ServiceRegistryException ex) {
            throw new WorkflowOperationException((Throwable)ex);
        }
    }

    private Track createVideoFromImage(Attachment image, double time, List<MediaPackageElement> elementsToClean) throws EncoderException, MediaPackageException, WorkflowOperationException, NotFoundException {
        Job imageToVideoJob = this.composerService.imageToVideo(image, IMAGE_MOVIE_PROFILE, time);
        if (!this.waitForStatus(new Job[]{imageToVideoJob}).isSuccess()) {
            throw new WorkflowOperationException("Image to video job did not complete successfully");
        }
        try {
            imageToVideoJob = this.serviceRegistry.getJob(imageToVideoJob.getId());
        }
        catch (ServiceRegistryException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        Track imageVideo = (Track)MediaPackageElementParser.getFromXml((String)imageToVideoJob.getPayload());
        elementsToClean.add((MediaPackageElement)imageVideo);
        return imageVideo;
    }

    private Attachment extractImage(Track presentationTrack, double time, List<MediaPackageElement> elementsToClean) throws EncoderException, MediaPackageException, WorkflowOperationException, NotFoundException {
        Job extractImageJob = this.composerService.image(presentationTrack, PREVIEW_PROFILE, new double[]{time});
        if (!this.waitForStatus(new Job[]{extractImageJob}).isSuccess()) {
            throw new WorkflowOperationException("Extract image frame video job did not complete successfully");
        }
        try {
            extractImageJob = this.serviceRegistry.getJob(extractImageJob.getId());
        }
        catch (ServiceRegistryException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        Attachment composedImages = (Attachment)MediaPackageElementParser.getArrayFromXml((String)extractImageJob.getPayload()).get(0);
        elementsToClean.add((MediaPackageElement)composedImages);
        return composedImages;
    }

    private Attachment extractLastImageFrame(Track presentationTrack, List<MediaPackageElement> elementsToClean) throws EncoderException, MediaPackageException, WorkflowOperationException, NotFoundException {
        HashMap properties = new HashMap();
        Job extractImageJob = this.composerService.image(presentationTrack, IMAGE_FRAME_PROFILE, properties);
        if (!this.waitForStatus(new Job[]{extractImageJob}).isSuccess()) {
            throw new WorkflowOperationException("Extract image frame video job did not complete successfully");
        }
        try {
            extractImageJob = this.serviceRegistry.getJob(extractImageJob.getId());
        }
        catch (ServiceRegistryException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        Attachment composedImages = (Attachment)MediaPackageElementParser.getArrayFromXml((String)extractImageJob.getPayload()).get(0);
        elementsToClean.add((MediaPackageElement)composedImages);
        return composedImages;
    }
}

