/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.composer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.AdaptivePlaylist;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.AbstractMediaPackageElementSelector;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=MultiEncode Workflow Operation Handler", "workflow.operation=multiencode"})
public class MultiEncodeWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(MultiEncodeWorkflowOperationHandler.class);
    static final String SEPARATOR = ";";
    private ComposerService composerService = null;
    private Workspace workspace = null;
    private Predicate<EncodingProfile> isManifestEP = p -> p.getOutputType() == EncodingProfile.MediaType.Manifest;

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
    }

    @Reference
    protected void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running Multiencode workflow operation on workflow {}", (Object)workflowInstance.getId());
        try {
            return this.multiencode(workflowInstance.getMediaPackage(), workflowInstance.getCurrentOperation());
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    private List<ElementProfileTagFlavor> getSrcSelector(String[] sourceFlavors, String[] sourceTags, String[] targetFlavors, String[] targetTags, String[] profiles) throws WorkflowOperationException {
        int n = 0;
        ArrayList<ElementProfileTagFlavor> elementSelectors = new ArrayList<ElementProfileTagFlavor>();
        if (sourceTags == null && sourceFlavors == null) {
            throw new WorkflowOperationException("No source tags or Flavor");
        }
        if (profiles == null) {
            throw new WorkflowOperationException("Missing profiles");
        }
        if (sourceTags != null) {
            if (targetTags != null && targetTags.length != 1 && sourceTags.length != targetTags.length) {
                throw new WorkflowOperationException("number of source tags " + sourceTags.length + " does not match number of target tags " + targetTags.length + " (must be the same or one target)");
            }
            if (profiles.length != 1 && sourceTags.length != profiles.length) {
                throw new WorkflowOperationException("number of source tags segments " + sourceTags.length + " does not match number of profiles segments " + profiles.length + " (must be the same or one profile)");
            }
            if (sourceFlavors != null && sourceTags.length != 1 && sourceFlavors.length != 1 && sourceFlavors.length != sourceTags.length) {
                throw new WorkflowOperationException("number of source tags segments " + sourceTags.length + " does not match number of source Flavor segments " + sourceFlavors.length + " (must be the same or one)");
            }
            n = sourceTags.length;
        }
        if (sourceFlavors != null) {
            if (targetFlavors != null && targetFlavors.length != 1 && sourceFlavors.length != targetFlavors.length) {
                throw new WorkflowOperationException("number of source flavors " + sourceFlavors.length + " segment does not match number of target flavors" + targetFlavors.length + " (must be the same or one target flavor)");
            }
            if (targetTags != null && targetTags.length != 1 && sourceFlavors.length != targetTags.length) {
                throw new WorkflowOperationException("number of source flavors " + sourceFlavors.length + " segment does not match number of target Tags" + targetTags.length + " (must be the same or one target)");
            }
            if (profiles.length != 1 && sourceFlavors.length != profiles.length) {
                throw new WorkflowOperationException("number of source flavors segments " + sourceFlavors.length + " does not match number of profiles segments " + profiles.length + " (must be the same or one profile)");
            }
            if (sourceFlavors.length > n) {
                n = sourceFlavors.length;
            }
        }
        int numProfiles = 0;
        for (int i = 0; i < n; ++i) {
            elementSelectors.add(new ElementProfileTagFlavor(this, profiles[numProfiles]));
            if (profiles.length <= 1) continue;
            ++numProfiles;
        }
        if (sourceTags != null && sourceFlavors != null && sourceTags.length != sourceFlavors.length && sourceFlavors.length != 1 && sourceTags.length != 1) {
            throw new WorkflowOperationException("number of source flavors " + sourceTags.length + " does not match number of source tags " + sourceFlavors.length + " (must be the same or one set of tags or flavors)");
        }
        this.populateFlavorsAndTags(elementSelectors, sourceFlavors, targetFlavors, sourceTags, targetTags);
        return elementSelectors;
    }

    private List<ElementProfileTagFlavor> populateFlavorsAndTags(List<ElementProfileTagFlavor> elementSelectors, String[] sourceFlavors, String[] targetFlavors, String[] sourceTags, String[] targetTags) throws WorkflowOperationException {
        int sf = 0;
        int tf = 0;
        int st = 0;
        int tt = 0;
        for (ElementProfileTagFlavor ep : elementSelectors) {
            try {
                if (sourceTags != null) {
                    for (String tag : this.asList(sourceTags[st])) {
                        ep.addSourceTag(tag);
                    }
                    if (sourceTags.length != 1) {
                        ++st;
                    }
                }
                if (targetTags != null) {
                    ep.setTargetTags(targetTags[tt]);
                    if (targetTags.length != 1) {
                        ++tt;
                    }
                }
                if (sourceFlavors != null) {
                    for (String flavor : this.asList(sourceFlavors[sf])) {
                        ep.addSourceFlavor(flavor);
                    }
                    if (sourceFlavors.length != 1) {
                        ++sf;
                    }
                }
                if (targetFlavors == null) continue;
                for (String flavor : this.asList(targetFlavors[tf])) {
                    ep.setTargetFlavor(flavor);
                }
                if (targetFlavors.length == 1) continue;
                ++tf;
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowOperationException("Set Tags or Flavor " + e.getMessage());
            }
        }
        return elementSelectors;
    }

    private String[] getConfigAsArray(WorkflowOperationInstance operation, String name) {
        String sourceOption = StringUtils.trimToNull((String)operation.getConfiguration(name));
        return StringUtils.split((String)sourceOption, (String)SEPARATOR);
    }

    private List<Track> getManifest(Collection<Track> tracks) {
        return tracks.stream().filter(AdaptivePlaylist.isHLSTrackPred).collect(Collectors.toList());
    }

    private WorkflowOperationResult multiencode(MediaPackage src, WorkflowOperationInstance operation) throws EncoderException, IOException, NotFoundException, MediaPackageException, WorkflowOperationException {
        MediaPackage mediaPackage = (MediaPackage)src.clone();
        String[] sourceTags = this.getConfigAsArray(operation, "source-tags");
        String[] sourceFlavors = this.getConfigAsArray(operation, "source-flavors");
        String[] targetTags = this.getConfigAsArray(operation, "target-tags");
        String[] targetFlavors = this.getConfigAsArray(operation, "target-flavors");
        String tagWithProfileConfig = StringUtils.trimToNull((String)operation.getConfiguration("tag-with-profile"));
        boolean tagWithProfile = BooleanUtils.toBoolean((String)tagWithProfileConfig);
        if (sourceFlavors == null && sourceTags == null) {
            logger.info("No source tags or flavors have been specified, not matching anything");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        String[] profiles = this.getConfigAsArray(operation, "encoding-profiles");
        if (profiles == null) {
            throw new WorkflowOperationException("Missing encoding profiles");
        }
        List<ElementProfileTagFlavor> selectors = this.getSrcSelector(sourceFlavors, sourceTags, targetFlavors, targetTags, profiles);
        long totalTimeInQueue = 0L;
        HashMap<Job, JobInformation> encodingJobs = new HashMap<Job, JobInformation>();
        for (ElementProfileTagFlavor elementProfileTagFlavor : selectors) {
            Collection elements = elementProfileTagFlavor.elementSelector.select(mediaPackage, true);
            for (Track sourceTrack : elements) {
                logger.info("Encoding track {} using encoding profile '{}'", (Object)sourceTrack, (Object)elementProfileTagFlavor.getProfiles().get(0).toString());
                encodingJobs.put(this.composerService.multiEncode(sourceTrack, elementProfileTagFlavor.getProfiles()), new JobInformation(sourceTrack, elementProfileTagFlavor, tagWithProfile));
            }
        }
        if (encodingJobs.isEmpty()) {
            logger.info("No matching tracks found");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        if (!this.waitForStatus(encodingJobs.keySet().toArray(new Job[encodingJobs.size()])).isSuccess()) {
            throw new WorkflowOperationException("One of the encoding jobs did not complete successfully");
        }
        for (Map.Entry entry : encodingJobs.entrySet()) {
            Job job = (Job)entry.getKey();
            Track sourceTrack = ((JobInformation)entry.getValue()).getTrack();
            ElementProfileTagFlavor info = ((JobInformation)entry.getValue()).getInfo();
            List<EncodingProfile> eplist = ((JobInformation)entry.getValue()).getProfileList();
            totalTimeInQueue += job.getQueueTime().longValue();
            if (job.getPayload().length() > 0) {
                List composedTracks = MediaPackageElementParser.getArrayFromXml((String)job.getPayload());
                boolean isHLS = eplist.stream().anyMatch(this.isManifestEP);
                if (isHLS) {
                    this.decipherHLSPlaylistResults(sourceTrack, (JobInformation)entry.getValue(), mediaPackage, composedTracks);
                } else if (composedTracks.size() != info.getProfiles().size()) {
                    logger.info("Encoded {} tracks, with {} profiles", (Object)composedTracks.size(), (Object)info.getProfiles().size());
                    throw new WorkflowOperationException("Number of output tracks does not match number of encoding profiles");
                }
                for (Track composedTrack : composedTracks) {
                    if (info.getTargetFlavor() != null) {
                        composedTrack.setFlavor(this.newFlavor(sourceTrack, info.getTargetFlavor()));
                        logger.debug("Composed track has flavor '{}'", (Object)composedTrack.getFlavor());
                    }
                    if (info.getTargetTags() != null) {
                        for (String tag : this.asList(info.getTargetTags())) {
                            logger.trace("Tagging composed track with '{}'", (Object)tag);
                            composedTrack.addTag(tag);
                        }
                    }
                    if (((JobInformation)entry.getValue()).getTagWithProfile()) {
                        this.tagByProfile(composedTrack, eplist);
                    }
                    String fileName = !isHLS || composedTrack.isMaster() != false ? this.getFileNameFromElements((MediaPackageElement)sourceTrack, (MediaPackageElement)composedTrack) : FilenameUtils.getName((String)composedTrack.getURI().getPath());
                    composedTrack.setURI(this.workspace.moveTo(composedTrack.getURI(), mediaPackage.getIdentifier().toString(), composedTrack.getIdentifier(), fileName));
                    mediaPackage.addDerived((MediaPackageElement)composedTrack, (MediaPackageElement)sourceTrack);
                }
                continue;
            }
            logger.warn("No output from MultiEncode operation");
        }
        WorkflowOperationResult result = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, totalTimeInQueue);
        logger.debug("MultiEncode operation completed");
        return result;
    }

    private void tagByProfile(Track track, List<EncodingProfile> profiles) {
        String rawfileName = track.getURI().getRawPath();
        for (EncodingProfile ep : profiles) {
            String suffixToSanitize = "X" + ep.getSuffix();
            String suffix = this.workspace.toSafeName(suffixToSanitize).substring(1);
            if (suffix.length() <= 0 || !rawfileName.endsWith(suffix)) continue;
            track.addTag(ep.getIdentifier());
            return;
        }
    }

    private void decipherHLSPlaylistResults(Track track, JobInformation jobInfo, MediaPackage mediaPackage, List<Track> composedTracks) throws WorkflowOperationException, IllegalArgumentException, NotFoundException, IOException {
        int nprofiles = jobInfo.getInfo().getProfiles().size();
        List<Track> manifests = this.getManifest(composedTracks);
        if (manifests.size() != nprofiles) {
            throw new WorkflowOperationException("Number of output playlists does not match number of encoding profiles");
        }
        if (composedTracks.size() != manifests.size() * 2 - 1) {
            throw new WorkflowOperationException("Number of output media does not match number of encoding profiles");
        }
    }

    private MediaPackageElementFlavor newFlavor(Track track, String flavor) throws WorkflowOperationException {
        if (StringUtils.isNotBlank((CharSequence)flavor)) {
            try {
                MediaPackageElementFlavor targetFlavor = MediaPackageElementFlavor.parseFlavor((String)flavor);
                String flavorType = targetFlavor.getType();
                String flavorSubtype = targetFlavor.getSubtype();
                if ("*".equals(flavorType)) {
                    flavorType = track.getFlavor().getType();
                }
                if ("*".equals(flavorSubtype)) {
                    flavorSubtype = track.getFlavor().getSubtype();
                }
                return new MediaPackageElementFlavor(flavorType, flavorSubtype);
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowOperationException("Target flavor '" + flavor + "' is malformed");
            }
        }
        return null;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    protected class ElementProfileTagFlavor {
        private AbstractMediaPackageElementSelector<Track> elementSelector = new TrackSelector();
        private String targetFlavor = null;
        private String targetTags = null;
        private List<String> encodingProfiles = new ArrayList<String>();
        private List<EncodingProfile> encodingProfileList = new ArrayList<EncodingProfile>();

        ElementProfileTagFlavor(MultiEncodeWorkflowOperationHandler this$0, String profiles) {
            List profilelist = this$0.asList(profiles);
            for (String profile : profilelist) {
                EncodingProfile encodingprofile = this$0.composerService.getProfile(profile);
                if (encodingprofile != null) {
                    this.encodingProfiles.add(encodingprofile.getIdentifier());
                    this.encodingProfileList.add(encodingprofile);
                    continue;
                }
                throw new IllegalArgumentException("Encoding profile " + profile + " not found.");
            }
        }

        public AbstractMediaPackageElementSelector<Track> getSelector() {
            return this.elementSelector;
        }

        public List<String> getProfiles() {
            return this.encodingProfiles;
        }

        public List<EncodingProfile> getEncodingProfiles() {
            return this.encodingProfileList;
        }

        void addSourceFlavor(String flavor) {
            this.elementSelector.addFlavor(MediaPackageElementFlavor.parseFlavor((String)flavor));
        }

        void addSourceTag(String tag) {
            this.elementSelector.addTag(tag);
        }

        void setTargetTags(String tags) {
            this.targetTags = tags;
        }

        void setTargetFlavor(String flavor) {
            this.targetFlavor = flavor;
        }

        String getTargetFlavor() {
            return this.targetFlavor;
        }

        String getTargetTags() {
            return this.targetTags;
        }
    }

    private static final class JobInformation {
        private Track track = null;
        private ElementProfileTagFlavor info = null;
        private boolean tagWithProfile;

        JobInformation(Track track, ElementProfileTagFlavor info, boolean tagWithProfile) {
            this.track = track;
            this.info = info;
            this.tagWithProfile = tagWithProfile;
        }

        public List<EncodingProfile> getProfileList() {
            return this.info.encodingProfileList;
        }

        public Track getTrack() {
            return this.track;
        }

        public boolean getTagWithProfile() {
            return this.tagWithProfile;
        }

        public ElementProfileTagFlavor getInfo() {
            return this.info;
        }
    }
}

