/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.composer;

import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageSupport;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.JobUtil;
import org.opencastproject.util.data.Function;
import org.opencastproject.util.data.Function2;
import org.opencastproject.util.data.Monadics;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.functions.Booleans;
import org.opencastproject.util.data.functions.Misc;
import org.opencastproject.util.data.functions.Strings;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Image to Video Workflow Operation Handler", "workflow.operation=image-to-video"})
public class ImageToVideoWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final String OPT_DURATION = "duration";
    private static final String OPT_PROFILE = "profile";
    private static final Logger logger = LoggerFactory.getLogger(ImageToVideoWorkflowOperationHandler.class);
    private ComposerService composerService = null;
    private Workspace workspace = null;

    @Reference
    public void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running image to video workflow operation on workflow {}", (Object)workflowInstance.getId());
        try {
            return this.imageToVideo(workflowInstance.getMediaPackage(), workflowInstance);
        }
        catch (WorkflowOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    private WorkflowOperationResult imageToVideo(MediaPackage mp, WorkflowInstance wi) throws Exception {
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(wi, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many);
        List sourceTags = tagsAndFlavors.getSrcTags();
        List sourceFlavors = tagsAndFlavors.getSrcFlavors();
        if (sourceFlavors.isEmpty() && sourceTags.isEmpty()) {
            logger.warn("No source tags or flavor are given to determine the image to use");
            return this.createResult(mp, WorkflowOperationResult.Action.SKIP);
        }
        Option sourceFlavor = Option.option((Object)((MediaPackageElementFlavor)sourceFlavors.get(0)));
        List targetTags = tagsAndFlavors.getTargetTags();
        List targetFlavors = tagsAndFlavors.getTargetFlavors();
        Option targetFlavor = Option.option((Object)((MediaPackageElementFlavor)targetFlavors.get(0)));
        double duration = (Double)this.getCfg(wi, OPT_DURATION).bind(Strings.toDouble).getOrElse(this.cfgKeyMissing(OPT_DURATION));
        String profile = (String)this.getCfg(wi, OPT_PROFILE).getOrElse(this.cfgKeyMissing(OPT_PROFILE));
        List jobs = Monadics.mlist((Object[])mp.getAttachments()).filter((Function)sourceFlavor.map(MediaPackageSupport.Filters.matchesFlavor).getOrElse((Object)Booleans.yes())).filter(MediaPackageSupport.Filters.hasTagAny((List)sourceTags)).map(Misc.cast()).map(this.imageToVideo(profile, duration)).value();
        if (JobUtil.waitForJobs((ServiceRegistry)this.serviceRegistry, (Collection)jobs).isSuccess()) {
            for (Job job : jobs) {
                if (job.getPayload().length() > 0) {
                    Track track = (Track)MediaPackageElementParser.getFromXml((String)job.getPayload());
                    track.setURI(this.workspace.moveTo(track.getURI(), mp.getIdentifier().toString(), track.getIdentifier(), FilenameUtils.getName((String)track.getURI().toString())));
                    for (String tag : targetTags) {
                        track.addTag(tag);
                    }
                    for (MediaPackageElementFlavor flavor : targetFlavor) {
                        track.setFlavor(flavor);
                    }
                    mp.add(track);
                    logger.debug("Image to video operation completed");
                    continue;
                }
                logger.info("Image to video operation unsuccessful, no payload returned: {}", (Object)job);
                return this.createResult(mp, WorkflowOperationResult.Action.SKIP);
            }
            return this.createResult(mp, WorkflowOperationResult.Action.CONTINUE, (Long)Monadics.mlist((List)jobs).foldl((Object)0L, (Function2)new Function2<Long, Job, Long>(this){

                public Long apply(Long max, Job job) {
                    return Math.max(max, job.getQueueTime());
                }
            }));
        }
        throw new WorkflowOperationException("The image to video encoding jobs did not return successfully");
    }

    private Function<Attachment, Job> imageToVideo(final String profile, final double duration) {
        return new Function.X<Attachment, Job>(){

            protected Job xapply(Attachment attachment) throws MediaPackageException, EncoderException {
                logger.info("Converting image {} to a video of {} sec", (Object)attachment.getURI().toString(), (Object)duration);
                return ImageToVideoWorkflowOperationHandler.this.composerService.imageToVideo(attachment, profile, duration);
            }
        };
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

