/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.serviceregistry.impl.jpa;

import java.util.Date;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.opencastproject.serviceregistry.api.ServiceRegistration;
import org.opencastproject.serviceregistry.api.ServiceState;
import org.opencastproject.serviceregistry.impl.jpa.HostRegistrationJpaImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity(name="ServiceRegistration")
@Access(value=AccessType.FIELD)
@Table(name="oc_service_registration", indexes={@Index(name="IX_oc_service_registration_service_type", columnList="service_type"), @Index(name="IX_oc_service_registration_service_state", columnList="service_state"), @Index(name="IX_oc_service_registration_active", columnList="active"), @Index(name="IX_oc_service_registration_host_registration", columnList="host_registration")}, uniqueConstraints={@UniqueConstraint(name="UNQ_oc_service_registration", columnNames={"host_registration", "service_type"})})
@NamedQueries(value={@NamedQuery(name="ServiceRegistration.statistics", query="SELECT job.processorServiceRegistrationFK as serviceRegistration, job.status, count(job.status) as numJobs, avg(job.queueTime) as meanQueue, avg(job.runTime) as meanRun FROM Job job where job.dateCreated >= :minDateCreated and job.dateCreated <= :maxDateCreated group by job.processorServiceRegistrationFK, job.status"), @NamedQuery(name="ServiceRegistration.hostloads", query="SELECT job.processorServiceRegistration.hostRegistration.baseUrl as host, job.status, sum(job.jobLoad), job.processorServiceRegistration.hostRegistration.maxLoad FROM Job job WHERE job.processorServiceRegistration.online=true and job.processorServiceRegistration.active=true and job.processorServiceRegistration.hostRegistration.maintenanceMode=false AND job.status in :statuses AND job.creatorServiceRegistration.serviceType != :workflow_type GROUP BY job.processorServiceRegistration.hostRegistration.baseUrl, job.status, job.processorServiceRegistration.hostRegistration.maxLoad"), @NamedQuery(name="ServiceRegistration.getRegistration", query="SELECT r from ServiceRegistration r where r.hostRegistration.baseUrl = :host and r.serviceType = :serviceType"), @NamedQuery(name="ServiceRegistration.getAll", query="SELECT rh FROM ServiceRegistration rh WHERE rh.hostRegistration.active = true"), @NamedQuery(name="ServiceRegistration.getAllOnline", query="SELECT rh FROM ServiceRegistration rh WHERE rh.hostRegistration.online=true AND rh.hostRegistration.active = true"), @NamedQuery(name="ServiceRegistration.getByHost", query="SELECT rh FROM ServiceRegistration rh where rh.hostRegistration.baseUrl=:host AND rh.hostRegistration.active = true"), @NamedQuery(name="ServiceRegistration.getByType", query="SELECT rh FROM ServiceRegistration rh where rh.serviceType=:serviceType AND rh.hostRegistration.active = true"), @NamedQuery(name="ServiceRegistration.relatedservices.warning_error", query="SELECT rh FROM ServiceRegistration rh WHERE rh.serviceType = :serviceType AND (rh.serviceState = 1 OR rh.serviceState = 2)"), @NamedQuery(name="ServiceRegistration.relatedservices.warning", query="SELECT rh FROM ServiceRegistration rh WHERE rh.serviceType = :serviceType AND rh.serviceState = 1")})
public class ServiceRegistrationJpaImpl
implements ServiceRegistration {
    private static final Logger logger = LoggerFactory.getLogger(ServiceRegistrationJpaImpl.class);
    @Id
    @Column(name="id")
    @GeneratedValue
    private Long id;
    @Column(name="online_from")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date onlineFrom = new Date();
    @Column(name="service_type", nullable=false, length=255)
    private String serviceType;
    @ManyToOne
    @JoinColumn(name="host_registration")
    private HostRegistrationJpaImpl hostRegistration;
    @Column(name="path", nullable=false, length=255)
    private String path;
    @Column(name="service_state", nullable=false)
    private int serviceState = ServiceState.NORMAL.ordinal();
    @Column(name="state_changed")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date stateChanged = new Date();
    @Column(name="warning_state_trigger")
    private int warningStateTrigger;
    @Column(name="error_state_trigger")
    private int errorStateTrigger;
    @Column(name="active", nullable=false)
    private boolean active = true;
    @Column(name="online", nullable=false)
    private boolean online = true;
    @Column(name="job_producer", nullable=false)
    private boolean isJobProducer;
    @Transient
    private boolean maintenanceMode = false;
    @Transient
    private String host;

    public ServiceRegistrationJpaImpl() {
    }

    public ServiceRegistrationJpaImpl(HostRegistrationJpaImpl hostRegistration, String serviceType, String path) {
        this.hostRegistration = hostRegistration;
        this.serviceType = serviceType;
        this.path = path;
    }

    public ServiceRegistrationJpaImpl(HostRegistrationJpaImpl hostRegistration, String serviceType, String path, boolean jobProducer) {
        this.hostRegistration = hostRegistration;
        this.host = hostRegistration.getBaseUrl();
        this.serviceType = serviceType;
        this.path = path;
        this.isJobProducer = jobProducer;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getOnlineFrom() {
        return this.onlineFrom;
    }

    public void setOnlineFrom(Date onlineFrom) {
        this.onlineFrom = onlineFrom;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ServiceState getServiceState() {
        return ServiceState.values()[this.serviceState];
    }

    public void setServiceState(ServiceState serviceState) {
        this.serviceState = serviceState.ordinal();
    }

    public void setServiceState(ServiceState state, int triggerJobSignature) {
        this.setServiceState(state);
        this.setStateChanged(new Date());
        if (state == ServiceState.WARNING) {
            this.setWarningStateTrigger(triggerJobSignature);
        } else if (state == ServiceState.ERROR) {
            this.setErrorStateTrigger(triggerJobSignature);
        }
    }

    public Date getStateChanged() {
        return this.stateChanged;
    }

    public void setStateChanged(Date stateChanged) {
        this.stateChanged = stateChanged;
    }

    public int getWarningStateTrigger() {
        return this.warningStateTrigger;
    }

    public void setWarningStateTrigger(int warningStateTrigger) {
        this.warningStateTrigger = warningStateTrigger;
    }

    public int getErrorStateTrigger() {
        return this.errorStateTrigger;
    }

    public void setErrorStateTrigger(int errorStateTrigger) {
        this.errorStateTrigger = errorStateTrigger;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        if (online && !this.isOnline()) {
            this.setOnlineFrom(new Date());
        }
        this.online = online;
    }

    public boolean isJobProducer() {
        return this.isJobProducer;
    }

    public void setJobProducer(boolean isJobProducer) {
        this.isJobProducer = isJobProducer;
    }

    public boolean isInMaintenanceMode() {
        return this.maintenanceMode;
    }

    public String getHost() {
        return this.host;
    }

    public HostRegistrationJpaImpl getHostRegistration() {
        return this.hostRegistration;
    }

    public void setHostRegistration(HostRegistrationJpaImpl hostRegistration) {
        this.hostRegistration = hostRegistration;
    }

    @PostLoad
    public void postLoad() {
        if (this.hostRegistration == null) {
            logger.warn("host registration is null");
        } else {
            this.host = this.hostRegistration.getBaseUrl();
            this.maintenanceMode = this.hostRegistration.isMaintenanceMode();
            if (!this.hostRegistration.isOnline()) {
                this.online = false;
            }
            if (!this.hostRegistration.isActive()) {
                this.active = false;
            }
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceRegistration)) {
            return false;
        }
        ServiceRegistration registration = (ServiceRegistration)obj;
        return this.getHost().equals(registration.getHost()) && this.getServiceType().equals(registration.getServiceType());
    }

    public String toString() {
        return this.getServiceType() + "@" + this.getHost();
    }
}

