/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.serviceregistry.impl.jpa;

import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.opencastproject.serviceregistry.api.HostRegistration;

@Entity(name="HostRegistration")
@Access(value=AccessType.FIELD)
@Table(name="oc_host_registration", indexes={@Index(name="IX_oc_host_registration_online", columnList="online"), @Index(name="IX_oc_host_registration_active", columnList="active")}, uniqueConstraints={@UniqueConstraint(columnNames={"host"})})
@NamedQueries(value={@NamedQuery(name="HostRegistration.getMaxLoad", query="SELECT sum(hr.maxLoad) FROM HostRegistration hr where hr.active = true"), @NamedQuery(name="HostRegistration.getMaxLoadByHostName", query="SELECT hr.maxLoad FROM HostRegistration hr where hr.baseUrl = :host and hr.active = true"), @NamedQuery(name="HostRegistration.byHostName", query="SELECT hr from HostRegistration hr where hr.baseUrl = :host"), @NamedQuery(name="HostRegistration.jobStatistics", query="select j.processorServiceRegistration.hostRegistration.id, j.status, count(j) from Job j where j.status in :status group by j.processorServiceRegistration.hostRegistration.id, j.status"), @NamedQuery(name="HostRegistration.getAll", query="SELECT hr FROM HostRegistration hr where hr.active = true")})
public class HostRegistrationJpaImpl
implements HostRegistration {
    @Id
    @Column(name="id")
    @GeneratedValue
    private Long id;
    @Column(name="host", nullable=false)
    private String baseUrl;
    @Column(name="address", nullable=false, length=39)
    private String ipAddress;
    @Column(name="node_name")
    private String nodeName;
    @Column(name="memory", nullable=false)
    private long memory;
    @Column(name="cores", nullable=false)
    private int cores;
    @Column(name="max_load", nullable=false)
    private float maxLoad;
    @Column(name="online", nullable=false)
    private boolean online = true;
    @Column(name="active", nullable=false)
    private boolean active = true;
    @Column(name="maintenance", nullable=false)
    private boolean maintenanceMode = false;

    public HostRegistrationJpaImpl() {
    }

    public HostRegistrationJpaImpl(String baseUrl, String address, String nodeName, long memory, int cores, float maxLoad, boolean online, boolean maintenance) {
        this.baseUrl = baseUrl;
        this.ipAddress = address;
        this.nodeName = nodeName;
        this.memory = memory;
        this.cores = cores;
        this.maxLoad = maxLoad;
        this.online = online;
        this.maintenanceMode = maintenance;
        this.active = true;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String address) {
        this.ipAddress = address;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public long getMemory() {
        return this.memory;
    }

    public void setMemory(long memory) {
        this.memory = memory;
    }

    public int getCores() {
        return this.cores;
    }

    public void setCores(int cores) {
        this.cores = cores;
    }

    public float getMaxLoad() {
        return this.maxLoad;
    }

    public void setMaxLoad(float maxLoad) {
        this.maxLoad = maxLoad;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isMaintenanceMode() {
        return this.maintenanceMode;
    }

    public void setMaintenanceMode(boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HostRegistration)) {
            return false;
        }
        HostRegistration registration = (HostRegistration)obj;
        return this.baseUrl.equals(registration.getBaseUrl());
    }

    public String toString() {
        return this.baseUrl;
    }
}

