/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.impl.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.MapKeyColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.opencastproject.security.api.Organization;
import org.opencastproject.util.EqualsUtil;

@Entity
@Access(value=AccessType.FIELD)
@Table(name="oc_organization")
@NamedQueries(value={@NamedQuery(name="Organization.findAll", query="Select o FROM JpaOrganization o"), @NamedQuery(name="Organization.findById", query="Select o FROM JpaOrganization o where o.id = :id"), @NamedQuery(name="Organization.findByHost", query="Select o FROM JpaOrganization o JOIN o.servers s where key(s) = :serverName AND s = :port"), @NamedQuery(name="Organization.getCount", query="Select COUNT(o) FROM JpaOrganization o")})
public class JpaOrganization
implements Organization {
    @Id
    @Column(name="id", length=128)
    private String id;
    @Column(name="name")
    private String name;
    @ElementCollection
    @MapKeyColumn(name="name", nullable=false)
    @Column(name="port", nullable=false)
    @CollectionTable(name="oc_organization_node", joinColumns={@JoinColumn(name="organization", nullable=false)}, indexes={@Index(name="IX_oc_organization_node_pk", columnList="organization"), @Index(name="IX_oc_organization_node_name", columnList="name"), @Index(name="IX_oc_organization_node_port", columnList="port")}, uniqueConstraints={@UniqueConstraint(columnNames={"organization", "name", "port"})})
    private Map<String, Integer> servers;
    @Column(name="admin_role")
    private String adminRole;
    @Column(name="anonymous_role")
    private String anonymousRole;
    @Lob
    @ElementCollection
    @MapKeyColumn(name="name", nullable=false)
    @Column(name="value", length=65535)
    @CollectionTable(name="oc_organization_property", joinColumns={@JoinColumn(name="organization", nullable=false)})
    private Map<String, String> properties;

    public JpaOrganization() {
    }

    public JpaOrganization(String orgId, String name, String serverName, Integer serverPort, String adminRole, String anonymousRole, Map<String, String> properties) {
        this.id = orgId;
        this.name = name;
        this.servers = new HashMap<String, Integer>();
        this.servers.put(serverName, serverPort);
        this.adminRole = adminRole;
        this.anonymousRole = anonymousRole;
        this.properties = properties;
    }

    public JpaOrganization(String orgId, String name, Map<String, Integer> servers, String adminRole, String anonymousRole, Map<String, String> properties) {
        this.id = orgId;
        this.name = name;
        this.servers = servers;
        this.adminRole = adminRole;
        this.anonymousRole = anonymousRole;
        this.properties = properties;
    }

    public String getId() {
        return this.id;
    }

    public String getAnonymousRole() {
        return this.anonymousRole;
    }

    public void setAnonymousRole(String anonymousRole) {
        this.anonymousRole = anonymousRole;
    }

    public String getAdminRole() {
        return this.adminRole;
    }

    public void setAdminRole(String adminRole) {
        this.adminRole = adminRole;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, Integer> getServers() {
        return this.servers;
    }

    public void setServers(Map<String, Integer> servers) {
        this.servers = servers;
    }

    public void addServer(String serverName, Integer port) {
        if (this.servers == null) {
            this.servers = new HashMap<String, Integer>();
        }
        this.servers.put(serverName, port);
    }

    public void remove(String serverName, Integer port) {
        if (port.equals(this.servers.get(serverName))) {
            this.servers.remove(serverName);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Organization)) {
            return false;
        }
        return ((Organization)obj).getId().equals(this.id);
    }

    public int hashCode() {
        return EqualsUtil.hash((Object[])new Object[]{this.id});
    }

    public String toString() {
        return this.id;
    }
}

