/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.impl.jpa;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.opencastproject.security.api.Group;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.security.impl.jpa.JpaRole;
import org.opencastproject.util.EqualsUtil;

@Entity
@Access(value=AccessType.FIELD)
@Table(name="oc_group", uniqueConstraints={@UniqueConstraint(columnNames={"group_id", "organization"})})
@NamedQueries(value={@NamedQuery(name="Group.findAll", query="Select g FROM JpaGroup g WHERE g.organization.id = :organization"), @NamedQuery(name="Group.findByUser", query="Select g FROM JpaGroup g WHERE g.organization.id = :organization AND :username MEMBER OF g.members"), @NamedQuery(name="Group.findById", query="Select g FROM JpaGroup g WHERE g.groupId = :groupId AND g.organization.id = :organization"), @NamedQuery(name="Group.findByRole", query="Select g FROM JpaGroup g WHERE g.role = :role AND g.organization.id = :organization")})
public final class JpaGroup
implements Group {
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;
    @Column(name="group_id", length=128)
    private String groupId;
    @Column(name="name", length=128)
    private String name;
    @OneToOne
    @JoinColumn(name="organization")
    private JpaOrganization organization;
    @Column(name="description")
    private String description;
    @Column(name="role")
    private String role;
    @ElementCollection
    @CollectionTable(name="oc_group_member", joinColumns={@JoinColumn(name="group_id", nullable=false)})
    @Column(name="member")
    private Set<String> members;
    @ManyToMany(cascade={CascadeType.MERGE}, fetch=FetchType.LAZY)
    @JoinTable(name="oc_group_role", joinColumns={@JoinColumn(name="group_id")}, inverseJoinColumns={@JoinColumn(name="role_id")}, uniqueConstraints={@UniqueConstraint(name="UNQ_oc_group_role", columnNames={"group_id", "role_id"})})
    private Set<JpaRole> roles;

    public JpaGroup() {
    }

    public JpaGroup(String groupId, JpaOrganization organization, String name, String description) throws IllegalArgumentException {
        if (groupId.length() > 128) {
            throw new IllegalArgumentException("Group id must not be longer than 128 Bytes");
        }
        if (name.length() > 128) {
            throw new IllegalArgumentException("Name must not be longer than 128 Bytes");
        }
        this.groupId = groupId;
        this.organization = organization;
        this.name = name;
        this.description = description;
        this.role = "ROLE_GROUP_" + groupId.toUpperCase();
        this.roles = new HashSet<JpaRole>();
    }

    public JpaGroup(String groupId, JpaOrganization organization, String name, String description, Set<JpaRole> roles) throws IllegalArgumentException {
        this(groupId, organization, name, description);
        this.roles = roles;
    }

    public JpaGroup(String groupId, JpaOrganization organization, String name, String description, Set<JpaRole> roles, Set<String> members) throws IllegalArgumentException {
        this(groupId, organization, name, description, roles);
        this.members = members;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JpaOrganization getOrganization() {
        return this.organization;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRole() {
        return this.role;
    }

    public Set<String> getMembers() {
        return this.members;
    }

    public void setMembers(Set<String> members) {
        this.members = members;
    }

    public void addMember(String member) {
        if (this.members == null) {
            this.members = new HashSet<String>();
        }
        this.members.add(member);
    }

    public void removeMember(String member) {
        if (this.members != null) {
            this.members.remove(member);
        }
    }

    public Set<Role> getRoles() {
        return new HashSet<Role>(this.roles);
    }

    public Set<String> getRoleNames() {
        return this.roles.stream().map(role -> role.getName()).collect(Collectors.toSet());
    }

    public void setRoles(Set<JpaRole> roles) {
        this.roles = roles;
    }

    public int hashCode() {
        return EqualsUtil.hash((Object[])new Object[]{this.id, this.organization});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        return this.groupId.equals(other.getGroupId()) && this.organization.equals(other.getOrganization());
    }

    public String toString() {
        return this.groupId + ":" + this.organization;
    }
}

