/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.capture.admin.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.RollbackException;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.capture.admin.api.Agent;
import org.opencastproject.capture.admin.api.AgentState;
import org.opencastproject.capture.admin.api.CaptureAgentStateService;
import org.opencastproject.capture.admin.impl.AgentImpl;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.db.Queries;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Tuple3;
import org.opencastproject.util.function.ThrowingFunction;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Capture-Admin Service", "service.pid=org.opencastproject.capture.agent"}, immediate=true, service={CaptureAgentStateService.class, ManagedServiceFactory.class})
public class CaptureAgentStateServiceImpl
implements CaptureAgentStateService,
ManagedServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(CaptureAgentStateServiceImpl.class);
    public static final String PERSISTENCE_UNIT = "org.opencastproject.capture.admin.impl.CaptureAgentStateServiceImpl";
    private static final String DELIMITER = ";==;";
    protected EntityManagerFactory emf = null;
    protected DBSessionFactory dbSessionFactory;
    protected DBSession db;
    protected SecurityService securityService;
    protected Map<String, String> pidMap = new ConcurrentHashMap<String, String>();
    private LoadingCache<String, Object> agentCache = null;
    public static final String CAPTURE_AGENT_TIMEOUT_KEY = "org.opencastproject.capture.admin.timeout";
    protected Object nullToken = new Object();

    @Reference(target="(osgi.unit.name=org.opencastproject.capture.admin.impl.CaptureAgentStateServiceImpl)")
    void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public CaptureAgentStateServiceImpl() {
        logger.info("CaptureAgentStateServiceImpl starting.");
    }

    @Activate
    public void activate(ComponentContext cc) {
        this.db = this.dbSessionFactory.createSession(this.emf);
        int timeoutInMinutes = 120;
        Option timeout = OsgiUtil.getOptContextProperty((ComponentContext)cc, (String)CAPTURE_AGENT_TIMEOUT_KEY);
        if (timeout.isSome()) {
            try {
                timeoutInMinutes = Integer.parseInt((String)timeout.get());
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid configuration for capture agent status timeout (minutes) ({}={})", (Object)CAPTURE_AGENT_TIMEOUT_KEY, timeout.get());
            }
        }
        this.setupAgentCache(timeoutInMinutes, TimeUnit.MINUTES);
        logger.info("Capture agent status timeout is {} minutes", (Object)timeoutInMinutes);
    }

    @Deactivate
    public void deactivate() {
        this.agentCache.invalidateAll();
        this.db.close();
    }

    @Override
    public Agent getAgent(String name) throws NotFoundException {
        String org = this.securityService.getOrganization().getId();
        AgentImpl agent = this.getAgent(name, org);
        return this.updateCachedLastHeardFrom(agent, org);
    }

    protected AgentImpl getAgent(String name, String org) throws NotFoundException {
        return (AgentImpl)this.db.execChecked(this.getAgentEntityQuery(name, org));
    }

    protected ThrowingFunction<EntityManager, AgentImpl, NotFoundException> getAgentEntityQuery(String name, String organization) {
        return em -> {
            try {
                TypedQuery q = em.createNamedQuery("Agent.get", AgentImpl.class);
                q.setParameter("id", (Object)name);
                q.setParameter("org", (Object)organization);
                return (AgentImpl)q.getSingleResult();
            }
            catch (NoResultException e) {
                throw new NotFoundException((Throwable)e);
            }
        };
    }

    protected Agent updateCachedLastHeardFrom(Agent agent, String org) {
        String agentKey = agent.getName().concat(DELIMITER).concat(org);
        Tuple3 cachedAgent = (Tuple3)this.agentCache.getUnchecked((Object)agentKey);
        if (cachedAgent != null) {
            agent.setLastHeardFrom((Long)cachedAgent.getC());
        }
        return agent;
    }

    @Override
    public String getAgentState(String agentName) throws NotFoundException {
        String orgId = this.securityService.getOrganization().getId();
        Tuple3<String, Properties, Long> agent = this.getAgentFromCache(agentName, orgId);
        return (String)agent.getA();
    }

    @Override
    public boolean setAgentState(String agentName, String state) {
        AgentImpl agent;
        if (StringUtils.isBlank((CharSequence)agentName)) {
            throw new IllegalArgumentException("Unable to set agent state, agent name is blank or null.");
        }
        if (StringUtils.isBlank((CharSequence)state)) {
            throw new IllegalArgumentException("Unable to set agent state, state is blank or null.");
        }
        if (!AgentState.KNOWN_STATES.contains(state)) {
            throw new IllegalArgumentException("Can not set agent to an invalid state: ".concat(state));
        }
        logger.debug("Agent '{}' state set to '{}'", (Object)agentName, (Object)state);
        String orgId = this.securityService.getOrganization().getId();
        try {
            if (!this.updateAgentInCache(agentName, state, orgId)) {
                return false;
            }
            agent = (AgentImpl)this.getAgent(agentName);
            logger.debug("Setting Agent {} to state {}.", (Object)agentName, (Object)state);
            agent.setState(state);
            if (!"unknown".equals(state)) {
                agent.setLastHeardFrom(System.currentTimeMillis());
            }
        }
        catch (NotFoundException e) {
            logger.debug("Creating Agent {} with state {}.", (Object)agentName, (Object)state);
            agent = new AgentImpl(agentName, orgId, state, "", new Properties());
        }
        this.updateAgentInDatabase(agent);
        return true;
    }

    private boolean updateAgentInCache(String agentName, String state, String orgId) {
        return this.updateAgentInCache(agentName, state, orgId, null);
    }

    private boolean updateAgentInCache(String agentName, String state, String orgId, Properties configuration) {
        try {
            String agentState = (String)this.getAgentFromCache(agentName, orgId).getA();
            Properties config = this.getAgentConfiguration(agentName);
            if (configuration != null) {
                config = configuration;
            }
            if (!"unknown".equals(state)) {
                this.agentCache.put((Object)agentName.concat(DELIMITER).concat(orgId), (Object)Tuple3.tuple3((Object)state, (Object)config, (Object)System.currentTimeMillis()));
            } else {
                this.agentCache.put((Object)agentName.concat(DELIMITER).concat(orgId), (Object)Tuple3.tuple3((Object)state, (Object)config, (Object)((Long)this.getAgentFromCache(agentName, orgId).getC())));
            }
            return !agentState.equals(state);
        }
        catch (NotFoundException e) {
            this.agentCache.put((Object)agentName.concat(DELIMITER).concat(orgId), (Object)Tuple3.tuple3((Object)state, (Object)configuration, (Object)System.currentTimeMillis()));
            return true;
        }
    }

    @Override
    public boolean setAgentUrl(String agentName, String agentUrl) throws NotFoundException {
        Agent agent = this.getAgent(agentName);
        if (agent.getUrl().equals(agentUrl)) {
            return false;
        }
        agent.setUrl(agentUrl);
        this.updateAgentInDatabase((AgentImpl)agent);
        return true;
    }

    @Override
    public void removeAgent(String agentName) throws NotFoundException {
        this.deleteAgentFromDatabase(agentName);
    }

    @Override
    public Map<String, Agent> getKnownAgents() {
        this.agentCache.cleanUp();
        User user = this.securityService.getUser();
        Organization org = this.securityService.getOrganization();
        String orgAdmin = org.getAdminRole();
        Set roles = user.getRoles();
        List agents = (List)this.db.exec(Queries.namedQuery.findAll("Agent.byOrganization", AgentImpl.class, new Object[]{Pair.of((Object)"org", (Object)this.securityService.getOrganization().getId())}));
        if (!user.hasRole("ROLE_ADMIN") && !user.hasRole(orgAdmin)) {
            Iterator iter = agents.iterator();
            while (iter.hasNext()) {
                AgentImpl agent = (AgentImpl)iter.next();
                Set<String> schedulerRoles = agent.getSchedulerRoles();
                if (schedulerRoles == null || schedulerRoles.isEmpty()) continue;
                boolean hasSchedulerRole = false;
                for (Role role : roles) {
                    if (!schedulerRoles.contains(role.getName())) continue;
                    hasSchedulerRole = true;
                    break;
                }
                if (hasSchedulerRole) continue;
                iter.remove();
            }
        }
        TreeMap<String, Agent> map = new TreeMap<String, Agent>();
        for (AgentImpl agent : agents) {
            map.put(agent.getName(), this.updateCachedLastHeardFrom(agent, org.getId()));
        }
        return map;
    }

    @Override
    public Properties getAgentCapabilities(String agentName) throws NotFoundException {
        return this.getAgent(agentName).getCapabilities();
    }

    @Override
    public Properties getAgentConfiguration(String agentName) throws NotFoundException {
        String orgId = this.securityService.getOrganization().getId();
        Tuple3<String, Properties, Long> agent = this.getAgentFromCache(agentName, orgId);
        return (Properties)agent.getB();
    }

    private Tuple3<String, Properties, Long> getAgentFromCache(String agentName, String orgId) throws NotFoundException {
        Object agent = this.agentCache.getUnchecked((Object)agentName.concat(DELIMITER).concat(orgId));
        if (agent == this.nullToken) {
            throw new NotFoundException();
        }
        return (Tuple3)agent;
    }

    @Override
    public boolean setAgentConfiguration(String agentName, Properties configuration) {
        AgentImpl agent;
        if (StringUtils.isBlank((CharSequence)agentName)) {
            throw new IllegalArgumentException("Unable to set agent state, agent name is blank or null.");
        }
        String orgId = this.securityService.getOrganization().getId();
        try {
            Properties agentConfig = (Properties)this.getAgentFromCache(agentName, orgId).getB();
            if (agentConfig.equals(configuration)) {
                this.agentCache.put((Object)agentName.concat(DELIMITER).concat(orgId), (Object)Tuple3.tuple3((Object)this.getAgentState(agentName), (Object)agentConfig, (Object)System.currentTimeMillis()));
                return false;
            }
            agent = (AgentImpl)this.getAgent(agentName);
            logger.debug("Setting Agent {}'s capabilities", (Object)agentName);
            agent.setConfiguration(configuration);
        }
        catch (NotFoundException e) {
            logger.debug("Creating Agent {} with state {}.", (Object)agentName, (Object)"unknown");
            agent = new AgentImpl(agentName, orgId, "unknown", "", configuration);
        }
        this.updateAgentInDatabase(agent);
        return true;
    }

    protected void updateAgentInDatabase(AgentImpl agent) {
        this.updateAgentInDatabase(agent, true, 10);
    }

    private void updateAgentInDatabase(AgentImpl agent, boolean updateFromCache, int retries) {
        try {
            this.db.execTx(retries, em -> {
                Long cachedLastHeardFrom = -1L;
                if (updateFromCache) {
                    try {
                        cachedLastHeardFrom = (Long)this.getAgentFromCache(agent.getName(), agent.getOrganization()).getC();
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
                try {
                    AgentImpl existing = (AgentImpl)this.getAgentEntityQuery(agent.getName(), agent.getOrganization()).apply(em);
                    existing.setConfiguration(agent.getConfiguration());
                    if (!"unknown".equals(agent.getState())) {
                        existing.setLastHeardFrom(Math.max(cachedLastHeardFrom, agent.getLastHeardFrom()));
                    }
                    existing.setState(agent.getState());
                    existing.setSchedulerRoles(agent.getSchedulerRoles());
                    existing.setUrl(agent.getUrl());
                    em.merge((Object)existing);
                }
                catch (NotFoundException e) {
                    em.persist((Object)agent);
                }
            });
            if (updateFromCache) {
                this.updateAgentInCache(agent.getName(), agent.getState(), agent.getOrganization(), agent.getConfiguration());
            }
        }
        catch (RollbackException e) {
            throw new RollbackException("Maximum number of retries exceeded", (Throwable)e);
        }
    }

    private void deleteAgentFromDatabase(String agentName) throws NotFoundException {
        try {
            String org = this.securityService.getOrganization().getId();
            this.db.execTxChecked(em -> {
                Agent existing = (Agent)this.getAgentEntityQuery(agentName, org).apply(em);
                if (existing == null) {
                    throw new NotFoundException();
                }
                em.remove((Object)existing);
            });
            this.agentCache.invalidate((Object)agentName.concat(DELIMITER).concat(org));
        }
        catch (RollbackException e) {
            logger.warn("Unable to commit to DB in deleteAgent.");
        }
    }

    public String getName() {
        return "org.opencastproject.capture.agent";
    }

    protected void setupAgentCache(int count, TimeUnit unit) {
        RemovalListener<String, Object> removalListener = new RemovalListener<String, Object>(){
            private Set<String> ignoredStates = new LinkedHashSet<String>(Arrays.asList("unknown", "offline"));

            public void onRemoval(RemovalNotification<String, Object> removal) {
                if (RemovalCause.EXPIRED.equals((Object)removal.getCause())) {
                    String org = CaptureAgentStateServiceImpl.this.securityService.getOrganization().getId();
                    try {
                        String agentName = ((String)removal.getKey()).split(CaptureAgentStateServiceImpl.DELIMITER)[0];
                        AgentImpl agent = CaptureAgentStateServiceImpl.this.getAgent(agentName, org);
                        if (!this.ignoredStates.contains(agent.getState())) {
                            agent.setState("offline");
                            CaptureAgentStateServiceImpl.this.updateAgentInDatabase(agent, false, 2);
                        }
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
            }
        };
        this.agentCache = CacheBuilder.newBuilder().expireAfterWrite((long)count, unit).removalListener((RemovalListener)removalListener).build((CacheLoader)new CacheLoader<String, Object>(){

            public Object load(String id) {
                AgentImpl agent;
                String[] key = id.split(CaptureAgentStateServiceImpl.DELIMITER);
                try {
                    agent = CaptureAgentStateServiceImpl.this.getAgent(key[0], key[1]);
                }
                catch (NotFoundException e) {
                    return CaptureAgentStateServiceImpl.this.nullToken;
                }
                return Tuple3.tuple3((Object)agent.getState(), (Object)agent.getConfiguration(), (Object)agent.getLastHeardFrom());
            }
        });
    }

    public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
        AgentImpl agent;
        String nameConfig = (String)properties.get("id");
        if (StringUtils.isBlank((CharSequence)nameConfig)) {
            throw new ConfigurationException("id", "must be specified");
        }
        nameConfig = nameConfig.trim();
        String urlConfig = (String)properties.get("url");
        if (StringUtils.isBlank((CharSequence)urlConfig)) {
            throw new ConfigurationException("url", "must be specified");
        }
        urlConfig = urlConfig.trim();
        String orgConfig = (String)properties.get("organization");
        if (StringUtils.isBlank((CharSequence)orgConfig)) {
            throw new ConfigurationException("organization", "must be specified");
        }
        orgConfig = orgConfig.trim();
        String schedulerRolesConfig = (String)properties.get("schedulerRoles");
        if (StringUtils.isBlank((CharSequence)schedulerRolesConfig)) {
            throw new ConfigurationException("schedulerRoles", "must be specified");
        }
        String[] schedulerRoles = schedulerRolesConfig.trim().split(",");
        if (!this.pidMap.containsKey(pid)) {
            this.pidMap.put(pid, nameConfig);
        }
        try {
            agent = this.getAgent(nameConfig, orgConfig);
            agent.setUrl(urlConfig);
            agent.setState("unknown");
        }
        catch (NotFoundException e) {
            agent = new AgentImpl(nameConfig, orgConfig, "unknown", urlConfig, new Properties());
        }
        for (String role : schedulerRoles) {
            agent.schedulerRoles.add(role.trim());
        }
        logger.info("Roles '{}' may schedule '{}'", (Object)schedulerRolesConfig, (Object)agent.name);
        this.updateAgentInDatabase(agent);
    }

    public void deleted(String pid) {
        String agentId = this.pidMap.remove(pid);
        if (agentId == null) {
            logger.warn("{} was not a managed capture agent pid", (Object)pid);
        } else {
            try {
                this.deleteAgentFromDatabase(agentId);
            }
            catch (NotFoundException e) {
                logger.warn("Unable to delete capture agent '{}'", (Object)agentId);
            }
        }
    }
}

