/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.capture.admin.impl;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.opencastproject.capture.admin.api.Agent;
import org.opencastproject.capture.admin.impl.AgentImplId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@IdClass(value=AgentImplId.class)
@Table(name="oc_capture_agent_state")
@NamedQueries(value={@NamedQuery(name="Agent.get", query="select a from AgentImpl a where a.name = :id and a.organization = :org"), @NamedQuery(name="Agent.byOrganization", query="SELECT a FROM AgentImpl a where a.organization = :org")})
public class AgentImpl
implements Agent {
    private static final Logger log = LoggerFactory.getLogger(AgentImpl.class);
    @Id
    @Column(name="id", length=128)
    protected String name;
    @Lob
    @Column(name="state", nullable=false, length=65535)
    protected String state;
    @Lob
    @Column(name="url", length=65535)
    protected String url;
    @Id
    @Column(name="organization", length=128)
    protected String organization;
    @Column(name="last_heard_from", nullable=false)
    protected Long lastHeardFrom;
    @ElementCollection
    @Column(name="role", nullable=false)
    @CollectionTable(name="oc_capture_agent_role", indexes={@Index(name="IX_oc_capture_agent_role_pk", columnList="id, organization")}, uniqueConstraints={@UniqueConstraint(name="UNQ_capture_agent_role_id_org_role", columnNames={"id", "organization", "role"})}, joinColumns={@JoinColumn(name="id", referencedColumnName="id", nullable=false), @JoinColumn(name="organization", referencedColumnName="organization", nullable=false)})
    protected Set<String> schedulerRoles = new HashSet<String>();
    @Lob
    @Column(name="configuration", nullable=true, length=65535)
    protected String configurationString;
    @Transient
    private Properties capabilitiesProperties;
    @Transient
    private Properties configurationProperties;

    public AgentImpl() {
    }

    public AgentImpl(String agentName, String organization, String agentState, String agentUrl, Properties configuration) {
        this.name = agentName;
        this.setState(agentState);
        this.setUrl(agentUrl);
        this.setOrganization(organization);
        this.setConfiguration(configuration);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setState(String newState) {
        this.state = newState;
        this.setLastHeardFrom(System.currentTimeMillis());
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public void setUrl(String agentUrl) {
        this.url = agentUrl;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setLastHeardFrom(Long time) {
        this.lastHeardFrom = time;
    }

    @Override
    public Long getLastHeardFrom() {
        return this.lastHeardFrom;
    }

    @Override
    public Properties getCapabilities() {
        return this.capabilitiesProperties;
    }

    @Override
    public Properties getConfiguration() {
        return this.configurationProperties;
    }

    public Set<String> getSchedulerRoles() {
        return this.schedulerRoles;
    }

    public void setSchedulerRoles(Set<String> schedulerRoles) {
        this.schedulerRoles = schedulerRoles;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    @Override
    public void setConfiguration(Properties configuration) {
        if (configuration == null) {
            return;
        }
        this.configurationProperties = configuration;
        try {
            StringWriter sw = new StringWriter();
            configuration.store(sw, "");
            this.configurationString = sw.toString();
        }
        catch (IOException e) {
            log.warn("Unable to store agent 's capabilities to the database, IO exception occurred.", (Throwable)e);
        }
        this.capabilitiesProperties = new Properties();
        String names = configuration.getProperty("capture.device.names");
        if (names == null) {
            log.debug("Capture agent '{}' failed to provide device names ({})", (Object)this.name, (Object)"capture.device.names");
            return;
        }
        this.capabilitiesProperties.put("capture.device.names", names);
        String[] friendlyNames = names.split(",");
        HashMap<String, Integer> propertyCounts = new HashMap<String, Integer>();
        for (String name : friendlyNames) {
            propertyCounts.put(name, 0);
        }
        for (String key : configuration.stringPropertyNames()) {
            for (String name : friendlyNames) {
                String check = "capture.device." + name;
                if (!key.contains(check)) continue;
                String property = configuration.getProperty(key);
                if (property == null) {
                    log.error("Unable to expand variable in value for key {}, returning null!", (Object)key);
                    this.capabilitiesProperties = null;
                    return;
                }
                this.capabilitiesProperties.setProperty(key, property);
                propertyCounts.put(name, (Integer)propertyCounts.get(name) + 1);
            }
        }
    }

    @PostLoad
    private void loadCaps() {
        this.configurationProperties = new Properties();
        if (this.configurationString == null) {
            log.info("No configuration properties set yet for '{}'", (Object)this.name);
        } else {
            try {
                this.configurationProperties.load(new StringReader(this.configurationString));
                this.setConfiguration(this.configurationProperties);
            }
            catch (IOException e) {
                log.warn("Unable to load agent " + this.name + "'s capabilities, IO exception occurred.", (Throwable)e);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AgentImpl) {
            return this.name.equals(((AgentImpl)o).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

