/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.caption.converters;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.opencastproject.caption.api.Caption;
import org.opencastproject.caption.api.CaptionConverter;
import org.opencastproject.caption.api.CaptionConverterException;
import org.opencastproject.caption.api.IllegalTimeFormatException;
import org.opencastproject.caption.api.Time;
import org.opencastproject.caption.impl.CaptionImpl;
import org.opencastproject.caption.impl.TimeImpl;
import org.opencastproject.caption.util.TimeUtil;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={CaptionConverter.class}, property={"service.description=SubRip caption converter", "caption.format=subrip"})
public class SubRipCaptionConverter
implements CaptionConverter {
    private static final Logger logger = LoggerFactory.getLogger(SubRipCaptionConverter.class);
    private static final String EXTENSION = "srt";
    private static final String LINE_ENDING = "\r\n";

    public List<Caption> importCaption(InputStream in, String language) throws CaptionConverterException {
        ArrayList<Caption> collection = new ArrayList<Caption>();
        Scanner scanner = new Scanner(in, "UTF-8");
        scanner.useDelimiter("[\n(\r\n)]{2}");
        TimeImpl time = null;
        try {
            time = new TimeImpl(0, 0, 0, 0);
        }
        catch (IllegalTimeFormatException illegalTimeFormatException) {
            // empty catch block
        }
        while (scanner.hasNext()) {
            Time outTime;
            Time inTime;
            String captionString = scanner.next();
            String[] captionParts = (captionString = captionString.replace(LINE_ENDING, "\n")).split("\n", 3);
            if (captionParts.length != 3) {
                throw new CaptionConverterException("Invalid caption for SubRip format: " + captionString);
            }
            String[] timePart = captionParts[1].split("-->");
            try {
                inTime = TimeUtil.importSrt(timePart[0].trim());
                outTime = TimeUtil.importSrt(timePart[1].trim());
            }
            catch (IllegalTimeFormatException e) {
                throw new CaptionConverterException(e.getMessage());
            }
            if (inTime.compareTo((Object)time) < 0 || outTime.compareTo((Object)inTime) <= 0) {
                logger.warn("Caption with invalid time encountered. Skipping...");
                continue;
            }
            time = outTime;
            String[] captionLines = this.createCaptionLines(captionParts[2]);
            if (captionLines == null) {
                throw new CaptionConverterException("Caption does not contain any caption text: " + captionString);
            }
            CaptionImpl caption = new CaptionImpl(inTime, outTime, captionLines);
            collection.add(caption);
        }
        return collection;
    }

    public void exportCaption(OutputStream outputStream, List<Caption> captions, String language) throws IOException {
        if (language != null) {
            logger.debug("SubRip format does not include language information. Ignoring language attribute.");
        }
        OutputStreamWriter osw = new OutputStreamWriter(outputStream, "UTF-8");
        BufferedWriter bw = new BufferedWriter(osw);
        int counter = 1;
        for (Caption caption : captions) {
            String captionString = String.format("%2$d%1$s%3$s --> %4$s%1$s%5$s%1$s%1$s", LINE_ENDING, counter, TimeUtil.exportToSrt(caption.getStartTime()), TimeUtil.exportToSrt(caption.getStopTime()), this.createCaptionText(caption.getCaption()));
            bw.append(captionString);
            ++counter;
        }
        bw.flush();
        bw.close();
        osw.close();
    }

    private String createCaptionText(String[] captionLines) {
        StringBuilder builder = new StringBuilder(captionLines[0]);
        for (int i = 1; i < captionLines.length; ++i) {
            builder.append(LINE_ENDING);
            builder.append(captionLines[i]);
        }
        return builder.toString();
    }

    private String[] createCaptionLines(String captionText) {
        String[] captionLines = captionText.split("\n");
        if (captionLines.length == 0) {
            return null;
        }
        for (int i = 0; i < captionLines.length; ++i) {
            captionLines[i] = captionLines[i].replaceAll("(<\\s*.\\s*>)|(</\\s*.\\s*>)", "").trim();
        }
        return captionLines;
    }

    public String[] getLanguageList(InputStream input) throws CaptionConverterException {
        return new String[0];
    }

    public String getExtension() {
        return EXTENSION;
    }

    public MediaPackageElement.Type getElementType() {
        return MediaPackageElement.Type.Attachment;
    }
}

