/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.caption.converters;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opencastproject.caption.api.Caption;
import org.opencastproject.caption.api.CaptionConverter;
import org.opencastproject.caption.api.CaptionConverterException;
import org.opencastproject.caption.api.IllegalTimeFormatException;
import org.opencastproject.caption.api.Time;
import org.opencastproject.caption.impl.CaptionImpl;
import org.opencastproject.caption.impl.TimeImpl;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.metadata.mpeg7.Audio;
import org.opencastproject.metadata.mpeg7.AudioSegment;
import org.opencastproject.metadata.mpeg7.FreeTextAnnotation;
import org.opencastproject.metadata.mpeg7.FreeTextAnnotationImpl;
import org.opencastproject.metadata.mpeg7.MediaDuration;
import org.opencastproject.metadata.mpeg7.MediaTime;
import org.opencastproject.metadata.mpeg7.MediaTimeImpl;
import org.opencastproject.metadata.mpeg7.MediaTimePoint;
import org.opencastproject.metadata.mpeg7.Mpeg7CatalogImpl;
import org.opencastproject.metadata.mpeg7.TemporalDecomposition;
import org.opencastproject.metadata.mpeg7.TextAnnotation;
import org.opencastproject.util.XmlSafeParser;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={CaptionConverter.class}, property={"service.description=Mpeg7 caption converter", "caption.format=mpeg7"})
public class Mpeg7CaptionConverter
implements CaptionConverter {
    private static final String EXTENSION = "xml";
    private static final Logger logger = LoggerFactory.getLogger(Mpeg7CaptionConverter.class);

    public List<Caption> importCaption(InputStream inputStream, String language) throws CaptionConverterException {
        ArrayList<Caption> captions = new ArrayList<Caption>();
        Mpeg7CatalogImpl catalog = new Mpeg7CatalogImpl(inputStream);
        Iterator audioContentIterator = catalog.audioContent();
        if (audioContentIterator == null) {
            return captions;
        }
        block2: while (audioContentIterator.hasNext()) {
            AudioSegment segment;
            Iterator annotationIterator;
            Audio audioContent = (Audio)audioContentIterator.next();
            TemporalDecomposition audioSegments = audioContent.getTemporalDecomposition();
            Iterator audioSegmentIterator = audioSegments.segments();
            if (audioSegmentIterator == null) continue;
            while (audioSegmentIterator.hasNext() && (annotationIterator = (segment = (AudioSegment)audioSegmentIterator.next()).textAnnotations()) != null) {
                while (annotationIterator.hasNext()) {
                    TextAnnotation annotation = (TextAnnotation)annotationIterator.next();
                    if (!annotation.getLanguage().equals(language)) {
                        logger.debug("Skipping audio content '{}' because of language mismatch", (Object)audioContent.getId());
                        continue block2;
                    }
                    ArrayList<String> captionLines = new ArrayList<String>();
                    Iterator freeTextAnnotationIterator = annotation.freeTextAnnotations();
                    if (freeTextAnnotationIterator == null) continue;
                    while (freeTextAnnotationIterator.hasNext()) {
                        FreeTextAnnotation freeTextAnnotation = (FreeTextAnnotation)freeTextAnnotationIterator.next();
                        captionLines.add(freeTextAnnotation.getText());
                    }
                    MediaTime segmentTime = segment.getMediaTime();
                    MediaTimePoint stp = segmentTime.getMediaTimePoint();
                    MediaDuration d = segmentTime.getMediaDuration();
                    Calendar startCalendar = Calendar.getInstance();
                    int millisAtStart = (int)(stp.getTimeInMilliseconds() - (long)(((stp.getHour() * 60 + stp.getMinutes()) * 60 + stp.getSeconds()) * 1000));
                    int millisAtEnd = (int)(d.getDurationInMilliseconds() - (long)(((d.getHours() * 60 + d.getMinutes()) * 60 + d.getSeconds()) * 1000));
                    startCalendar.set(10, stp.getHour());
                    startCalendar.set(12, stp.getMinutes());
                    startCalendar.set(13, stp.getSeconds());
                    startCalendar.set(14, millisAtStart);
                    startCalendar.add(10, d.getHours());
                    startCalendar.add(12, d.getMinutes());
                    startCalendar.add(13, d.getSeconds());
                    startCalendar.set(14, millisAtEnd);
                    try {
                        TimeImpl startTime = new TimeImpl(stp.getHour(), stp.getMinutes(), stp.getSeconds(), millisAtStart);
                        TimeImpl endTime = new TimeImpl(startCalendar.get(10), startCalendar.get(12), startCalendar.get(13), startCalendar.get(14));
                        CaptionImpl caption = new CaptionImpl(startTime, endTime, captionLines.toArray(new String[captionLines.size()]));
                        captions.add(caption);
                    }
                    catch (IllegalTimeFormatException e) {
                        logger.warn("Error setting caption time: {}", (Object)e.getMessage());
                    }
                }
            }
        }
        return captions;
    }

    public void exportCaption(OutputStream outputStream, List<Caption> captions, String language) throws IOException {
        Mpeg7CatalogImpl mpeg7 = Mpeg7CatalogImpl.newInstance();
        MediaTimeImpl mediaTime = new MediaTimeImpl(0L, 0L);
        Audio audioContent = mpeg7.addAudioContent("captions", (MediaTime)mediaTime, null);
        TemporalDecomposition captionDecomposition = audioContent.getTemporalDecomposition();
        int segmentCount = 0;
        for (Caption caption : captions) {
            String[] words = caption.getCaption();
            if (words.length == 0) continue;
            AudioSegment segment = (AudioSegment)captionDecomposition.createSegment("segment-" + segmentCount++);
            Time captionST = caption.getStartTime();
            Time captionET = caption.getStopTime();
            Calendar startTime = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            startTime.setTimeInMillis(0L);
            startTime.add(11, captionST.getHours());
            startTime.add(12, captionST.getMinutes());
            startTime.add(13, captionST.getSeconds());
            startTime.add(14, captionST.getMilliseconds());
            Calendar endTime = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            endTime.setTimeInMillis(0L);
            endTime.add(11, captionET.getHours());
            endTime.add(12, captionET.getMinutes());
            endTime.add(13, captionET.getSeconds());
            endTime.add(14, captionET.getMilliseconds());
            long startTimeInMillis = startTime.getTimeInMillis();
            long endTimeInMillis = endTime.getTimeInMillis();
            long duration = endTimeInMillis - startTimeInMillis;
            segment.setMediaTime((MediaTime)new MediaTimeImpl(startTimeInMillis, duration));
            TextAnnotation textAnnotation = segment.createTextAnnotation(0.0f, 0.0f, language);
            StringBuffer captionLine = new StringBuffer();
            for (String word : words) {
                if (captionLine.length() > 0) {
                    captionLine.append(' ');
                }
                captionLine.append(word);
            }
            textAnnotation.addFreeTextAnnotation((FreeTextAnnotation)new FreeTextAnnotationImpl(captionLine.toString()));
        }
        Transformer tf = null;
        try {
            tf = XmlSafeParser.newTransformerFactory().newTransformer();
            DOMSource xmlSource = new DOMSource(mpeg7.toXml());
            tf.transform(xmlSource, new StreamResult(outputStream));
        }
        catch (TransformerConfigurationException e) {
            logger.warn("Error serializing mpeg7 captions catalog: {}", (Object)e.getMessage());
            throw new IOException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            logger.warn("Error serializing mpeg7 captions catalog: {}", (Object)e.getMessage());
            throw new IOException(e);
        }
        catch (TransformerException e) {
            logger.warn("Error serializing mpeg7 captions catalog: {}", (Object)e.getMessage());
            throw new IOException(e);
        }
        catch (ParserConfigurationException e) {
            logger.warn("Error serializing mpeg7 captions catalog: {}", (Object)e.getMessage());
            throw new IOException(e);
        }
    }

    public String[] getLanguageList(InputStream inputStream) throws CaptionConverterException {
        HashSet<String> languages = new HashSet<String>();
        Mpeg7CatalogImpl catalog = new Mpeg7CatalogImpl(inputStream);
        Iterator audioContentIterator = catalog.audioContent();
        if (audioContentIterator == null) {
            return languages.toArray(new String[languages.size()]);
        }
        while (audioContentIterator.hasNext()) {
            AudioSegment segment;
            Iterator annotationIterator;
            Audio audioContent = (Audio)audioContentIterator.next();
            TemporalDecomposition audioSegments = audioContent.getTemporalDecomposition();
            Iterator audioSegmentIterator = audioSegments.segments();
            if (audioSegmentIterator == null) continue;
            while (audioSegmentIterator.hasNext() && (annotationIterator = (segment = (AudioSegment)audioSegmentIterator.next()).textAnnotations()) != null) {
                while (annotationIterator.hasNext()) {
                    TextAnnotation annotation = (TextAnnotation)annotationIterator.next();
                    String language = annotation.getLanguage();
                    if (language == null) continue;
                    languages.add(language);
                }
            }
        }
        return languages.toArray(new String[languages.size()]);
    }

    public String getExtension() {
        return EXTENSION;
    }

    public MediaPackageElement.Type getElementType() {
        return MediaPackageElement.Type.Catalog;
    }
}

