/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.caption.converters;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.opencastproject.caption.api.Caption;
import org.opencastproject.caption.api.CaptionConverter;
import org.opencastproject.caption.api.CaptionConverterException;
import org.opencastproject.caption.api.IllegalTimeFormatException;
import org.opencastproject.caption.api.Time;
import org.opencastproject.caption.impl.CaptionImpl;
import org.opencastproject.caption.impl.TimeImpl;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={CaptionConverter.class}, property={"service.description=Google speech caption converter", "caption.format=google-speech"})
public class GoogleSpeechCaptionConverter
implements CaptionConverter {
    private static final Logger logger = LoggerFactory.getLogger(GoogleSpeechCaptionConverter.class);
    private static final int LINE_SIZE = 100;

    public List<Caption> importCaption(InputStream inputStream, String languageLineSize) throws CaptionConverterException {
        ArrayList<Caption> captionList = new ArrayList<Caption>();
        JSONParser jsonParser = new JSONParser();
        int transcriptionLineSize = 0;
        try {
            transcriptionLineSize = Integer.parseInt(languageLineSize.trim());
            logger.info("Transcripts line size {} used", (Object)transcriptionLineSize);
        }
        catch (NumberFormatException nfe) {
            transcriptionLineSize = 100;
            logger.info("Default transcripts line size {} used", (Object)transcriptionLineSize);
        }
        try {
            JSONObject outputObj = (JSONObject)jsonParser.parse((Reader)new InputStreamReader(inputStream));
            String jobId = "Unknown";
            if (outputObj.get((Object)"name") != null) {
                jobId = (String)outputObj.get((Object)"name");
            }
            JSONObject responseObj = (JSONObject)outputObj.get((Object)"response");
            JSONArray resultsArray = (JSONArray)responseObj.get((Object)"results");
            block4: for (int i = 0; i < resultsArray.size(); ++i) {
                String transcript;
                JSONObject alternativeElement;
                JSONObject resultElement = (JSONObject)resultsArray.get(i);
                JSONArray alternativesArray = (JSONArray)resultElement.get((Object)"alternatives");
                if (alternativesArray == null || alternativesArray.size() <= 0 || (alternativeElement = (JSONObject)alternativesArray.get(0)).isEmpty() || (transcript = ((String)alternativeElement.get((Object)"transcript")).trim()) == null) continue;
                JSONArray timestampsArray = (JSONArray)alternativeElement.get((Object)"words");
                if (timestampsArray == null || timestampsArray.isEmpty()) {
                    logger.warn("Could not build caption object for job {}, result index {}: timestamp data not found", (Object)jobId, (Object)i);
                    continue;
                }
                String[] words = transcript.split("\\s+");
                StringBuffer line = new StringBuffer();
                int indexFirst = -1;
                int indexLast = -1;
                for (int j = 0; j < words.length; ++j) {
                    if (indexFirst == -1) {
                        indexFirst = j;
                    }
                    line.append(words[j]);
                    line.append(" ");
                    if (line.length() < transcriptionLineSize && j != words.length - 1) continue;
                    indexLast = j;
                    double start = -1.0;
                    double end = -1.0;
                    if (indexLast < timestampsArray.size()) {
                        JSONObject wordTSList = (JSONObject)timestampsArray.get(indexFirst);
                        if (wordTSList.size() == 3) {
                            Number startNumber = NumberFormat.getInstance(Locale.US).parse(this.removeEndCharacter(wordTSList.get((Object)"startTime").toString(), "s"));
                            start = startNumber.doubleValue();
                        }
                        if ((wordTSList = (JSONObject)timestampsArray.get(indexLast)).size() == 3) {
                            Number endNumber = NumberFormat.getInstance(Locale.US).parse(this.removeEndCharacter(wordTSList.get((Object)"endTime").toString(), "s"));
                            end = endNumber.doubleValue();
                        }
                    }
                    if (start == -1.0 || end == -1.0) {
                        logger.warn("Could not build caption object for job {}, result index {}: start/end times not found", (Object)jobId, (Object)i);
                        continue block4;
                    }
                    String[] captionLines = new String[]{line.toString().replace("%HESITATION", "...")};
                    captionList.add(new CaptionImpl(this.buildTime((long)(start * 1000.0)), this.buildTime((long)(end * 1000.0)), captionLines));
                    indexFirst = -1;
                    indexLast = -1;
                    line.setLength(0);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Error when parsing Google transcriptions result", (Throwable)e);
            throw new CaptionConverterException((Throwable)e);
        }
        return captionList;
    }

    public void exportCaption(OutputStream outputStream, List<Caption> captions, String language) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String[] getLanguageList(InputStream inputStream) throws CaptionConverterException {
        throw new UnsupportedOperationException();
    }

    public String getExtension() {
        return "json";
    }

    public MediaPackageElement.Type getElementType() {
        return MediaPackageElement.Type.Attachment;
    }

    private Time buildTime(long ms) throws IllegalTimeFormatException {
        int h = (int)(ms / 3600000L);
        int m = (int)(ms % 3600000L / 60000L);
        int s = (int)(ms % 60000L / 1000L);
        ms = (int)(ms % 1000L);
        return new TimeImpl(h, m, s, (int)ms);
    }

    private String removeEndCharacter(String str, String end) {
        if (str.endsWith(end)) {
            str = str.replace(end, "");
        }
        return str;
    }
}

