/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.caption.util;

import org.opencastproject.caption.api.IllegalTimeFormatException;
import org.opencastproject.caption.api.Time;
import org.opencastproject.caption.impl.TimeImpl;

public final class TimeUtil {
    private static final String SRT_FORMAT = "[0-9]{2}:[0-9]{2}:[0-9]{2},[0-9]{1,3}";
    private static final String DFXP_FORMAT_1 = "[0-9]{1,2}:[0-9]{2}:[0-9]{2}(.[0-9]+)?";

    private TimeUtil() {
    }

    public static Time importSrt(String timeSrt) throws IllegalTimeFormatException {
        if (!timeSrt.matches(SRT_FORMAT)) {
            throw new IllegalTimeFormatException(timeSrt + " does not appear to valid SubRip time format.");
        }
        String[] timeParts = timeSrt.split("[,:]");
        int hour = Integer.parseInt(timeParts[0]);
        int minute = Integer.parseInt(timeParts[1]);
        int second = Integer.parseInt(timeParts[2]);
        int milisecond = Integer.parseInt(timeParts[3]);
        return new TimeImpl(hour, minute, second, milisecond);
    }

    public static String exportToSrt(Time time) {
        return String.format("%02d:%02d:%02d,%03d", time.getHours(), time.getMinutes(), time.getSeconds(), time.getMilliseconds());
    }

    public static String exportToVtt(Time time) {
        return String.format("%02d:%02d:%02d.%03d", time.getHours(), time.getMinutes(), time.getSeconds(), time.getMilliseconds());
    }

    public static Time importDFXP(String timeDfxp) throws IllegalTimeFormatException {
        if (!timeDfxp.matches(DFXP_FORMAT_1)) {
            throw new IllegalTimeFormatException(timeDfxp + " is not valid DFXP time format or is not supported.");
        }
        String[] timeArray = timeDfxp.split("[\\.:]");
        int hour = Integer.parseInt(timeArray[0]);
        int minute = Integer.parseInt(timeArray[1]);
        int second = Integer.parseInt(timeArray[2]);
        int millisecond = 0;
        if (timeArray.length == 4) {
            millisecond = timeArray[3].length() == 1 ? Integer.parseInt(timeArray[3]) * 100 : (timeArray[3].length() == 2 ? Integer.parseInt(timeArray[3]) * 10 : (timeArray[3].length() == 3 ? Integer.parseInt(timeArray[3]) : Integer.parseInt(timeArray[3].trim().substring(0, 4))));
        }
        return new TimeImpl(hour, minute, second, millisecond);
    }

    public static String exportToDFXP(Time time) {
        return String.format("%d:%02d:%02d.%03d", time.getHours(), time.getMinutes(), time.getSeconds(), time.getMilliseconds());
    }
}

