/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.caption.impl;

import org.opencastproject.caption.api.IllegalTimeFormatException;
import org.opencastproject.caption.api.Time;

public class TimeImpl
implements Time {
    private int hours;
    private int minutes;
    private int seconds;
    private int milliseconds;

    public TimeImpl(int h, int m, int s, int ms) throws IllegalTimeFormatException {
        this.setHours(h);
        this.setMinutes(m);
        this.setSeconds(s);
        this.setMilliseconds(ms);
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMilliseconds() {
        return this.milliseconds;
    }

    private void setHours(int h) throws IllegalTimeFormatException {
        if (h < 0 || h > 99) {
            throw new IllegalTimeFormatException("Invalid hour time: " + h);
        }
        this.hours = h;
    }

    private void setMinutes(int m) throws IllegalTimeFormatException {
        if (m < 0 || m > 59) {
            throw new IllegalTimeFormatException("Invalid minute time: " + m);
        }
        this.minutes = m;
    }

    private void setSeconds(int s) throws IllegalTimeFormatException {
        if (s < 0 || s > 59) {
            throw new IllegalTimeFormatException("Invalid second time: " + s);
        }
        this.seconds = s;
    }

    private void setMilliseconds(int ms) throws IllegalTimeFormatException {
        if (ms < 0 || ms > 999) {
            throw new IllegalTimeFormatException("Invalid milisecond time: " + ms);
        }
        this.milliseconds = ms;
    }

    public int compareTo(Time arg0) {
        return TimeImpl.getMilliseconds(this) - TimeImpl.getMilliseconds(arg0);
    }

    private static int getMilliseconds(Time time) {
        return (time.getHours() * 3600 + time.getMinutes() * 60 + time.getSeconds()) * 1000 + time.getMilliseconds();
    }
}

