/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.caption.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import javax.activation.FileTypeMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.caption.api.Caption;
import org.opencastproject.caption.api.CaptionConverter;
import org.opencastproject.caption.api.CaptionConverterException;
import org.opencastproject.caption.api.CaptionService;
import org.opencastproject.caption.api.UnsupportedCaptionFormatException;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.util.MimeType;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={CaptionService.class, ManagedService.class}, property={"service.description=Caption Converter Service", "service.pid=org.opencastproject.caption.impl.CaptionServiceImpl"})
public class CaptionServiceImpl
extends AbstractJobProducer
implements CaptionService,
ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(CaptionServiceImpl.class);
    public static final String COLLECTION = "captions";
    public static final float DEFAULT_CAPTION_JOB_LOAD = 0.1f;
    public static final String CAPTION_JOB_LOAD_KEY = "job.load.caption";
    private float captionJobLoad = 0.1f;
    protected Workspace workspace;
    protected ServiceRegistry serviceRegistry;
    protected SecurityService securityService = null;
    protected UserDirectoryService userDirectoryService = null;
    protected OrganizationDirectoryService organizationDirectoryService = null;
    protected ComponentContext componentContext = null;

    public CaptionServiceImpl() {
        super("org.opencastproject.caption");
    }

    @Activate
    public void activate(ComponentContext componentContext) {
        super.activate(componentContext);
        this.componentContext = componentContext;
    }

    public Job convert(MediaPackageElement input, String inputFormat, String outputFormat) throws UnsupportedCaptionFormatException, CaptionConverterException, MediaPackageException {
        if (input == null) {
            throw new IllegalArgumentException("Input catalog can't be null");
        }
        if (StringUtils.isBlank((CharSequence)inputFormat)) {
            throw new IllegalArgumentException("Input format is null");
        }
        if (StringUtils.isBlank((CharSequence)outputFormat)) {
            throw new IllegalArgumentException("Output format is null");
        }
        try {
            return this.serviceRegistry.createJob("org.opencastproject.caption", Operation.Convert.toString(), Arrays.asList(MediaPackageElementParser.getAsXml((MediaPackageElement)input), inputFormat, outputFormat), Float.valueOf(this.captionJobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new CaptionConverterException("Unable to create a job", (Throwable)e);
        }
    }

    public Job convert(MediaPackageElement input, String inputFormat, String outputFormat, String language) throws UnsupportedCaptionFormatException, CaptionConverterException, MediaPackageException {
        if (input == null) {
            throw new IllegalArgumentException("Input catalog can't be null");
        }
        if (StringUtils.isBlank((CharSequence)inputFormat)) {
            throw new IllegalArgumentException("Input format is null");
        }
        if (StringUtils.isBlank((CharSequence)outputFormat)) {
            throw new IllegalArgumentException("Output format is null");
        }
        if (StringUtils.isBlank((CharSequence)language)) {
            throw new IllegalArgumentException("Language format is null");
        }
        try {
            return this.serviceRegistry.createJob("org.opencastproject.caption", Operation.ConvertWithLanguage.toString(), Arrays.asList(MediaPackageElementParser.getAsXml((MediaPackageElement)input), inputFormat, outputFormat, language), Float.valueOf(this.captionJobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new CaptionConverterException("Unable to create a job", (Throwable)e);
        }
    }

    protected MediaPackageElement convert(Job job, MediaPackageElement input, String inputFormat, String outputFormat, String language) throws UnsupportedCaptionFormatException, CaptionConverterException, MediaPackageException {
        try {
            URI exported;
            File captionsFile;
            if (input == null) {
                throw new IllegalArgumentException("Input element can't be null");
            }
            if (StringUtils.isBlank((CharSequence)inputFormat)) {
                throw new IllegalArgumentException("Input format is null");
            }
            if (StringUtils.isBlank((CharSequence)outputFormat)) {
                throw new IllegalArgumentException("Output format is null");
            }
            try {
                captionsFile = this.workspace.get(input.getURI());
            }
            catch (NotFoundException e) {
                throw new CaptionConverterException("Requested media package element " + input + " could not be found.");
            }
            catch (IOException e) {
                throw new CaptionConverterException("Requested media package element " + input + "could not be accessed.");
            }
            logger.debug("Atempting to convert from {} to {}...", (Object)inputFormat, (Object)outputFormat);
            List<Caption> collection = null;
            try {
                collection = this.importCaptions(captionsFile, inputFormat, language);
                logger.debug("Parsing to collection succeeded.");
            }
            catch (UnsupportedCaptionFormatException e) {
                throw new UnsupportedCaptionFormatException(inputFormat);
            }
            catch (CaptionConverterException e) {
                throw e;
            }
            try {
                exported = this.exportCaptions(collection, job.getId() + "." + FilenameUtils.getExtension((String)captionsFile.getAbsolutePath()), outputFormat, language);
                logger.debug("Exporting captions succeeding.");
            }
            catch (UnsupportedCaptionFormatException e) {
                throw new UnsupportedCaptionFormatException(outputFormat);
            }
            catch (IOException e) {
                throw new CaptionConverterException("Could not export caption collection.", (Throwable)e);
            }
            CaptionConverter converter = this.getCaptionConverter(outputFormat);
            MediaPackageElementBuilder elementBuilder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
            MediaPackageElement mpe = elementBuilder.elementFromURI(exported, converter.getElementType(), new MediaPackageElementFlavor(COLLECTION, outputFormat + (String)(language == null ? "" : "+" + language)));
            if (mpe.getMimeType() == null) {
                String[] mimetype = FileTypeMap.getDefaultFileTypeMap().getContentType(exported.getPath()).split("/");
                mpe.setMimeType(MimeType.mimeType((String)mimetype[0], (String)mimetype[1]));
            }
            if (language != null && !this.isNumeric(language)) {
                mpe.addTag("lang:" + language);
            }
            return mpe;
        }
        catch (Exception e) {
            logger.warn("Error converting captions in " + input, (Throwable)e);
            if (e instanceof CaptionConverterException) {
                throw (CaptionConverterException)((Object)e);
            }
            if (e instanceof UnsupportedCaptionFormatException) {
                throw (UnsupportedCaptionFormatException)((Object)e);
            }
            throw new CaptionConverterException((Throwable)e);
        }
    }

    public String[] getLanguageList(MediaPackageElement input, String format) throws UnsupportedCaptionFormatException, CaptionConverterException {
        String[] languageList;
        File captions;
        if (format == null) {
            throw new UnsupportedCaptionFormatException("<null>");
        }
        CaptionConverter converter = this.getCaptionConverter(format);
        if (converter == null) {
            throw new UnsupportedCaptionFormatException(format);
        }
        try {
            captions = this.workspace.get(input.getURI());
        }
        catch (NotFoundException e) {
            throw new CaptionConverterException("Requested media package element " + input + " could not be found.");
        }
        catch (IOException e) {
            throw new CaptionConverterException("Requested media package element " + input + "could not be accessed.");
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(captions);
            languageList = converter.getLanguageList((InputStream)stream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new CaptionConverterException("Requested file " + captions + "could not be found.");
            }
            catch (Throwable throwable) {
                IoSupport.closeQuietly(stream);
                throw throwable;
            }
        }
        IoSupport.closeQuietly((Closeable)stream);
        return languageList == null ? new String[]{} : languageList;
    }

    protected HashMap<String, CaptionConverter> getAvailableCaptionConverters() {
        HashMap<String, CaptionConverter> captionConverters = new HashMap<String, CaptionConverter>();
        ServiceReference[] refs = null;
        try {
            refs = this.componentContext.getBundleContext().getServiceReferences(CaptionConverter.class.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (refs != null) {
            for (ServiceReference ref : refs) {
                CaptionConverter converter = (CaptionConverter)this.componentContext.getBundleContext().getService(ref);
                String format = (String)ref.getProperty("caption.format");
                if (captionConverters.containsKey(format)) {
                    logger.warn("Caption converter with format {} has already been registered. Ignoring second definition.", (Object)format);
                    continue;
                }
                captionConverters.put((String)ref.getProperty("caption.format"), converter);
            }
        }
        return captionConverters;
    }

    protected CaptionConverter getCaptionConverter(String formatName) {
        ServiceReference[] ref = null;
        try {
            ref = this.componentContext.getBundleContext().getServiceReferences(CaptionConverter.class.getName(), "(caption.format=" + formatName + ")");
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (ref == null) {
            logger.warn("No caption format available for {}.", (Object)formatName);
            return null;
        }
        if (ref.length > 1) {
            logger.warn("Multiple references for caption format {}! Returning first service reference.", (Object)formatName);
        }
        CaptionConverter converter = (CaptionConverter)this.componentContext.getBundleContext().getService(ref[0]);
        return converter;
    }

    private List<Caption> importCaptions(File input, String inputFormat, String language) throws UnsupportedCaptionFormatException, CaptionConverterException {
        List list;
        CaptionConverter converter = this.getCaptionConverter(inputFormat);
        if (converter == null) {
            logger.error("No available caption format found for {}.", (Object)inputFormat);
            throw new UnsupportedCaptionFormatException(inputFormat);
        }
        FileInputStream fileStream = null;
        try {
            List collection;
            fileStream = new FileInputStream(input);
            list = collection = converter.importCaption((InputStream)fileStream, language);
        }
        catch (FileNotFoundException e) {
            try {
                throw new CaptionConverterException("Could not locate file " + input);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileStream);
        return list;
    }

    private URI exportCaptions(List<Caption> captions, String outputName, String outputFormat, String language) throws UnsupportedCaptionFormatException, IOException {
        CaptionConverter converter = this.getCaptionConverter(outputFormat);
        if (converter == null) {
            logger.error("No available caption format found for {}.", (Object)outputFormat);
            throw new UnsupportedCaptionFormatException(outputFormat);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            converter.exportCaption((OutputStream)outputStream, captions, language);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ByteArrayInputStream in = new ByteArrayInputStream(outputStream.toByteArray());
        return this.workspace.putInCollection(COLLECTION, outputName + "." + converter.getExtension(), (InputStream)in);
    }

    private boolean isNumeric(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    protected String process(Job job) throws Exception {
        Operation op = null;
        String operation = job.getOperation();
        List arguments = job.getArguments();
        try {
            op = Operation.valueOf(operation);
            MediaPackageElement catalog = MediaPackageElementParser.getFromXml((String)((String)arguments.get(0)));
            String inputFormat = (String)arguments.get(1);
            String outputFormat = (String)arguments.get(2);
            MediaPackageElement resultingCatalog = null;
            switch (op) {
                case Convert: {
                    resultingCatalog = this.convert(job, catalog, inputFormat, outputFormat, null);
                    return MediaPackageElementParser.getAsXml((MediaPackageElement)resultingCatalog);
                }
                case ConvertWithLanguage: {
                    String language = (String)arguments.get(3);
                    resultingCatalog = this.convert(job, catalog, inputFormat, outputFormat, language);
                    return MediaPackageElementParser.getAsXml((MediaPackageElement)resultingCatalog);
                }
            }
            throw new IllegalStateException("Don't know how to handle operation '" + operation + "'");
        }
        catch (IllegalArgumentException e) {
            throw new ServiceRegistryException("This service can't handle operations of type '" + op + "'", (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ServiceRegistryException("This argument list for operation '" + op + "' does not meet expectations", (Throwable)e);
        }
        catch (Exception e) {
            throw new ServiceRegistryException("Error handling operation '" + op + "'", (Throwable)e);
        }
    }

    @Reference
    protected void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectory) {
        this.organizationDirectoryService = organizationDirectory;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        this.captionJobLoad = LoadUtil.getConfiguredLoadValue((Dictionary)properties, (String)CAPTION_JOB_LOAD_KEY, (Float)Float.valueOf(0.1f), (ServiceRegistry)this.serviceRegistry);
    }

    private static enum Operation {
        Convert,
        ConvertWithLanguage;

    }
}

