/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.caption.converters;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.opencastproject.caption.api.Caption;
import org.opencastproject.caption.api.CaptionConverter;
import org.opencastproject.caption.api.CaptionConverterException;
import org.opencastproject.caption.api.IllegalTimeFormatException;
import org.opencastproject.caption.api.Time;
import org.opencastproject.caption.impl.CaptionImpl;
import org.opencastproject.caption.impl.TimeImpl;
import org.opencastproject.caption.util.TimeUtil;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.util.XmlSafeParser;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Component(immediate=true, service={CaptionConverter.class}, property={"service.description=DFXP caption converter", "caption.format=dfxp"})
public class DFXPCaptionConverter
implements CaptionConverter {
    private static final Logger logger = LoggerFactory.getLogger(DFXPCaptionConverter.class);
    private static final String EXTENSION = "dfxp.xml";

    public List<Caption> importCaption(InputStream in, String language) throws CaptionConverterException {
        Document doc;
        ArrayList<Caption> collection = new ArrayList<Caption>();
        try {
            DocumentBuilder builder = XmlSafeParser.newDocumentBuilderFactory().newDocumentBuilder();
            doc = builder.parse(in);
            doc.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException e) {
            throw new CaptionConverterException("Could not parse captions", (Throwable)e);
        }
        catch (SAXException e) {
            throw new CaptionConverterException("Could not parse captions", (Throwable)e);
        }
        catch (IOException e) {
            throw new CaptionConverterException("Could not parse captions", (Throwable)e);
        }
        NodeList divElements = doc.getElementsByTagName("div");
        Element targetDiv = null;
        if (language != null) {
            for (int i = 0; i < divElements.getLength(); ++i) {
                Element n = (Element)divElements.item(i);
                if (!n.getAttribute("xml:lang").equals(language)) continue;
                targetDiv = n;
                break;
            }
        } else {
            if (divElements.getLength() > 1) {
                logger.warn("More than one <div> element available. Parsing first one...");
            }
            if (divElements.getLength() != 0) {
                targetDiv = (Element)divElements.item(0);
            }
        }
        if (targetDiv == null) {
            logger.warn("No suitable <div> element found for language {}", (Object)language);
        } else {
            NodeList pElements = targetDiv.getElementsByTagName("p");
            TimeImpl time = null;
            try {
                time = new TimeImpl(0, 0, 0, 0);
            }
            catch (IllegalTimeFormatException illegalTimeFormatException) {
                // empty catch block
            }
            for (int i = 0; i < pElements.getLength(); ++i) {
                try {
                    Caption caption = this.parsePElement((Element)pElements.item(i));
                    if (caption.getStartTime().compareTo((Object)time) < 0 || caption.getStopTime().compareTo((Object)caption.getStartTime()) <= 0) {
                        logger.warn("Caption with invalid time encountered. Skipping...");
                        continue;
                    }
                    collection.add(caption);
                    continue;
                }
                catch (IllegalTimeFormatException e) {
                    logger.warn("Caption with invalid time format encountered. Skipping...");
                }
            }
        }
        return collection;
    }

    private Caption parsePElement(Element p) throws IllegalTimeFormatException {
        Time begin = TimeUtil.importDFXP(p.getAttribute("begin").trim());
        Time end = TimeUtil.importDFXP(p.getAttribute("end").trim());
        String[] textArray = this.getTextCore(p).split("\n");
        return new CaptionImpl(begin, end, textArray);
    }

    private String getTextCore(Node p) {
        StringBuffer captionText = new StringBuffer();
        NodeList list = p.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() == 3) {
                captionText.append(list.item(i).getTextContent());
                continue;
            }
            if ("br".equals(list.item(i).getNodeName())) {
                captionText.append("\n");
                continue;
            }
            captionText.append(this.getTextCore(list.item(i)));
        }
        return captionText.toString().trim();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportCaption(OutputStream outputStream, List<Caption> captions, String language) throws IOException {
        Document doc = null;
        InputStream is = null;
        try {
            DocumentBuilder builder = XmlSafeParser.newDocumentBuilderFactory().newDocumentBuilder();
            is = DFXPCaptionConverter.class.getResourceAsStream("/templates/template.dfxp.xml");
            doc = builder.parse(is);
        }
        catch (ParserConfigurationException e) {
            try {
                throw new RuntimeException(e);
                catch (SAXException e2) {
                    throw new RuntimeException(e2);
                }
                catch (IOException e3) {
                    throw new RuntimeException(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        Node bodyNode = doc.getElementsByTagName("body").item(0);
        Element divNode = doc.createElement("div");
        divNode.setAttribute("xml:lang", language != null ? language : "und");
        bodyNode.appendChild(divNode);
        for (Caption caption : captions) {
            Element newNode = doc.createElement("p");
            newNode.setAttribute("begin", TimeUtil.exportToDFXP(caption.getStartTime()));
            newNode.setAttribute("end", TimeUtil.exportToDFXP(caption.getStopTime()));
            String[] captionText = caption.getCaption();
            newNode.appendChild(doc.createTextNode(captionText[0]));
            for (int i = 1; i < captionText.length; ++i) {
                newNode.appendChild(doc.createElement("br"));
                newNode.appendChild(doc.createTextNode(captionText[i]));
            }
            divNode.appendChild(newNode);
        }
        OutputStreamWriter osw = new OutputStreamWriter(outputStream, "UTF-8");
        StreamResult result = new StreamResult(osw);
        DOMSource source = new DOMSource(doc);
        TransformerFactory tfactory = XmlSafeParser.newTransformerFactory();
        try {
            Transformer transformer = tfactory.newTransformer();
            transformer.transform(source, result);
            osw.flush();
            return;
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((Writer)osw);
        }
    }

    public String[] getLanguageList(InputStream input) throws CaptionConverterException {
        final LinkedList langList = new LinkedList();
        SAXParserFactory factory = XmlSafeParser.newSAXParserFactory();
        try {
            SAXParser parser = factory.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("div".equals(qName)) {
                        String lang = attributes.getValue("xml:lang");
                        if (lang == null) {
                            logger.warn("Missing xml:lang attribute for div element.");
                        } else if (langList.contains(lang)) {
                            logger.warn("Multiple div elements with same language.");
                        } else {
                            langList.add(lang);
                        }
                    }
                }
            };
            parser.parse(input, handler);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new CaptionConverterException("Could not parse captions", (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return langList.toArray(new String[0]);
    }

    public String getExtension() {
        return EXTENSION;
    }

    public MediaPackageElement.Type getElementType() {
        return MediaPackageElement.Type.Attachment;
    }
}

