/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.authorization.xacml.manager.impl;

import org.opencastproject.authorization.xacml.manager.api.AclService;
import org.opencastproject.authorization.xacml.manager.api.AclServiceFactory;
import org.opencastproject.authorization.xacml.manager.impl.AclDb;
import org.opencastproject.authorization.xacml.manager.impl.AclServiceImpl;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.description=Factory to create ACL services"}, immediate=true, service={AclServiceFactory.class})
public class OsgiAclServiceFactory
implements AclServiceFactory {
    private AclDb aclDb;
    private SecurityService securityService;
    protected ElasticsearchIndex index;

    @Override
    public AclService serviceFor(Organization org) {
        return new AclServiceImpl(org, this.aclDb, this.index, this.securityService);
    }

    @Reference
    public void setAclDb(AclDb aclDb) {
        this.aclDb = aclDb;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setIndex(ElasticsearchIndex index) {
        this.index = index;
    }
}

