/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.authorization.xacml.manager.endpoint;

import javax.ws.rs.Path;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.authorization.xacml.manager.api.AclServiceFactory;
import org.opencastproject.authorization.xacml.manager.endpoint.AbstractAclServiceRestEndpoint;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/acl-manager")
@RestService(name="aclmanager", title="ACL Manager", abstractText="This service creates, edits, retrieves and helps managing access policies (ACL templates).", notes={})
@Component(name="org.opencastproject.authorization.xacml.manager.endpoint.ACLManagerRestService", service={OsgiAclServiceRestEndpoint.class}, property={"service.description=ACL Manager REST endpoint", "opencast.service.type=org.opencastproject.authorization.xacml.manager", "opencast.service.path=/acl-manager"})
@JaxrsResource
public final class OsgiAclServiceRestEndpoint
extends AbstractAclServiceRestEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(OsgiAclServiceRestEndpoint.class);
    private AclServiceFactory aclServiceFactory;
    private SecurityService securityService;
    private AuthorizationService authorizationService;
    private String endpointBaseUrl;
    private AssetManager assetManager;

    public void activate(ComponentContext cc) {
        logger.info("Start ACL manager rest service");
        Tuple endpointUrl = RestUtil.getEndpointUrl((ComponentContext)cc);
        this.endpointBaseUrl = UrlSupport.concat((String)((String)endpointUrl.getA()), (String)((String)endpointUrl.getB()));
    }

    public void deactivate() {
        logger.info("Stop ACL manager rest service");
    }

    @Reference
    public void setAclServiceFactory(AclServiceFactory aclServiceFactory) {
        this.aclServiceFactory = aclServiceFactory;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Override
    protected AclServiceFactory getAclServiceFactory() {
        return this.aclServiceFactory;
    }

    @Override
    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    @Override
    protected AssetManager getAssetManager() {
        return this.assetManager;
    }

    @Override
    protected AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }
}

