/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.authorization.xacml.manager.impl;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.opencastproject.authorization.xacml.manager.api.AclService;
import org.opencastproject.authorization.xacml.manager.api.AclServiceException;
import org.opencastproject.authorization.xacml.manager.api.ManagedAcl;
import org.opencastproject.authorization.xacml.manager.impl.AclDb;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.api.SearchResultItem;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.elasticsearch.index.objects.event.EventSearchQuery;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.elasticsearch.index.objects.series.SeriesSearchQuery;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.util.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AclServiceImpl
implements AclService {
    private static final Logger logger = LoggerFactory.getLogger(AclServiceImpl.class);
    private final Organization organization;
    private final AclDb aclDb;
    private final SecurityService securityService;
    protected ElasticsearchIndex index;

    public AclServiceImpl(Organization organization, AclDb aclDb, ElasticsearchIndex index, SecurityService securityService) {
        this.organization = organization;
        this.aclDb = aclDb;
        this.index = index;
        this.securityService = securityService;
    }

    @Override
    public List<ManagedAcl> getAcls() {
        return this.aclDb.getAcls(this.organization);
    }

    @Override
    public Optional<ManagedAcl> getAcl(long id) {
        return this.aclDb.getAcl(this.organization, id);
    }

    @Override
    public boolean updateAcl(ManagedAcl acl) {
        Optional<ManagedAcl> oldName = this.getAcl(acl.getId());
        boolean updateAcl = this.aclDb.updateAcl(acl);
        if (updateAcl && oldName.isPresent() && !oldName.get().getName().equals(acl.getName())) {
            User user = this.securityService.getUser();
            this.updateAclInIndex(oldName.get().getName(), acl.getName(), this.index, this.organization.getId(), user);
        }
        return updateAcl;
    }

    @Override
    public Optional<ManagedAcl> createAcl(AccessControlList acl, String name) {
        return this.aclDb.createAcl(this.organization, acl, name);
    }

    @Override
    public boolean deleteAcl(long id) throws AclServiceException, NotFoundException {
        Optional<ManagedAcl> deletedAcl = this.getAcl(id);
        if (this.aclDb.deleteAcl(this.organization, id)) {
            if (deletedAcl.isPresent()) {
                User user = this.securityService.getUser();
                this.removeAclFromIndex(deletedAcl.get().getName(), this.index, this.organization.getId(), user);
            }
            return true;
        }
        throw new NotFoundException("Managed acl with id " + id + " not found.");
    }

    private void updateAclInIndex(String currentAclName, String newAclName, ElasticsearchIndex index, String orgId, User user) {
        logger.debug("Update the events to change the managed acl name from '{}' to '{}'.", (Object)currentAclName, (Object)newAclName);
        this.updateManagedAclForEvents(currentAclName, Optional.of(newAclName), index, orgId, user);
        logger.debug("Update the series to change the managed acl name from '{}' to '{}'.", (Object)currentAclName, (Object)newAclName);
        this.updateManagedAclForSeries(currentAclName, Optional.of(newAclName), index, orgId, user);
    }

    private void removeAclFromIndex(String currentAclName, ElasticsearchIndex index, String orgId, User user) {
        logger.debug("Update the events to remove the managed acl name '{}'.", (Object)currentAclName);
        this.updateManagedAclForEvents(currentAclName, Optional.empty(), index, orgId, user);
        logger.debug("Update the series to remove the managed acl name '{}'.", (Object)currentAclName);
        this.updateManagedAclForSeries(currentAclName, Optional.empty(), index, orgId, user);
    }

    private void updateManagedAclForSeries(String currentAclName, Optional<String> newAclNameOpt, ElasticsearchIndex index, String orgId, User user) {
        SearchResult result;
        try {
            result = index.getByQuery(new SeriesSearchQuery(orgId, user).withoutActions().withManagedAcl(currentAclName));
        }
        catch (SearchIndexException e) {
            logger.error("Unable to find the series in org '{}' with current managed acl name '{}'", new Object[]{orgId, currentAclName, e});
            return;
        }
        for (SearchResultItem seriesItem : result.getItems()) {
            String seriesId = ((Series)seriesItem.getSource()).getIdentifier();
            Function<Optional, Optional> updateFunction = seriesOpt -> {
                if (seriesOpt.isPresent() && ((Series)seriesOpt.get()).getManagedAcl().equals(currentAclName)) {
                    Series series = (Series)seriesOpt.get();
                    series.setManagedAcl((String)newAclNameOpt.orElse(null));
                    return Optional.of(series);
                }
                return Optional.empty();
            };
            try {
                index.addOrUpdateSeries(seriesId, updateFunction, orgId, user);
            }
            catch (SearchIndexException e) {
                if (newAclNameOpt.isPresent()) {
                    logger.warn("Unable to update series'{}' from current managed acl '{}' to new managed acl name '{}'", new Object[]{seriesId, currentAclName, newAclNameOpt.get(), e});
                    continue;
                }
                logger.warn("Unable to update series '{}' to remove managed acl '{}'", new Object[]{seriesId, currentAclName, e});
            }
        }
    }

    private void updateManagedAclForEvents(String currentAclName, Optional<String> newAclNameOpt, ElasticsearchIndex index, String orgId, User user) {
        SearchResult result;
        try {
            result = index.getByQuery(new EventSearchQuery(orgId, user).withoutActions().withManagedAcl(currentAclName));
        }
        catch (SearchIndexException e) {
            logger.error("Unable to find the events in org '{}' with current managed acl name '{}' for event", new Object[]{orgId, currentAclName, e});
            return;
        }
        for (SearchResultItem eventItem : result.getItems()) {
            String eventId = ((Event)eventItem.getSource()).getIdentifier();
            Function<Optional, Optional> updateFunction = eventOpt -> {
                if (eventOpt.isPresent() && ((Event)eventOpt.get()).getManagedAcl().equals(currentAclName)) {
                    Event event = (Event)eventOpt.get();
                    event.setManagedAcl((String)newAclNameOpt.orElse(null));
                    return Optional.of(event);
                }
                return Optional.empty();
            };
            try {
                index.addOrUpdateEvent(eventId, updateFunction, orgId, user);
            }
            catch (SearchIndexException e) {
                if (newAclNameOpt.isPresent()) {
                    logger.warn("Unable to update event '{}' from current managed acl '{}' to new managed acl name '{}'", new Object[]{eventId, currentAclName, newAclNameOpt.get(), e});
                    continue;
                }
                logger.warn("Unable to update event '{}' to remove managed acl '{}'", new Object[]{eventId, currentAclName, e});
            }
        }
    }
}

