/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.authorization.xacml.manager.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FilenameUtils;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.opencastproject.authorization.xacml.XACMLParsingException;
import org.opencastproject.authorization.xacml.XACMLUtils;
import org.opencastproject.authorization.xacml.manager.api.AclService;
import org.opencastproject.authorization.xacml.manager.api.AclServiceException;
import org.opencastproject.authorization.xacml.manager.api.AclServiceFactory;
import org.opencastproject.authorization.xacml.manager.api.ManagedAcl;
import org.opencastproject.authorization.xacml.manager.impl.ManagedAclImpl;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.util.NotFoundException;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ArtifactInstaller.class, AclScanner.class}, property={"service.description=Acl Scanner"})
public class AclScanner
implements ArtifactInstaller {
    public static final String ACL_DIRECTORY = "acl";
    private static final Logger logger = LoggerFactory.getLogger(AclScanner.class);
    private OrganizationDirectoryService organizationDirectoryService;
    private AclServiceFactory aclServiceFactory;
    private SecurityService securityService;
    private Map<String, Long> managedAcls = new HashMap<String, Long>();

    @Activate
    void activate(BundleContext ctx) {
        logger.info("Activated Acl scanner");
    }

    @Deactivate
    void deactivate(BundleContext ctx) {
        logger.info("Deactivated Acl scanner");
    }

    @Reference
    void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Reference
    void setAclServiceFactory(AclServiceFactory aclServiceFactory) {
        this.aclServiceFactory = aclServiceFactory;
    }

    @Reference
    void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public boolean canHandle(File artifact) {
        return ACL_DIRECTORY.equals(artifact.getParentFile().getName()) && artifact.getName().endsWith(".xml");
    }

    private void addAcl(File artifact) throws IOException, XACMLParsingException {
        List organizations = this.organizationDirectoryService.getOrganizations();
        logger.debug("Adding Acl {}", (Object)artifact.getAbsolutePath());
        String fileName = FilenameUtils.removeExtension((String)artifact.getName());
        AccessControlList acl = this.parseToAcl(artifact);
        for (Organization org : organizations) {
            this.securityService.setOrganization(org);
            boolean skip = false;
            for (ManagedAcl a : this.getAclService(org).getAcls()) {
                if (this.managedAcls.get(this.generateAclId(a.getName(), org)) != null) continue;
                logger.debug("The Acl {} will be not added to the organisation {} as it already contains other not-default Acls.", (Object)fileName, (Object)org.getName());
                skip = true;
            }
            if (skip) continue;
            Optional<ManagedAcl> managedAcl = this.getAclService(org).createAcl(acl, fileName);
            if (managedAcl.isPresent()) {
                this.managedAcls.put(this.generateAclId(fileName, org), managedAcl.get().getId());
                logger.debug("Acl from '{}' has been added for the organisation {}", (Object)fileName, (Object)org.getName());
                continue;
            }
            logger.debug("Acl from '{}' has already been added to the organisation {}.", (Object)fileName, (Object)org.getName());
        }
    }

    private void updateAcl(File artifact) throws IOException, XACMLParsingException {
        List organizations = this.organizationDirectoryService.getOrganizations();
        logger.debug("Updating Acl {}", (Object)artifact.getAbsolutePath());
        String fileName = FilenameUtils.removeExtension((String)artifact.getName());
        AccessControlList acl = this.parseToAcl(artifact);
        for (Organization org : organizations) {
            this.securityService.setOrganization(org);
            Long id = this.managedAcls.get(this.generateAclId(fileName, org));
            if (id != null) {
                if (!this.getAclService(org).updateAcl(new ManagedAclImpl(id, fileName, org.getId(), acl))) {
                    logger.warn("No Acl found with the id {} for the organisation {}.", (Object)id, (Object)org.getName());
                    continue;
                }
                logger.debug("Acl from XACML file {} has been updated for the organisation {}", (Object)fileName, (Object)org.getName());
                continue;
            }
            logger.info("The XACML file {} has not been added to the organisation {} and will therefore not be updated", (Object)fileName, (Object)org.getName());
        }
    }

    private void removeAcl(File artifact) throws IOException, JAXBException {
        List organizations = this.organizationDirectoryService.getOrganizations();
        logger.debug("Removing Acl {}", (Object)artifact.getAbsolutePath());
        String fileName = FilenameUtils.removeExtension((String)artifact.getName());
        for (Organization org : organizations) {
            this.securityService.setOrganization(org);
            Long id = this.managedAcls.get(this.generateAclId(fileName, org));
            if (id != null) {
                try {
                    this.getAclService(org).deleteAcl(id);
                }
                catch (NotFoundException e) {
                    logger.warn("Unable to delete managec acl {}: Managed acl already deleted!", (Object)id);
                }
                catch (AclServiceException e) {
                    logger.error("Unable to delete managed acl {}", (Object)id, (Object)e);
                }
                continue;
            }
            logger.debug("No Acl found with the id {}.", (Object)id);
        }
    }

    private String generateAclId(String fileName, Organization org) {
        return fileName + "_" + org.getId();
    }

    private AccessControlList parseToAcl(File artifact) throws IOException, XACMLParsingException {
        try (FileInputStream in = new FileInputStream(artifact);){
            AccessControlList accessControlList = XACMLUtils.parseXacml((InputStream)in);
            return accessControlList;
        }
    }

    private AclService getAclService(Organization organization) {
        return this.aclServiceFactory.serviceFor(organization);
    }

    public void install(File artifact) throws Exception {
        logger.info("Installing Acl {}", (Object)artifact.getAbsolutePath());
        this.addAcl(artifact);
    }

    public void update(File artifact) throws Exception {
        logger.info("Updating Acl {}", (Object)artifact.getAbsolutePath());
        this.updateAcl(artifact);
    }

    public void uninstall(File artifact) throws Exception {
        logger.info("Removing Acl {}", (Object)artifact.getAbsolutePath());
        this.removeAcl(artifact);
    }
}

