/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.assetmanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageReference;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, name="org.opencastproject.workflow.handler.assetmanager.AssetManagerAddWorkflowOperationHandler", service={WorkflowOperationHandler.class}, property={"service.description=Asset Manager Take Snapshot Workflow Operation Handler", "workflow.operation=snapshot"})
public class AssetManagerSnapshotWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(AssetManagerSnapshotWorkflowOperationHandler.class);
    private AssetManager assetManager;

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public WorkflowOperationResult start(WorkflowInstance wi, JobContext ctx) throws WorkflowOperationException {
        MediaPackage mpWorkflow = wi.getMediaPackage();
        WorkflowOperationInstance currentOperation = wi.getCurrentOperation();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(wi, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none);
        ArrayList<String> sourceTagsOption = tagsAndFlavors.getSrcTags();
        List sourceFlavorsOption = tagsAndFlavors.getSrcFlavors();
        if (sourceTagsOption.isEmpty() && sourceFlavorsOption.isEmpty()) {
            logger.debug("No source tags have been specified, so everything will be added to the AssetManager");
        }
        ArrayList<String> tagSet = !sourceTagsOption.isEmpty() ? sourceTagsOption : new ArrayList<String>();
        try {
            MediaPackage mpAssetManager = this.getMediaPackageForArchival(mpWorkflow, tagSet, sourceFlavorsOption);
            if (mpAssetManager != null) {
                logger.info("Take snapshot of media package {}", (Object)mpAssetManager);
                this.assetManager.takeSnapshot("default", mpAssetManager);
                logger.debug("Snapshot operation complete");
                return this.createResult(mpWorkflow, WorkflowOperationResult.Action.CONTINUE);
            }
            return this.createResult(mpWorkflow, WorkflowOperationResult.Action.CONTINUE);
        }
        catch (Throwable t) {
            throw new WorkflowOperationException(t);
        }
    }

    protected MediaPackage getMediaPackageForArchival(MediaPackage current, List<String> tags, List<MediaPackageElementFlavor> sourceFlavors) throws MediaPackageException {
        Collection<Object> keep;
        MediaPackage mp = (MediaPackage)current.clone();
        if (tags.isEmpty() && sourceFlavors.isEmpty()) {
            keep = new ArrayList<MediaPackageElement>(Arrays.asList(current.getElementsByTags(tags)));
        } else {
            Publication[] simpleElementSelector = new SimpleElementSelector();
            for (MediaPackageElementFlavor flavor : sourceFlavors) {
                simpleElementSelector.addFlavor(flavor);
            }
            for (String tag : tags) {
                simpleElementSelector.addTag(tag);
            }
            keep = simpleElementSelector.select(current, false);
        }
        for (Publication publication : current.getPublications()) {
            keep.add((MediaPackageElement)publication);
        }
        ArrayList<MediaPackageElement> removals = new ArrayList<MediaPackageElement>();
        for (MediaPackageElement element : mp.getElements()) {
            if (keep.contains(element)) continue;
            removals.add(element);
        }
        for (MediaPackageElement element : mp.getElements()) {
            MediaPackageElement parent;
            MediaPackageElement referencedElement;
            MediaPackageReference reference;
            if (removals.contains(element) || (reference = element.getReference()) == null || (referencedElement = mp.getElementByReference(reference)) == null || !removals.contains(referencedElement)) continue;
            while ((parent = current.getElementByReference(reference)) != null) {
                if (parent.getFlavor() != null && element.getFlavor() == null) {
                    element.setFlavor(parent.getFlavor());
                }
                if (parent.getReference() == null) break;
                reference = parent.getReference();
            }
            if (reference != null && reference.getType().equals("mediapackage")) {
                element.setReference(reference);
                continue;
            }
            element.clearReference();
        }
        for (MediaPackageElement element : removals) {
            mp.remove(element);
        }
        return mp;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

