/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl.query;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.Opt;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.expr.BooleanExpression;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.opencastproject.assetmanager.impl.query.Join;
import org.opencastproject.assetmanager.impl.query.JpaFns;

@ParametersAreNonnullByDefault
public final class SelectQueryContribution {
    final Stream<Expression<?>> fetch;
    final Stream<EntityPath<?>> from;
    final Stream<Join> join;
    final Opt<BooleanExpression> where;
    final Opt<Integer> offset;
    final Opt<Integer> limit;
    final Stream<OrderSpecifier<?>> order;
    static final Fn<SelectQueryContribution, Stream<Expression<?>>> getFetch = new Fn<SelectQueryContribution, Stream<Expression<?>>>(){

        public Stream<Expression<?>> apply(SelectQueryContribution c) {
            return c.fetch;
        }
    };
    static final Fn<SelectQueryContribution, Stream<EntityPath<?>>> getFrom = new Fn<SelectQueryContribution, Stream<EntityPath<?>>>(){

        public Stream<EntityPath<?>> apply(SelectQueryContribution c) {
            return c.from;
        }
    };
    static final Fn<SelectQueryContribution, Stream<Join>> getJoin = new Fn<SelectQueryContribution, Stream<Join>>(){

        public Stream<Join> apply(SelectQueryContribution c) {
            return c.join;
        }
    };
    static final Fn<SelectQueryContribution, Opt<BooleanExpression>> getWhere = new Fn<SelectQueryContribution, Opt<BooleanExpression>>(){

        public Opt<BooleanExpression> apply(SelectQueryContribution c) {
            return c.where;
        }
    };
    static final Fn<SelectQueryContribution, Stream<OrderSpecifier<?>>> getOrder = new Fn<SelectQueryContribution, Stream<OrderSpecifier<?>>>(){

        public Stream<OrderSpecifier<?>> apply(SelectQueryContribution c) {
            return c.order;
        }
    };

    public SelectQueryContribution(Stream<Expression<?>> fetch, Stream<EntityPath<?>> from, Stream<Join> join, Opt<BooleanExpression> where, Opt<Integer> offset, Opt<Integer> limit, Stream<OrderSpecifier<?>> order) {
        this.fetch = fetch;
        this.from = from;
        this.join = join;
        this.where = where;
        this.offset = offset;
        this.limit = limit;
        this.order = order;
    }

    public static SelectQueryContribution mk() {
        return new SelectQueryContribution(Stream.empty(), Stream.empty(), (Stream<Join>)Stream.empty(), (Opt<BooleanExpression>)Opt.none(), (Opt<Integer>)Opt.none(), (Opt<Integer>)Opt.none(), Stream.empty());
    }

    SelectQueryContribution fetch(Stream<? extends Expression<?>> fetch) {
        return new SelectQueryContribution(fetch, this.from, this.join, this.where, this.offset, this.limit, this.order);
    }

    SelectQueryContribution addFetch(Stream<? extends Expression<?>> fetch) {
        return new SelectQueryContribution(this.fetch.append(fetch), this.from, this.join, this.where, this.offset, this.limit, this.order);
    }

    SelectQueryContribution from(Stream<? extends EntityPath<?>> from) {
        return new SelectQueryContribution(this.fetch, from, this.join, this.where, this.offset, this.limit, this.order);
    }

    SelectQueryContribution addFrom(Stream<? extends EntityPath<?>> from) {
        return new SelectQueryContribution(this.fetch, this.from.append(from), this.join, this.where, this.offset, this.limit, this.order);
    }

    SelectQueryContribution join(Stream<Join> join) {
        return new SelectQueryContribution(this.fetch, this.from, join, this.where, this.offset, this.limit, this.order);
    }

    SelectQueryContribution join(Join join) {
        return this.join((Stream<Join>)Stream.$((Object[])new Join[]{join}));
    }

    SelectQueryContribution addJoin(Stream<Join> join) {
        return new SelectQueryContribution(this.fetch, this.from, (Stream<Join>)this.join.append(join), this.where, this.offset, this.limit, this.order);
    }

    SelectQueryContribution addJoin(Join join) {
        return this.addJoin((Stream<Join>)Stream.$((Object[])new Join[]{join}));
    }

    SelectQueryContribution where(Opt<BooleanExpression> where) {
        return new SelectQueryContribution(this.fetch, this.from, this.join, where, this.offset, this.limit, this.order);
    }

    SelectQueryContribution where(@Nullable BooleanExpression where) {
        return this.where((Opt<BooleanExpression>)Opt.nul((Object)where));
    }

    SelectQueryContribution andWhere(Opt<BooleanExpression> where) {
        return this.where(JpaFns.allOf(this.where, where));
    }

    SelectQueryContribution andWhere(@Nullable BooleanExpression where) {
        return this.andWhere((Opt<BooleanExpression>)Opt.nul((Object)where));
    }

    SelectQueryContribution offset(Opt<Integer> offset) {
        return new SelectQueryContribution(this.fetch, this.from, this.join, this.where, offset, this.limit, this.order);
    }

    SelectQueryContribution offset(Integer offset) {
        return this.offset((Opt<Integer>)Opt.some((Object)offset));
    }

    SelectQueryContribution limit(Opt<Integer> limit) {
        return new SelectQueryContribution(this.fetch, this.from, this.join, this.where, this.offset, limit, this.order);
    }

    SelectQueryContribution limit(Integer limit) {
        return this.limit((Opt<Integer>)Opt.some((Object)limit));
    }

    SelectQueryContribution order(Stream<? extends OrderSpecifier<?>> order) {
        return new SelectQueryContribution(this.fetch, this.from, this.join, this.where, this.offset, this.limit, order);
    }

    SelectQueryContribution addOrder(Stream<? extends OrderSpecifier<?>> order) {
        return new SelectQueryContribution(this.fetch, this.from, this.join, this.where, this.offset, this.limit, this.order.append(order));
    }
}

