/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl.query;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.SetB;
import com.mysema.query.Tuple;
import com.mysema.query.jpa.JPASubQuery;
import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.jpa.impl.JPAQueryFactory;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opencastproject.assetmanager.api.Version;
import org.opencastproject.assetmanager.api.query.ADeleteQuery;
import org.opencastproject.assetmanager.api.storage.AssetStore;
import org.opencastproject.assetmanager.api.storage.DeletionSelector;
import org.opencastproject.assetmanager.impl.AssetManagerImpl;
import org.opencastproject.assetmanager.impl.RuntimeTypes;
import org.opencastproject.assetmanager.impl.VersionImpl;
import org.opencastproject.assetmanager.impl.persistence.Conversions;
import org.opencastproject.assetmanager.impl.persistence.EntityPaths;
import org.opencastproject.assetmanager.impl.persistence.QPropertyDto;
import org.opencastproject.assetmanager.impl.persistence.QSnapshotDto;
import org.opencastproject.assetmanager.impl.query.DeleteQueryContribution;
import org.opencastproject.assetmanager.impl.query.DeleteQueryContributor;
import org.opencastproject.assetmanager.impl.query.JpaFns;
import org.opencastproject.util.data.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractADeleteQuery
implements ADeleteQuery,
DeleteQueryContributor,
EntityPaths {
    private static final Logger logger = LoggerFactory.getLogger(AbstractADeleteQuery.class);
    private AssetManagerImpl am;
    private String owner;
    public static final DeleteEpisodeHandler DELETE_EPISODE_HANDLER = new DeleteEpisodeHandler(){

        @Override
        public void handleDeletedEpisode(String mpId) {
        }
    };

    public AbstractADeleteQuery(AssetManagerImpl am, String owner) {
        this.am = am;
        this.owner = owner;
    }

    public ADeleteQuery name(final String queryName) {
        return new AbstractADeleteQuery(this.am, this.owner){

            @Override
            public DeleteQueryContribution contributeDelete(String owner) {
                DeleteQueryContribution cParent = AbstractADeleteQuery.this.contributeDelete(owner);
                return DeleteQueryContribution.mk(cParent).name(queryName);
            }
        };
    }

    public ADeleteQuery where(final org.opencastproject.assetmanager.api.query.Predicate predicate) {
        return new AbstractADeleteQuery(this.am, this.owner){

            @Override
            public DeleteQueryContribution contributeDelete(String owner) {
                DeleteQueryContribution cParent = AbstractADeleteQuery.this.contributeDelete(owner);
                DeleteQueryContribution cPredicate = RuntimeTypes.convert(predicate).contributeDelete(owner);
                return DeleteQueryContribution.mk().from(cParent.from.append(cPredicate.from)).targetPredicate(cParent.targetPredicate).where(JpaFns.allOf(cParent.where, cPredicate.where));
            }

            public String toString() {
                return "where " + predicate;
            }
        };
    }

    public long run(DeleteEpisodeHandler deleteEpisodeHandler) {
        long startTime = System.nanoTime();
        final DeleteQueryContribution c = this.contributeDelete(this.owner);
        DeletionResult deletion = this.am.getDatabase().run(new Function<JPAQueryFactory, DeletionResult>(){

            public DeletionResult apply(JPAQueryFactory jpa) {
                return AbstractADeleteQuery.this.runQueries(jpa, c);
            }
        });
        logger.debug("Pure query ms " + (System.nanoTime() - startTime) / 1000000L);
        for (Tuple t : deletion.deletedSnapshots) {
            String orgId = (String)t.get((Expression)AbstractADeleteQuery.Q_SNAPSHOT.organizationId);
            String mpId = (String)t.get((Expression)AbstractADeleteQuery.Q_SNAPSHOT.mediaPackageId);
            VersionImpl version = Conversions.toVersion((Long)t.get(AbstractADeleteQuery.Q_SNAPSHOT.version));
            DeletionSelector deletionSelector = DeletionSelector.delete((String)orgId, (String)mpId, (Version)version);
            this.am.getLocalAssetStore().delete(deletionSelector);
            for (AssetStore as : this.am.getRemoteAssetStores()) {
                as.delete(deletionSelector);
            }
        }
        for (String mpId : deletion.deletedEpisodes) {
            deleteEpisodeHandler.handleDeletedEpisode(mpId);
        }
        long searchTime = (System.nanoTime() - startTime) / 1000000L;
        logger.debug("Complete query ms " + searchTime);
        return deletion.deletedItemsCount;
    }

    private DeletionResult runQueries(JPAQueryFactory jpa, DeleteQueryContribution c) {
        BooleanExpression where;
        Set f = c.from.toSet(SetB.MH);
        if (f.size() != 1) {
            throw new RuntimeException("Only one entity is allowed in the from clause");
        }
        EntityPath from = (EntityPath)Stream.$((Iterable)f).head2();
        if (from instanceof QSnapshotDto) {
            where = Expressions.allOf((BooleanExpression[])new BooleanExpression[]{(BooleanExpression)c.targetPredicate.orNull(), (BooleanExpression)c.where.apply((Object)Q_SNAPSHOT)});
            List deletedSnapshots = ((JPAQuery)((JPAQuery)jpa.query().from((EntityPath)Q_SNAPSHOT)).where((Predicate)where)).list(new Expression[]{AbstractADeleteQuery.Q_SNAPSHOT.organizationId, AbstractADeleteQuery.Q_SNAPSHOT.mediaPackageId, AbstractADeleteQuery.Q_SNAPSHOT.version});
            JPADeleteClause qMain = jpa.delete((EntityPath)Q_SNAPSHOT).where(new Predicate[]{where});
            this.am.getDatabase().logDelete(AbstractADeleteQuery.formatQueryName(c.name, "main"), qMain);
            long deletedItems = qMain.execute();
            List remainingSnapshots = ((JPAQuery)((JPAQuery)jpa.query().from((EntityPath)Q_SNAPSHOT)).distinct()).list((Expression)AbstractADeleteQuery.Q_SNAPSHOT.mediaPackageId);
            Set d = Stream.$((Iterable)deletedSnapshots).map((Fn)new Fn<Tuple, String>(){

                public String apply(Tuple tuple) {
                    return (String)tuple.get((Expression)EntityPaths.Q_SNAPSHOT.mediaPackageId);
                }
            }).toSet(SetB.MH);
            d.removeAll(remainingSnapshots);
            Set<String> deletedEpisodes = Collections.unmodifiableSet(d);
            return new DeletionResult(deletedItems, deletedSnapshots, deletedEpisodes);
        }
        if (from instanceof QPropertyDto) {
            BooleanExpression w = (BooleanExpression)c.where.apply((Object)Q_PROPERTY);
            where = w != null ? AbstractADeleteQuery.Q_PROPERTY.mediaPackageId.in((CollectionExpression)((JPASubQuery)((JPASubQuery)((JPASubQuery)((JPASubQuery)new JPASubQuery().from((EntityPath)Q_PROPERTY)).join((EntityPath)Q_SNAPSHOT)).where((Predicate)AbstractADeleteQuery.Q_PROPERTY.mediaPackageId.eq((Expression)AbstractADeleteQuery.Q_SNAPSHOT.mediaPackageId).and((Predicate)w))).distinct()).list((Expression)AbstractADeleteQuery.Q_PROPERTY.mediaPackageId)) : null;
            JPADeleteClause qProperties = jpa.delete(from).where(new Predicate[]{Expressions.allOf((BooleanExpression[])new BooleanExpression[]{(BooleanExpression)c.targetPredicate.orNull(), where})});
            this.am.getDatabase().logDelete(AbstractADeleteQuery.formatQueryName(c.name, "main"), qProperties);
            long deletedItems = qProperties.execute();
            return new DeletionResult(deletedItems, Collections.emptyList(), Collections.emptySet());
        }
        throw new RuntimeException("[Bug]");
    }

    public long run() {
        return this.run(DELETE_EPISODE_HANDLER);
    }

    private static String formatQueryName(String name, String subQueryName) {
        return String.format("[%s] [%s]", name, subQueryName);
    }

    public final class DeletionResult {
        public final long deletedItemsCount;
        public final List<Tuple> deletedSnapshots;
        public final Set<String> deletedEpisodes;

        public DeletionResult(long deletedItemsCount, List<Tuple> deletedSnapshots, Set<String> deletedEpisodes) {
            this.deletedItemsCount = deletedItemsCount;
            this.deletedSnapshots = deletedSnapshots;
            this.deletedEpisodes = deletedEpisodes;
        }
    }

    public static interface DeleteEpisodeHandler {
        public void handleDeletedEpisode(String var1);
    }
}

