/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl.query;

import com.entwinemedia.fn.Equality;
import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.data.Opt;
import java.util.List;
import java.util.Optional;
import org.opencastproject.assetmanager.api.Property;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.query.ARecord;
import org.opencastproject.assetmanager.impl.persistence.SnapshotDto;

public final class ARecordImpl
implements ARecord {
    private final long snapshotId;
    private final String mediaPackageId;
    private final List<Property> properties;
    private Optional<Snapshot> snapshot;
    private Opt<SnapshotDto> snapshotDto;
    public static final Fn<ARecordImpl, String> getMediaPackageId = new Fn<ARecordImpl, String>(){

        public String apply(ARecordImpl a) {
            return a.getMediaPackageId();
        }
    };

    public ARecordImpl(long snapshotId, String mediaPackageId, List<Property> properties) {
        this.snapshotId = snapshotId;
        this.mediaPackageId = mediaPackageId;
        this.properties = properties;
        this.snapshot = Optional.empty();
        this.snapshotDto = Opt.none(SnapshotDto.class);
    }

    public ARecordImpl(long snapshotId, String mediaPackageId, List<Property> properties, Snapshot snapshot) {
        this(snapshotId, mediaPackageId, properties);
        if (snapshot != null) {
            this.snapshot = Optional.of(snapshot);
        }
    }

    public ARecordImpl(long snapshotId, String mediaPackageId, List<Property> properties, SnapshotDto snapshotDto) {
        this(snapshotId, mediaPackageId, properties);
        if (snapshotDto != null) {
            this.snapshotDto = Opt.some((Object)snapshotDto);
        }
    }

    public long getSnapshotId() {
        return this.snapshotId;
    }

    public String getMediaPackageId() {
        return this.mediaPackageId;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Optional<Snapshot> getSnapshot() {
        if (this.snapshot.isEmpty() && this.snapshotDto.isSome()) {
            this.snapshot = Optional.of(((SnapshotDto)this.snapshotDto.get()).toSnapshot());
        }
        return this.snapshot;
    }

    public Opt<SnapshotDto> getSnapshotDto() {
        return this.snapshotDto;
    }

    public int hashCode() {
        return Equality.hash((Object[])new Object[]{this.snapshotId});
    }

    public boolean equals(Object that) {
        return this == that || that instanceof ARecordImpl && this.eqFields((ARecordImpl)that);
    }

    private boolean eqFields(ARecordImpl that) {
        return Equality.eq((Object)this.snapshotId, (Object)that.snapshotId);
    }
}

