/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl.persistence;

import com.entwinemedia.fn.data.Opt;
import com.mysema.query.Tuple;
import com.mysema.query.jpa.EclipseLinkTemplates;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.jpa.impl.JPAQueryFactory;
import com.mysema.query.jpa.impl.JPAUpdateClause;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.assetmanager.api.Availability;
import org.opencastproject.assetmanager.api.Property;
import org.opencastproject.assetmanager.api.PropertyId;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.impl.PartialMediaPackage;
import org.opencastproject.assetmanager.impl.VersionImpl;
import org.opencastproject.assetmanager.impl.persistence.AssetDto;
import org.opencastproject.assetmanager.impl.persistence.AssetDtos;
import org.opencastproject.assetmanager.impl.persistence.EntityPaths;
import org.opencastproject.assetmanager.impl.persistence.PropertyDto;
import org.opencastproject.assetmanager.impl.persistence.QAssetDto;
import org.opencastproject.assetmanager.impl.persistence.QSnapshotDto;
import org.opencastproject.assetmanager.impl.persistence.SnapshotDto;
import org.opencastproject.assetmanager.impl.persistence.SnapshotDtos;
import org.opencastproject.assetmanager.impl.persistence.VersionClaimDto;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.Queries;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.util.data.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class Database
implements EntityPaths {
    private static final Logger logger = LoggerFactory.getLogger(Database.class);
    public static final JPQLTemplates TEMPLATES = EclipseLinkTemplates.DEFAULT;
    private final DBSession db;

    public Database(DBSession db) {
        this.db = db;
    }

    public <A> A run(Function<JPAQueryFactory, A> q) {
        return (A)this.db.execTx(em -> q.apply((Object)new JPAQueryFactory(TEMPLATES, () -> em)));
    }

    public void logQuery(JPAQuery q) {
        logger.debug("\n---\nQUERY\n{}\n---", (Object)q);
    }

    public void logDelete(String queryName, JPADeleteClause q) {
        logger.debug("\n---\nDELETE {}\n{}\n---", (Object)queryName, (Object)q);
    }

    public boolean saveProperty(Property property) {
        return (Boolean)this.db.execTx(em -> {
            PropertyId pId = property.getId();
            BooleanExpression eitherMatchOrNull = Database.Q_PROPERTY.namespace.eq((Object)pId.getNamespace()).and((Predicate)Database.Q_PROPERTY.propertyName.eq((Object)pId.getName())).or((Predicate)Database.Q_PROPERTY.namespace.isNull());
            Tuple result = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)new JPAQuery(em, TEMPLATES).from((EntityPath)Q_SNAPSHOT)).leftJoin((EntityPath)Q_PROPERTY)).on((Predicate)Database.Q_SNAPSHOT.mediaPackageId.eq((Expression)Database.Q_PROPERTY.mediaPackageId).and((Predicate)eitherMatchOrNull))).where((Predicate)Database.Q_SNAPSHOT.mediaPackageId.eq((Object)pId.getMediaPackageId()))).singleResult(new Expression[]{Database.Q_SNAPSHOT.id, Q_PROPERTY});
            if (result != null) {
                PropertyDto exists = (PropertyDto)result.get((Expression)Q_PROPERTY);
                Queries.namedQuery.persistOrUpdate((Object)(exists == null ? PropertyDto.mk(property) : exists.update(property.getValue()))).apply(em);
                return true;
            }
            return false;
        });
    }

    public VersionImpl claimVersion(String mpId) {
        return (VersionImpl)this.db.execTx(em -> {
            Optional<VersionClaimDto> lastOpt = VersionClaimDto.findLastQuery(mpId).apply((EntityManager)em);
            if (lastOpt.isPresent()) {
                VersionImpl claim = VersionImpl.next(lastOpt.get().getLastClaimed());
                VersionClaimDto.updateQuery(mpId, claim.value()).apply((EntityManager)em);
                return claim;
            }
            VersionImpl first = VersionImpl.FIRST;
            em.persist((Object)VersionClaimDto.mk(mpId, first.value()));
            return first;
        });
    }

    public SnapshotDto saveSnapshot(String orgId, PartialMediaPackage pmp, Date archivalDate, VersionImpl version, Availability availability, String storageId, String owner) {
        SnapshotDto snapshotDto = SnapshotDto.mk(pmp.getMediaPackage(), version, orgId, archivalDate, availability, storageId, owner);
        return (SnapshotDto)this.db.execTx(em -> {
            em.persist((Object)snapshotDto);
            for (MediaPackageElement e : pmp.getElements()) {
                AssetDto a = AssetDto.mk(e.getIdentifier(), snapshotDto, e.getChecksum().toString(), Optional.ofNullable(e.getMimeType()), storageId, e.getSize());
                em.persist((Object)a);
            }
            return snapshotDto;
        });
    }

    public void setStorageLocation(Snapshot snapshot, String storageId) {
        this.setStorageLocation(VersionImpl.mk(snapshot.getVersion()), snapshot.getMediaPackage().getIdentifier().toString(), storageId);
    }

    public void setStorageLocation(VersionImpl version, String mpId, String storageId) {
        this.db.execTx(em -> {
            QSnapshotDto q = QSnapshotDto.snapshotDto;
            QAssetDto a = QAssetDto.assetDto;
            new JPAUpdateClause(em, (EntityPath)q, TEMPLATES).where(new Predicate[]{q.version.eq((Object)version.value()).and((Predicate)q.mediaPackageId.eq((Object)mpId))}).set((Path)q.storageId, (Object)storageId).execute();
            Optional<SnapshotDtos.Medium> s = this.getSnapshot(version, mpId);
            new JPAUpdateClause(em, (EntityPath)a, TEMPLATES).where(new Predicate[]{a.snapshot.id.eq((Object)s.get().getSnapshotDto().getId())}).set((Path)a.storageId, (Object)storageId).execute();
            return null;
        });
    }

    public void setAssetStorageLocation(VersionImpl version, String mpId, String mpeId, String storageId) {
        this.db.execTx(em -> {
            QAssetDto a = QAssetDto.assetDto;
            Optional<SnapshotDtos.Medium> s = this.getSnapshot(version, mpId);
            new JPAUpdateClause(em, (EntityPath)a, TEMPLATES).where(new Predicate[]{a.snapshot.id.eq((Object)s.get().getSnapshotDto().getId()).and((Predicate)a.mediaPackageElementId.eq((Object)mpeId))}).set((Path)a.storageId, (Object)storageId).execute();
            return null;
        });
    }

    public void setAvailability(VersionImpl version, String mpId, Availability availability) {
        this.db.execTx(em -> {
            QSnapshotDto q = QSnapshotDto.snapshotDto;
            new JPAUpdateClause(em, (EntityPath)q, TEMPLATES).where(new Predicate[]{q.version.eq((Object)version.value()).and((Predicate)q.mediaPackageId.eq((Object)mpId))}).set((Path)q.availability, (Object)availability.name()).execute();
            return null;
        });
    }

    public Optional<AssetDtos.Medium> getAsset(VersionImpl version, String mpId, String mpeId) {
        return (Optional)this.db.execTx(em -> {
            QAssetDto assetDto = QAssetDto.assetDto;
            Tuple result = ((JPAQuery)((JPAQuery)AssetDtos.baseJoin(em).where((Predicate)assetDto.snapshot.mediaPackageId.eq((Object)mpId).and((Predicate)assetDto.mediaPackageElementId.eq((Object)mpeId)).and((Predicate)assetDto.snapshot.version.eq((Object)version.value())))).orderBy(assetDto.snapshot.version.desc())).uniqueResult(AssetDtos.Medium.select);
            Opt dtoOpt = Opt.nul((Object)result).map(AssetDtos.Medium.fromTuple);
            return dtoOpt.isSome() ? Optional.of((AssetDtos.Medium)dtoOpt.get()) : Optional.empty();
        });
    }

    public Optional<SnapshotDtos.Medium> getSnapshot(VersionImpl version, String mpId) {
        return (Optional)this.db.execTx(em -> {
            QSnapshotDto snapshotDto = QSnapshotDto.snapshotDto;
            Tuple result = ((JPAQuery)((JPAQuery)SnapshotDtos.baseQuery(em).where((Predicate)snapshotDto.mediaPackageId.eq((Object)mpId).and((Predicate)snapshotDto.version.eq((Object)version.value())))).orderBy(snapshotDto.version.desc())).uniqueResult(SnapshotDtos.Medium.select);
            Opt dtoOpt = Opt.nul((Object)result).map(SnapshotDtos.Medium.fromTuple);
            return dtoOpt.isSome() ? Optional.of((SnapshotDtos.Medium)dtoOpt.get()) : Optional.empty();
        });
    }

    public Optional<AssetDtos.Full> findAssetByChecksum(String checksum) {
        return (Optional)this.db.execTx(em -> {
            Tuple result = ((JPAQuery)AssetDtos.baseJoin(em).where((Predicate)QAssetDto.assetDto.checksum.eq((Object)checksum))).singleResult(AssetDtos.Full.select);
            Opt dtoOpt = Opt.nul((Object)result).map(AssetDtos.Full.fromTuple);
            return dtoOpt.isSome() ? Optional.of((AssetDtos.Full)dtoOpt.get()) : Optional.empty();
        });
    }

    public int deleteProperties(String mediaPackageId) {
        return (Integer)this.db.execTx(PropertyDto.deleteQuery(mediaPackageId));
    }

    public int deleteProperties(String mediaPackageId, String namespace) {
        if (StringUtils.isBlank((CharSequence)namespace)) {
            return (Integer)this.db.execTx(PropertyDto.deleteQuery(mediaPackageId));
        }
        return (Integer)this.db.execTx(PropertyDto.deleteQuery(mediaPackageId, namespace));
    }

    public boolean snapshotExists(String mediaPackageId) {
        return (Boolean)this.db.execTx(SnapshotDto.existsQuery(mediaPackageId));
    }

    public boolean snapshotExists(String mediaPackageId, String organization) {
        return (Boolean)this.db.exec(SnapshotDto.existsQuery(mediaPackageId, organization));
    }

    public List<Property> selectProperties(String mediaPackageId, String namespace) {
        return (List)this.db.exec(PropertyDto.selectQuery(mediaPackageId, namespace));
    }

    public long countEvents(String organization) {
        return (Long)this.db.exec(SnapshotDto.countEventsQuery(organization));
    }

    public Optional<AssetDtos.Full> findAssetByChecksumAndStoreAndOrg(String checksum, String storeId, String orgId) {
        return (Optional)this.db.execTx(em -> {
            Tuple result = ((JPAQuery)AssetDtos.baseJoin(em).where((Predicate)QAssetDto.assetDto.checksum.eq((Object)checksum).and((Predicate)QAssetDto.assetDto.storageId.eq((Object)storeId)).and((Predicate)QAssetDto.assetDto.snapshot.organizationId.eq((Object)orgId)))).singleResult(AssetDtos.Full.select);
            Opt dtoOpt = Opt.nul((Object)result).map(AssetDtos.Full.fromTuple);
            return dtoOpt.isSome() ? Optional.of((AssetDtos.Full)dtoOpt.get()) : Optional.empty();
        });
    }

    public static <A> A insidePersistenceContextCheck(A a) {
        if (a != null) {
            return a;
        }
        throw new RuntimeException("Used DTO outside of a persistence context or the DTO has not been assigned an ID yet.");
    }
}

