/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl.persistence;

import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.opencastproject.assetmanager.impl.VersionImpl;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.util.MimeType;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.data.functions.Functions;

@ParametersAreNonnullByDefault
public final class Conversions {
    private Conversions() {
    }

    public static VersionImpl toVersion(long a) {
        return VersionImpl.mk(a);
    }

    public static MediaPackage toMediaPackage(String xml) {
        try {
            return MediaPackageParser.getFromXml((String)xml);
        }
        catch (MediaPackageException e) {
            return (MediaPackage)Functions.chuck((Throwable)e);
        }
    }

    public static Optional<MimeType> toMimeType(@Nullable String a) {
        if (a != null) {
            try {
                return Optional.of(MimeTypes.parseMimeType((String)a));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

