/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl.endpoint;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.data.Opt;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.impl.AssetManagerImpl;
import org.opencastproject.assetmanager.impl.HttpAssetProvider;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.util.MimeType;
import org.opencastproject.util.MimeTypeUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.UrlSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=HttpAssetProvider for the AssetManager", "assetmanager.service.path=/assets"}, immediate=true, service={HttpAssetProvider.class})
public class OsgiEndpointHttpAssetProvider
implements HttpAssetProvider {
    private static final Logger logger = LoggerFactory.getLogger(OsgiEndpointHttpAssetProvider.class);
    private String serverUrl;
    private String mountPoint;
    private OrganizationDirectoryService orgDir;

    private String calcServerUrl(String organizationId) {
        Organization organization = null;
        try {
            organization = this.orgDir.getOrganization(organizationId);
        }
        catch (NotFoundException e) {
            logger.warn("No organization found! Using default server url ({})", (Object)this.serverUrl);
            return this.serverUrl.trim();
        }
        String orgServerUrl = (String)organization.getProperties().get("org.opencastproject.assetmanager.url");
        if (StringUtils.isBlank((CharSequence)orgServerUrl)) {
            orgServerUrl = (String)organization.getProperties().get("org.opencastproject.admin.ui.url");
            logger.debug("No asset manager URL for organization '{}'. Falling back to admin node url ({})", (Object)organization, (Object)orgServerUrl);
        }
        if (StringUtils.isBlank((CharSequence)orgServerUrl)) {
            logger.debug("No admin node URL for organization '{}' set. Falling back to default server url ({})", (Object)organization, (Object)this.serverUrl);
            orgServerUrl = this.serverUrl;
        }
        return orgServerUrl.trim();
    }

    @Override
    public Snapshot prepareForDelivery(final Snapshot snapshot) {
        return AssetManagerImpl.rewriteUris(snapshot, new Fn<MediaPackageElement, URI>(){

            public URI apply(MediaPackageElement mpe) {
                return OsgiEndpointHttpAssetProvider.this.createUriFor(mpe, snapshot);
            }
        });
    }

    private URI createUriFor(MediaPackageElement mpe, Snapshot snapshot) {
        Optional<String> fileNameOpt = AssetManagerImpl.getFileNameFromUrn(mpe);
        Object fileName = fileNameOpt.isPresent() ? fileNameOpt.get() : mpe.getElementType().toString() + "." + OsgiEndpointHttpAssetProvider.mimeTypeToSuffix((Opt<MimeType>)Opt.nul((Object)mpe.getMimeType()));
        return UrlSupport.uri((Object[])new Object[]{this.calcServerUrl(snapshot.getOrganizationId().toString()), this.mountPoint, "assets", mpe.getMediaPackage().getIdentifier().toString(), mpe.getIdentifier(), snapshot.getVersion().toString(), fileName});
    }

    private static String mimeTypeToSuffix(Opt<MimeType> t) {
        return (String)t.bind(MimeTypeUtil.Fns.suffix).getOr((Object)"unknown");
    }

    @Activate
    public void activate(ComponentContext cc) {
        this.serverUrl = OsgiUtil.getContextProperty((ComponentContext)cc, (String)"org.opencastproject.server.url");
        this.mountPoint = OsgiUtil.getComponentContextProperty((ComponentContext)cc, (String)"assetmanager.service.path");
    }

    @Reference
    public void setOrgDir(OrganizationDirectoryService orgDir) {
        this.orgDir = orgDir;
    }
}

