/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl.endpoint;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.assetmanager.api.Asset;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Property;
import org.opencastproject.assetmanager.api.PropertyId;
import org.opencastproject.assetmanager.api.PropertyName;
import org.opencastproject.assetmanager.api.Value;
import org.opencastproject.assetmanager.api.Version;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.ARecord;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.ASelectQuery;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageImpl;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.Checksum;
import org.opencastproject.util.ChecksumType;
import org.opencastproject.util.MimeType;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RestService(name="assetManager", title="AssetManager", notes={"All paths are relative to the REST endpoint base (something like http://your.server/files)", "If you notice that this service is not working as expected, there might be a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"http://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"}, abstractText="This service indexes and queries available (distributed) episodes.")
public abstract class AbstractAssetManagerRestEndpoint
extends AbstractJobProducerEndpoint {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractAssetManagerRestEndpoint.class);
    private final Gson gson = new Gson();
    private final Type stringMapType = new TypeToken<Map<String, String>>(){}.getType();

    public abstract AssetManager getAssetManager();

    @POST
    @Path(value="add")
    @RestQuery(name="add", description="Adds a media package to the asset manager. This method is deprecated in favor of method POST 'snapshot'.", restParameters={@RestParameter(name="mediapackage", isRequired=true, type=RestParameter.Type.TEXT, description="The media package to add to the search index.")}, responses={@RestResponse(description="The media package was added, no content to return.", responseCode=204), @RestResponse(description="Not allowed to add a media package.", responseCode=403), @RestResponse(description="There has been an internal error and the media package could not be added", responseCode=500)}, returnDescription="No content is returned.")
    @Deprecated
    public Response add(@FormParam(value="mediapackage") MediaPackageImpl mediaPackage) {
        return this.snapshot(mediaPackage);
    }

    @POST
    @Path(value="snapshot")
    @RestQuery(name="snapshot", description="Take a versioned snapshot of a media package.", restParameters={@RestParameter(name="mediapackage", isRequired=true, type=RestParameter.Type.TEXT, description="The media package to take a snapshot from.")}, responses={@RestResponse(description="A snapshot of the media package has been taken, no content to return.", responseCode=204), @RestResponse(description="Not allowed to take a snapshot.", responseCode=403), @RestResponse(description="There has been an internal error and no snapshot could be taken.", responseCode=500)}, returnDescription="No content is returned.")
    public Response snapshot(@FormParam(value="mediapackage") MediaPackageImpl mediaPackage) {
        try {
            this.getAssetManager().takeSnapshot("default", (MediaPackage)mediaPackage);
            return RestUtil.R.noContent();
        }
        catch (Exception e) {
            return AbstractAssetManagerRestEndpoint.handleException(e);
        }
    }

    @DELETE
    @Path(value="delete/{id}")
    @RestQuery(name="deleteSnapshots", description="Removes snapshots of an episode, owned by the default owner from the asset manager.", pathParameters={@RestParameter(name="id", isRequired=true, type=RestParameter.Type.STRING, description="The media package ID of the episode whose snapshots shall be removed from the asset manager.")}, responses={@RestResponse(description="Snapshots have been removed, no content to return.", responseCode=204), @RestResponse(description="The episode does either not exist or no snapshots are owned by the default owner.", responseCode=404), @RestResponse(description="Not allowed to delete this episode.", responseCode=403), @RestResponse(description="There has been an internal error and the episode could not be deleted.", responseCode=500)}, returnDescription="No content is returned.")
    public Response delete(@PathParam(value="id") String mediaPackageId) {
        if (StringUtils.isEmpty((CharSequence)mediaPackageId)) {
            return RestUtil.R.notFound();
        }
        try {
            AQueryBuilder q = this.getAssetManager().createQuery();
            if (q.delete("default", q.snapshot()).where(q.mediaPackageId(mediaPackageId)).run() > 0L) {
                return RestUtil.R.noContent();
            }
            return RestUtil.R.notFound();
        }
        catch (Exception e) {
            return AbstractAssetManagerRestEndpoint.handleException(e);
        }
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="episode/{mediaPackageID}")
    @RestQuery(name="getLatestEpisode", description="Get the media package from the last snapshot of an episode.", returnDescription="The media package", pathParameters={@RestParameter(name="mediaPackageID", description="the media package ID", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Media package returned"), @RestResponse(responseCode=404, description="Not found"), @RestResponse(responseCode=403, description="Not allowed to read media package."), @RestResponse(responseCode=500, description="There has been an internal error.")})
    public Response getMediaPackage(@PathParam(value="mediaPackageID") String mediaPackageId) {
        try {
            Optional mp = this.getAssetManager().getMediaPackage(mediaPackageId);
            if (mp.isPresent()) {
                return RestUtil.R.ok(mp.get());
            }
            return RestUtil.R.notFound();
        }
        catch (Exception e) {
            return AbstractAssetManagerRestEndpoint.handleException(e);
        }
    }

    @GET
    @Path(value="assets/{mediaPackageID}/{mediaPackageElementID}/{version}/{filename}")
    @RestQuery(name="getAsset", description="Get an asset", returnDescription="The file", pathParameters={@RestParameter(name="mediaPackageID", description="the media package identifier", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="mediaPackageElementID", description="the media package element identifier", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="version", description="the media package version", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="filename", description="a descriptive filename used as the download filename", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="File returned"), @RestResponse(responseCode=404, description="Not found"), @RestResponse(responseCode=304, description="If file not modified"), @RestResponse(description="Not allowed to read assets of this snapshot.", responseCode=403), @RestResponse(description="There has been an internal error.", responseCode=500)})
    public Response getAsset(@PathParam(value="mediaPackageID") String mediaPackageID, @PathParam(value="mediaPackageElementID") String mediaPackageElementID, @PathParam(value="version") String version, @PathParam(value="filename") String fileName, @HeaderParam(value="If-None-Match") String ifNoneMatch) {
        try {
            Optional v = this.getAssetManager().toVersion(version);
            if (v.isPresent()) {
                Optional assetOpt = this.getAssetManager().getAsset((Version)v.get(), mediaPackageID, mediaPackageElementID);
                if (assetOpt.isPresent()) {
                    Asset asset = (Asset)assetOpt.get();
                    if (StringUtils.isNotBlank((CharSequence)ifNoneMatch)) {
                        Checksum checksum = asset.getChecksum();
                        if (checksum != null && checksum.getType().equals((Object)ChecksumType.DEFAULT_TYPE)) {
                            String md5 = checksum.getValue();
                            if (md5.equals(ifNoneMatch)) {
                                return Response.notModified((String)md5).build();
                            }
                        } else {
                            logger.warn("Checksum of asset {} of media package {} is of incorrect type or missing", (Object)mediaPackageElementID, (Object)mediaPackageID);
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)fileName)) {
                        MimeType mimetype;
                        String suffix = "unknown";
                        if (asset.getMimeType().isPresent() && (mimetype = (MimeType)asset.getMimeType().get()).getSuffix().isSome()) {
                            suffix = (String)mimetype.getSuffix().get();
                        }
                        fileName = mediaPackageElementID.concat(".").concat(suffix);
                    }
                    Option length = asset.getSize() > 0L ? Option.some((Object)asset.getSize()) : Option.none();
                    return RestUtil.R.ok((InputStream)asset.getInputStream(), (Option)(asset.getMimeType().isPresent() ? Option.some((Object)((MimeType)asset.getMimeType().get()).toString()) : Option.none()), (Option)length, (Option)Option.some((Object)fileName));
                }
                return RestUtil.R.notFound();
            }
            return RestUtil.R.badRequest((String)"malformed version");
        }
        catch (Exception e) {
            return AbstractAssetManagerRestEndpoint.handleException(e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{mediaPackageID}/properties.json")
    @RestQuery(name="getProperties", description="Get stored properties for an episode.", returnDescription="Properties as JSON", pathParameters={@RestParameter(name="mediaPackageID", description="the media package ID", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="namespace", description="property namespace", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Media package returned"), @RestResponse(responseCode=404, description="Not found"), @RestResponse(responseCode=403, description="Not allowed to read media package."), @RestResponse(responseCode=500, description="There has been an internal error.")})
    public Response getProperties(@PathParam(value="mediaPackageID") String mediaPackageId, @FormParam(value="namespace") String namespace) {
        try {
            AQueryBuilder queryBuilder = this.getAssetManager().createQuery();
            ASelectQuery query = StringUtils.isEmpty((CharSequence)namespace) ? queryBuilder.select(new Target[]{queryBuilder.properties(new PropertyName[0])}) : queryBuilder.select(new Target[]{queryBuilder.propertiesOf(new String[]{namespace})});
            query = query.where(queryBuilder.mediaPackageId(mediaPackageId).and(queryBuilder.version().isLatest()));
            AResult result = query.run();
            if (result.getSize() < 1L) {
                return RestUtil.R.notFound();
            }
            if (result.getSize() > 1L) {
                return RestUtil.R.serverError();
            }
            HashMap properties = new HashMap();
            if (result.getRecords().stream().findFirst().isPresent()) {
                for (Property property : ((ARecord)result.getRecords().stream().findFirst().get()).getProperties()) {
                    String key = property.getId().getNamespace() + "." + property.getId().getName();
                    HashMap<String, String> val = new HashMap<String, String>();
                    val.put("type", property.getValue().getType().getClass().getSimpleName());
                    val.put("value", property.getValue().get().toString());
                    properties.put((CallSite)((Object)key), val);
                }
            }
            return RestUtil.R.ok((Object)this.gson.toJson(properties));
        }
        catch (Exception e) {
            return AbstractAssetManagerRestEndpoint.handleException(e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{mediaPackageID}/workflowProperties.json")
    @RestQuery(name="getWorkflowProperties", description="Get stored workflow properties for an episode.", returnDescription="Properties as JSON", pathParameters={@RestParameter(name="mediaPackageID", description="the media package ID", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Media package returned"), @RestResponse(responseCode=200, description="Invalid parameters"), @RestResponse(responseCode=404, description="Not found"), @RestResponse(responseCode=403, description="Not allowed to read media package."), @RestResponse(responseCode=500, description="There has been an internal error.")})
    public Response getWorkflowProperties(@PathParam(value="mediaPackageID") String mediaPackageId) {
        try {
            AQueryBuilder queryBuilder = this.getAssetManager().createQuery();
            AResult result = queryBuilder.select(new Target[]{queryBuilder.propertiesOf(new String[]{"org.opencastproject.workflow.configuration"})}).where(queryBuilder.mediaPackageId(mediaPackageId).and(queryBuilder.version().isLatest())).run();
            if (result.getSize() < 1L) {
                return RestUtil.R.notFound();
            }
            if (result.getSize() > 1L) {
                return RestUtil.R.serverError();
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            if (result.getRecords().stream().findFirst().isPresent()) {
                for (Property property : ((ARecord)result.getRecords().stream().findFirst().get()).getProperties()) {
                    properties.put(property.getId().getName(), (String)property.getValue().get((Value.ValueType)Value.STRING));
                }
            }
            return RestUtil.R.ok((Object)this.gson.toJson(properties));
        }
        catch (Exception e) {
            return AbstractAssetManagerRestEndpoint.handleException(e);
        }
    }

    @POST
    @Path(value="{mediaPackageID}/workflowProperties")
    @RestQuery(name="setWorkflowProperties", description="Set additional workflow properties", pathParameters={@RestParameter(name="mediaPackageID", description="the media package ID", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="properties", isRequired=true, type=RestParameter.Type.STRING, description="JSON object containing new properties")}, responses={@RestResponse(description="Properties successfully set", responseCode=201), @RestResponse(description="Invalid data", responseCode=400), @RestResponse(description="Internal error", responseCode=500)}, returnDescription="Returned status code indicates success")
    public Response setWorkflowProperties(@PathParam(value="mediaPackageID") String mediaPackageId, @FormParam(value="properties") String propertiesJSON) {
        Map properties;
        try {
            properties = (Map)this.gson.fromJson(propertiesJSON, this.stringMapType);
        }
        catch (Exception e) {
            return RestUtil.R.badRequest();
        }
        for (Map.Entry entry : properties.entrySet()) {
            PropertyId propertyId = PropertyId.mk((String)mediaPackageId, (String)"org.opencastproject.workflow.configuration", (String)((String)entry.getKey()));
            Property property = Property.mk((PropertyId)propertyId, (Value)Value.mk((String)((String)entry.getValue())));
            if (this.getAssetManager().setProperty(property)) continue;
            return RestUtil.R.notFound();
        }
        return RestUtil.R.noContent();
    }

    public static Response handleException(Exception e) {
        logger.debug("Error calling REST method", (Throwable)e);
        Throwable cause = e;
        if (e.getCause() != null) {
            cause = e.getCause();
        }
        if (cause instanceof UnauthorizedException) {
            return RestUtil.R.forbidden();
        }
        throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
    }
}

