/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adopter.statistic;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.opencastproject.adopter.registration.Form;
import org.opencastproject.adopter.registration.Service;
import org.opencastproject.adopter.statistic.Sender;
import org.opencastproject.adopter.statistic.dto.GeneralData;
import org.opencastproject.adopter.statistic.dto.Host;
import org.opencastproject.adopter.statistic.dto.StatisticData;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.capture.admin.api.CaptureAgentStateService;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.search.api.SearchResultList;
import org.opencastproject.search.api.SearchService;
import org.opencastproject.security.api.DefaultOrganization;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserProvider;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.serviceregistry.api.HostRegistration;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.userdirectory.JpaUserAndRoleProvider;
import org.opencastproject.userdirectory.JpaUserReferenceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ScheduledDataCollector.class}, property={"service.description=Adopter Statistics Scheduler"})
public class ScheduledDataCollector
extends TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(ScheduledDataCollector.class);
    private static final String PROP_KEY_STATISTIC_SERVER_ADDRESS = "org.opencastproject.adopter.registration.server.url";
    private static final String DEFAULT_STATISTIC_SERVER_ADDRESS = "https://register.opencast.org";
    private static final int ONE_DAY_IN_MILLISECONDS = 86400000;
    private static final int SEARCH_ITERATION_SIZE = 100;
    private Service adopterFormService;
    private ServiceRegistry serviceRegistry;
    private CaptureAgentStateService caStateService;
    private OrganizationDirectoryService organizationDirectoryService;
    private AssetManager assetManager;
    private SeriesService seriesService;
    private SearchService searchService;
    protected UserProvider userRefProvider;
    protected JpaUserAndRoleProvider userProvider;
    protected SecurityService securityService;
    private Sender sender;
    private Organization defaultOrganization;
    private User systemAdminUser;
    private String version;
    private Timer timer;

    @Activate
    public void activate(BundleContext ctx) {
        logger.info("Activating adopter statistic scheduler.");
        this.defaultOrganization = new DefaultOrganization();
        String systemAdminUserName = ctx.getProperty("org.opencastproject.security.digest.user");
        this.systemAdminUser = SecurityUtil.createSystemUser((String)systemAdminUserName, (Organization)this.defaultOrganization);
        Version ctxVersion = ctx.getBundle().getVersion();
        this.version = ctxVersion.toString();
        String serverBaseUrl = ctx.getProperty(PROP_KEY_STATISTIC_SERVER_ADDRESS);
        if (serverBaseUrl != null) {
            logger.error("\nAdopter registration information are sent to a server other than register.opencast.org.\nWe cannot take any responsibility for what is done with the data.");
        }
        this.sender = new Sender(Objects.toString(serverBaseUrl, DEFAULT_STATISTIC_SERVER_ADDRESS));
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this, 0L, 86400000L);
    }

    @Deactivate
    public void deactivate() {
        this.timer.cancel();
    }

    @Override
    public void run() {
        Form adopter;
        logger.info("Executing adopter statistic scheduler task.");
        try {
            adopter = (Form)this.adopterFormService.retrieveFormData();
        }
        catch (Exception e) {
            logger.error("Couldn't retrieve adopter form data.", (Throwable)e);
            return;
        }
        if (adopter.shouldDelete()) {
            Form f = new Form();
            f.setAdopterKey(adopter.getAdopterKey());
            GeneralData gd = new GeneralData(f);
            gd.setAdopterKey(adopter.getAdopterKey());
            StatisticData sd = new StatisticData(adopter.getStatisticKey());
            try {
                this.sender.deleteStatistics(sd.jsonify());
                this.sender.deleteGeneralData(gd.jsonify());
                this.adopterFormService.deleteRegistration();
            }
            catch (IOException e) {
                logger.warn("Error occurred while deleting registration data, will retry", (Throwable)e);
            }
            return;
        }
        if (adopter.isRegistered() && adopter.getTermsVersionAgreed() == Form.TERMSOFUSEVERSION.APRIL_2022) {
            try {
                String generalDataAsJson = this.collectGeneralData(adopter);
                this.sender.sendGeneralData(generalDataAsJson);
                this.adopterFormService.saveFormData(adopter);
            }
            catch (Exception e) {
                logger.error("Error occurred while processing adopter general data.", (Throwable)e);
            }
            if (adopter.allowsStatistics()) {
                try {
                    String statisticDataAsJson = this.collectStatisticData(adopter.getAdopterKey(), adopter.getStatisticKey());
                    this.sender.sendStatistics(statisticDataAsJson);
                    this.adopterFormService.saveFormData(adopter);
                }
                catch (Exception e) {
                    logger.error("Error occurred while processing adopter statistic data.", (Throwable)e);
                }
            }
        }
    }

    public String getRegistrationDataAsString() throws Exception {
        Form adopter = (Form)this.adopterFormService.retrieveFormData();
        String generalJson = this.collectGeneralData(adopter);
        String statsJson = this.collectStatisticData(adopter.getAdopterKey(), adopter.getStatisticKey());
        return "{ \"general\":" + generalJson + ", \"statistics\":" + statsJson + "}";
    }

    private String collectGeneralData(Form adopterRegistrationForm) {
        GeneralData generalData = new GeneralData(adopterRegistrationForm);
        return generalData.jsonify();
    }

    private String collectStatisticData(String adopterKey, String statisticKey) throws Exception {
        StatisticData statisticData = new StatisticData(statisticKey);
        statisticData.setAdopterKey(adopterKey);
        this.serviceRegistry.getHostRegistrations().forEach(host -> {
            Host h = new Host((HostRegistration)host);
            try {
                String services = this.serviceRegistry.getServiceRegistrationsByHost(host.getBaseUrl()).stream().map(sr -> sr.getServiceType()).collect(Collectors.joining(",\n"));
                h.setServices(services);
            }
            catch (ServiceRegistryException e) {
                logger.warn("Error gathering services for {}", (Object)host.getBaseUrl(), (Object)e);
            }
            statisticData.addHost(h);
        });
        statisticData.setJobCount(this.serviceRegistry.count(null, null));
        statisticData.setSeriesCount(this.seriesService.getSeriesCount());
        List orgs = this.organizationDirectoryService.getOrganizations();
        statisticData.setTenantCount(orgs.size());
        for (Organization org : orgs) {
            SecurityUtil.runAs((SecurityService)this.securityService, (Organization)org, (User)this.systemAdminUser, () -> {
                statisticData.setEventCount(statisticData.getEventCount() + this.assetManager.countEvents(org.getId()));
                long current = statisticData.getCACount();
                int orgCAs = this.caStateService.getKnownAgents().size();
                statisticData.setCACount(current + (long)orgCAs);
                SearchSourceBuilder q = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"type", (Object)SearchService.IndexEntryType.Episode)).must((QueryBuilder)QueryBuilders.termQuery((String)"org", (String)org.getId())).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"deleted")));
                SearchResultList results = this.searchService.search(q);
                long orgMilis = results.getHits().stream().map(result -> EncodingSchemeUtils.decodeDuration((String)result.getDublinCore().getFirst(DublinCore.PROPERTY_EXTENT))).filter(Objects::nonNull).reduce(Long::sum).orElse(0L);
                statisticData.setTotalMinutes(statisticData.getTotalMinutes() + orgMilis / 1000L / 60L);
                long currentUsers = statisticData.getUserCount();
                statisticData.setUserCount(currentUsers + this.userProvider.countUsers() + this.userRefProvider.countUsers());
            });
        }
        statisticData.setVersion(this.version);
        return statisticData.jsonify();
    }

    @Reference
    public void setAdopterFormService(Service adopterFormService) {
        this.adopterFormService = adopterFormService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setCaptureAdminService(CaptureAgentStateService stateService) {
        this.caStateService = stateService;
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Reference
    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Reference
    public void setUserRefProvider(JpaUserReferenceProvider userRefProvider) {
        this.userRefProvider = userRefProvider;
    }

    @Reference
    public void setUserAndRoleProvider(JpaUserAndRoleProvider userProvider) {
        this.userProvider = userProvider;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService orgDirServ) {
        this.organizationDirectoryService = orgDirServ;
    }
}

