/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adopter.registration;

import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.opencastproject.adopter.registration.Form;
import org.opencastproject.adopter.registration.FormRepository;
import org.opencastproject.adopter.registration.FormRepositoryException;
import org.opencastproject.adopter.registration.IForm;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.db.Queries;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={FormRepository.class}, property={"service.description=Repository for the statistics registration form"})
public class FormRepositoryImpl
implements FormRepository {
    private static final Logger logger = LoggerFactory.getLogger(FormRepository.class);
    protected EntityManagerFactory emf = null;
    protected DBSessionFactory dbSessionFactory;
    protected DBSession db;

    @Reference(target="(osgi.unit.name=org.opencastproject.adopter)")
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Activate
    public void activate() {
        this.db = this.dbSessionFactory.createSession(this.emf);
    }

    @Deactivate
    public void deactivate() {
        this.db.close();
    }

    @Override
    public void save(IForm f) throws FormRepositoryException {
        Form form = (Form)f;
        try {
            this.db.execTx(em -> {
                Optional<Form> dbForm = this.getFormQuery().apply((EntityManager)em);
                if (dbForm.isEmpty()) {
                    form.setAdopterKey(UUID.randomUUID().toString());
                    form.setStatisticKey(UUID.randomUUID().toString());
                    form.setDateCreated(new Date());
                    form.setDateModified(new Date());
                    em.persist((Object)form);
                } else {
                    dbForm.get().merge(form);
                    em.merge((Object)dbForm.get());
                }
            });
        }
        catch (Exception e) {
            logger.error("Couldn't update the adopter statistics registration form: {}", (Object)e.getMessage());
            throw new FormRepositoryException(e);
        }
    }

    @Override
    public void delete() {
        try {
            this.db.execTx(Queries.namedQuery.delete("Form.deleteAll", new Object[0]));
        }
        catch (Exception e) {
            logger.error("Error occurred while deleting the adopter registration table. {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public IForm getForm() throws FormRepositoryException {
        return ((Optional)this.db.exec(this.getFormQuery())).orElse(null);
    }

    private Function<EntityManager, Optional<Form>> getFormQuery() {
        return Queries.namedQuery.findOpt("Form.findAll", Form.class, new Object[0]);
    }
}

