/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adopter.registration;

import com.google.gson.Gson;
import java.util.Calendar;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opencastproject.adopter.registration.Form;
import org.opencastproject.adopter.registration.Service;
import org.opencastproject.adopter.statistic.ScheduledDataCollector;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="registrationController", title="Adopter Statistics Registration Service Endpoint", abstractText="Rest Endpoint for the registration form.", notes={"Provides operations regarding the adopter registration form"})
@Component(immediate=true, service={Controller.class}, property={"service.description=Adopter Statistics REST Endpoint", "opencast.service.type=org.opencastproject.adopter.registration.Controller", "opencast.service.path=/admin-ng/adopter", "opencast.service.jobproducer=false"})
public class Controller {
    private static final Logger logger = LoggerFactory.getLogger(Controller.class);
    private static final Gson gson = new Gson();
    protected String docs;
    protected Service registrationService;
    protected ScheduledDataCollector dataCollector;

    @Reference
    public void setRegistrationService(Service registrationService) {
        this.registrationService = registrationService;
    }

    @Reference
    public void setDataCollector(ScheduledDataCollector collector) {
        this.dataCollector = collector;
    }

    @GET
    @Path(value="registration")
    @Produces(value={"application/json"})
    @RestQuery(name="getregistrationform", description="GETs the adopter registration data.", responses={@RestResponse(description="Retrieved registration data.", responseCode=200), @RestResponse(description="Error while retrieving adopter registration data.", responseCode=500)}, returnDescription="GETs the adopter registration data.")
    public String getRegistrationForm() {
        logger.debug("Retrieving adopter registration data.");
        return gson.toJson((Object)this.registrationService.retrieveFormData());
    }

    @GET
    @Path(value="summary")
    @Produces(value={"application/json"})
    @RestQuery(name="getsummary", description="GETs the adopter registration statistics data.", responses={@RestResponse(description="Retrieved statistic data.", responseCode=200), @RestResponse(description="Error while retrieving adopter statistic data.", responseCode=500)}, returnDescription="GETs the adopter registration statistics data.")
    public Response getAdopterStatistics() {
        logger.debug("Retrieving adopter registration statistics data.");
        try {
            return Response.ok((Object)this.dataCollector.getRegistrationDataAsString()).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="registration")
    @RestQuery(name="saveregistrationform", description="Saves the adopter registration data.", returnDescription="Status", restParameters={@RestParameter(description="The Name of the organisation.", isRequired=false, name="organisationName", type=RestParameter.Type.STRING), @RestParameter(description="The Name of the department.", isRequired=false, name="departmentName", type=RestParameter.Type.STRING), @RestParameter(description="The First name.", isRequired=false, name="firstName", type=RestParameter.Type.STRING), @RestParameter(description="The Last name.", isRequired=false, name="lastName", type=RestParameter.Type.STRING), @RestParameter(description="The e-mail address.", isRequired=false, name="email", type=RestParameter.Type.STRING), @RestParameter(description="The country.", isRequired=false, name="country", type=RestParameter.Type.STRING), @RestParameter(description="The postal code.", isRequired=false, name="postalCode", type=RestParameter.Type.STRING), @RestParameter(description="The city.", isRequired=false, name="city", type=RestParameter.Type.STRING), @RestParameter(description="The street.", isRequired=false, name="street", type=RestParameter.Type.STRING), @RestParameter(description="The street number.", isRequired=false, name="streetNo", type=RestParameter.Type.STRING), @RestParameter(description="Does the adopter allows to be contacted.", isRequired=false, name="contactMe", type=RestParameter.Type.BOOLEAN), @RestParameter(description="Does the adopter agreed to the policy.", isRequired=false, name="agreedToPolicy", type=RestParameter.Type.BOOLEAN), @RestParameter(description="Does the adopter allow the gathering of error reports.", isRequired=false, name="allowsErrorReports", type=RestParameter.Type.BOOLEAN), @RestParameter(description="Which type of system is this.", isRequired=false, name="systemType", type=RestParameter.Type.STRING), @RestParameter(description="Does the adopter allow the gathering of statistic data.", isRequired=false, name="allowsStatistics", type=RestParameter.Type.BOOLEAN), @RestParameter(description="Is the adopter already registered.", isRequired=false, name="registered", type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(responseCode=200, description="Adopter registration data saved."), @RestResponse(responseCode=400, description="Couldn't save adopter registration data.")})
    public Response register(@FormParam(value="organisationName") String organisationName, @FormParam(value="departmentName") String departmentName, @FormParam(value="firstName") String firstName, @FormParam(value="lastName") String lastName, @FormParam(value="email") String email, @FormParam(value="country") String country, @FormParam(value="postalCode") String postalCode, @FormParam(value="city") String city, @FormParam(value="street") String street, @FormParam(value="streetNo") String streetNo, @FormParam(value="contactMe") boolean contactMe, @FormParam(value="agreedToPolicy") boolean agreedToPolicy, @FormParam(value="systemType") String systemType, @FormParam(value="allowsErrorReports") boolean allowsErrorReports, @FormParam(value="allowsStatistics") boolean allowsStatistics, @FormParam(value="registered") boolean registered) {
        logger.debug("Saving adopter registration data.");
        Form form = new Form(organisationName, departmentName, firstName, lastName, email, country, postalCode, city, street, streetNo, contactMe, systemType, allowsStatistics, allowsErrorReports, agreedToPolicy, registered);
        try {
            this.registrationService.saveFormData(form);
        }
        catch (Exception e) {
            logger.error("Error while saving adopter registration data.", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="registration/finalize")
    @RestQuery(name="finalizeRegistration", description="Finalizes the registration and starts sending data.", returnDescription="Status", restParameters={}, responses={@RestResponse(responseCode=200, description="Registration finalized.")})
    public Response register() {
        logger.debug("Finalizing adopter registration.");
        Form form = (Form)this.registrationService.retrieveFormData();
        form.setRegistered(true);
        try {
            this.registrationService.saveFormData(form);
        }
        catch (Exception e) {
            logger.error("Error while saving adopter registration data.", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="isUpToDate")
    @RestQuery(name="isUpToDate", description="Returns true if Opencast has been able to register", responses={@RestResponse(description="Registratino status", responseCode=200)}, returnDescription="true if registration has been updated in the last week, false otherwise")
    public Response isUpToDate() {
        Form data = (Form)this.registrationService.retrieveFormData();
        Calendar cal = Calendar.getInstance();
        cal.add(5, -7);
        if (data != null && data.getDateModified() != null && data.getDateModified().after(cal.getTime())) {
            return Response.ok((Object)"true").build();
        }
        return Response.ok((Object)"false").build();
    }

    @DELETE
    @Path(value="registration")
    @RestQuery(name="deleteregistrationform", description="Deletes the adopter registration data", responses={@RestResponse(description="Successful deleted form data.", responseCode=200), @RestResponse(description="Error while deleting adopter registration data.", responseCode=500)}, returnDescription="DELETEs the adopter registration data.")
    public Response deleteRegistrationData() {
        logger.debug("Deleting adopter registration data.");
        try {
            this.registrationService.markForDeletion();
            return RestUtil.R.ok();
        }
        catch (Exception e) {
            logger.error("Error while deleting adopter registration data.", (Throwable)e);
            return RestUtil.R.serverError();
        }
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="latestToU")
    @RestQuery(name="getLatestTermsOfUse", description="Gets the latest terms of use version.", responses={@RestResponse(description="Retrieved statistic data.", responseCode=200)}, returnDescription="The latest terms of use version.")
    public String getLatestTermsofUse() {
        return Form.getLatestTermsOfUse().name();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="docs")
    public String getDocs() {
        return this.docs;
    }
}

