/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adopter.registration;

import org.opencastproject.adopter.registration.Form;
import org.opencastproject.adopter.registration.FormRepository;
import org.opencastproject.adopter.registration.IForm;
import org.opencastproject.adopter.registration.Service;
import org.opencastproject.security.api.SecurityService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Service.class}, property={"service.description=Adopter Statistics Registration Service"})
public class AdopterRegistrationServiceImpl
implements Service {
    private SecurityService securityService;
    private FormRepository formRepository;

    @Override
    public void saveFormData(IForm form) {
        this.formRepository.save(form);
    }

    @Override
    public Form retrieveFormData() {
        Form registrationForm = (Form)this.formRepository.getForm();
        if (registrationForm == null) {
            return new Form();
        }
        return registrationForm;
    }

    @Override
    public void markForDeletion() {
        Form form = (Form)this.formRepository.getForm();
        form.delete();
        this.formRepository.save(form);
    }

    @Override
    public void deleteRegistration() {
        this.formRepository.delete();
    }

    @Reference
    protected void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    protected void setFormRepository(FormRepository formRepository) {
        this.formRepository = formRepository;
    }
}

