/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.usersettings.persistence;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.opencastproject.adminui.usersettings.UserSetting;
import org.opencastproject.util.RequireUtil;

@Entity(name="UserSettings")
@Table(name="oc_frontend_user_settings", indexes={@Index(name="IX_oc_frontend_user_settings_organization", columnList="organization")}, uniqueConstraints={@UniqueConstraint(columnNames={"setting_key", "username", "organization"})})
@NamedQueries(value={@NamedQuery(name="UserSettings.countByUserName", query="SELECT COUNT(us) FROM UserSettings us WHERE us.username = :username AND us.organization = :org"), @NamedQuery(name="UserSettings.findByIdAndUsernameAndOrg", query="SELECT us FROM UserSettings us WHERE us.id = :id AND us.username = :username AND us.organization = :org"), @NamedQuery(name="UserSettings.findByUserName", query="SELECT us FROM UserSettings us WHERE us.username = :username AND us.organization = :org"), @NamedQuery(name="UserSettings.findByKey", query="SELECT us FROM UserSettings us WHERE us.key = :key AND us.username = :username AND us.organization = :org"), @NamedQuery(name="UserSettings.clear", query="DELETE FROM UserSettings us WHERE us.organization = :org")})
public class UserSettingDto {
    @Id
    @GeneratedValue
    @Column(name="id", nullable=false)
    private long id;
    @Column(name="setting_key", nullable=false)
    private String key;
    @Lob
    @Column(name="setting_value", nullable=false)
    private String value;
    @Column(name="username", nullable=false, length=128)
    private String username;
    @Column(name="organization", nullable=false)
    private String organization;

    public UserSettingDto() {
    }

    public UserSettingDto(long id, String key, String value, String username, String organization) {
        this.id = id;
        this.key = RequireUtil.notEmpty((String)key, (String)"key");
        this.value = RequireUtil.notEmpty((String)value, (String)"value");
        this.username = username;
        this.organization = organization;
    }

    public UserSetting toUserSetting() {
        return new UserSetting(this.id, this.key, this.value);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }
}

