/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.userdirectory;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.SecurityService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Provides the Admin UI roles"}, immediate=true, service={RoleProvider.class})
public class UIRolesRoleProvider
implements RoleProvider {
    private static final Logger logger = LoggerFactory.getLogger(UIRolesRoleProvider.class);
    protected SecurityService securityService = null;
    private Set<String> roles;

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        try (InputStream in = this.getClass().getResourceAsStream("/roles.txt");){
            this.roles = new TreeSet<String>(IOUtils.readLines((InputStream)in, (String)"UTF-8"));
        }
        catch (IOException e) {
            logger.error("Unable to read available roles", (Throwable)e);
        }
        logger.info("Activated Admin UI roles role provider");
    }

    public List<Role> getRolesForUser(String userName) {
        return Collections.emptyList();
    }

    public String getOrganization() {
        return "*";
    }

    public Iterator<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        if (target == Role.Target.ACL) {
            return Collections.emptyIterator();
        }
        JaxbOrganization organization = JaxbOrganization.fromOrganization((Organization)this.securityService.getOrganization());
        return this.roles.stream().filter(role -> UIRolesRoleProvider.like(role, query)).skip(offset).limit(limit > 0 ? (long)limit : (long)this.roles.size()).map(role -> this.toRole((String)role, organization)).iterator();
    }

    private static boolean like(String string, String query) {
        if (string == null) {
            return false;
        }
        String regex = query.replace("_", ".").replace("%", ".*?");
        Pattern p = Pattern.compile(regex, 34);
        return p.matcher(string).matches();
    }

    private Role toRole(String role, JaxbOrganization organization) {
        return new JaxbRole(role, organization, "AdminNG UI Role", Role.Type.INTERNAL);
    }
}

