/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JObject;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.api.SearchResultItem;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.elasticsearch.index.objects.series.SeriesSearchQuery;
import org.opencastproject.elasticsearch.index.objects.theme.IndexTheme;
import org.opencastproject.elasticsearch.index.objects.theme.ThemeSearchQuery;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.staticfiles.api.StaticFileService;
import org.opencastproject.staticfiles.endpoint.StaticFileRestService;
import org.opencastproject.themes.Theme;
import org.opencastproject.themes.ThemesServiceDatabase;
import org.opencastproject.themes.persistence.ThemesServiceDatabaseException;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.EqualsUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.util.requests.SortCriterion;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin-ng/themes")
@RestService(name="themes", title="Themes facade service", abstractText="Provides operations for the themes", notes={"This service offers the default themes CRUD Operations for the admin UI.", "<strong>Important:</strong> <em>This service is for exclusive use by the module admin-ui. Its API might change anytime without prior notice. Any dependencies other than the admin UI will be strictly ignored. DO NOT use this for integration of third-party applications.<em>"})
@Component(immediate=true, service={ThemesEndpoint.class}, property={"service.description=Admin UI - Themes Endpoint", "opencast.service.type=org.opencastproject.adminui.ThemesEndpoint", "opencast.service.path=/admin-ng/themes"})
@JaxrsResource
public class ThemesEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(ThemesEndpoint.class);
    private ThemesServiceDatabase themesServiceDatabase;
    private SecurityService securityService;
    private ElasticsearchIndex searchIndex;
    private SeriesService seriesService;
    private StaticFileService staticFileService;
    private StaticFileRestService staticFileRestService;

    @Reference
    public void setThemesServiceDatabase(ThemesServiceDatabase themesServiceDatabase) {
        this.themesServiceDatabase = themesServiceDatabase;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setIndex(ElasticsearchIndex index) {
        this.searchIndex = index;
    }

    @Reference
    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference
    public void setStaticFileService(StaticFileService staticFileService) {
        this.staticFileService = staticFileService;
    }

    @Reference
    public void setStaticFileRestService(StaticFileRestService staticFileRestService) {
        this.staticFileRestService = staticFileRestService;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        logger.info("Activate themes endpoint");
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="themes.json")
    @RestQuery(name="getThemes", description="Return all of the known themes on the system", restParameters={@RestParameter(name="filter", isRequired=false, description="The filter used for the query. They should be formated like that: 'filter1:value1,filter2:value2'", type=RestParameter.Type.STRING), @RestParameter(defaultValue="0", description="The maximum number of items to return per page.", isRequired=false, name="limit", type=RestParameter.Type.INTEGER), @RestParameter(defaultValue="0", description="The page number.", isRequired=false, name="offset", type=RestParameter.Type.INTEGER), @RestParameter(name="sort", isRequired=false, description="The sort order. May include any of the following: NAME, CREATOR.  Add '_DESC' to reverse the sort order (e.g. CREATOR_DESC).", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="A JSON representation of the themes", responseCode=200)}, returnDescription="")
    public Response getThemes(@QueryParam(value="filter") String filter, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset, @QueryParam(value="sort") String sort) {
        Option optLimit = Option.option((Object)limit);
        Option optOffset = Option.option((Object)offset);
        Option optSort = Option.option((Object)StringUtils.trimToNull((String)sort));
        ThemeSearchQuery query = new ThemeSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser());
        if (optLimit.isSome() && limit == 0) {
            optLimit = Option.none();
        }
        if (optLimit.isSome()) {
            query.withLimit(((Integer)optLimit.get()).intValue());
        }
        if (optOffset.isSome()) {
            query.withOffset(offset);
        }
        Map filters = RestUtils.parseFilter((String)filter);
        for (Object name : filters.keySet()) {
            if ("Creator".equals(name)) {
                query.withCreator((String)filters.get(name));
            }
            if (!"textFilter".equals(name)) continue;
            query.withText((String)filters.get(name));
        }
        if (optSort.isSome()) {
            ArrayList sortCriteria = RestUtils.parseSortQueryParameter((String)((String)optSort.get()));
            block17: for (SortCriterion criterion : sortCriteria) {
                switch (criterion.getFieldName()) {
                    case "name": {
                        query.sortByName(criterion.getOrder());
                        continue block17;
                    }
                    case "description": {
                        query.sortByDescription(criterion.getOrder());
                        continue block17;
                    }
                    case "creator": {
                        query.sortByCreator(criterion.getOrder());
                        continue block17;
                    }
                    case "default": {
                        query.sortByDefault(criterion.getOrder());
                        continue block17;
                    }
                    case "creation_date": {
                        query.sortByCreatedDateTime(criterion.getOrder());
                        continue block17;
                    }
                }
                logger.info("Unknown sort criteria {}", (Object)criterion.getFieldName());
                return Response.status((int)400).build();
            }
        }
        logger.trace("Using Query: " + query.toString());
        SearchResult results = null;
        try {
            results = this.searchIndex.getByQuery(query);
        }
        catch (SearchIndexException e) {
            logger.error("The admin UI Search Index was not able to get the themes list:", (Throwable)e);
            return RestUtil.R.serverError();
        }
        ArrayList<JValue> themesJSON = new ArrayList<JValue>();
        if (results.getPageSize() == 0L) {
            logger.debug("No themes match the given filters.");
            return RestUtils.okJsonList(themesJSON, (int)((Integer)Opt.nul((Object)offset).getOr((Object)0)), (int)((Integer)Opt.nul((Object)limit).getOr((Object)0)), (long)0L);
        }
        for (SearchResultItem item : results.getItems()) {
            IndexTheme theme = (IndexTheme)item.getSource();
            themesJSON.add(this.themeToJSON(theme, false));
        }
        return RestUtils.okJsonList(themesJSON, (int)((Integer)Opt.nul((Object)offset).getOr((Object)0)), (int)((Integer)Opt.nul((Object)limit).getOr((Object)0)), (long)results.getHitCount());
    }

    @GET
    @Path(value="{themeId}.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getTheme", description="Returns the theme by the given id as JSON", returnDescription="The theme as JSON", pathParameters={@RestParameter(name="themeId", description="The theme id", isRequired=true, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(description="Returns the theme as JSON", responseCode=200), @RestResponse(description="No theme with this identifier was found.", responseCode=404)})
    public Response getThemeResponse(@PathParam(value="themeId") long id) throws Exception {
        Opt<IndexTheme> theme = this.getTheme(id);
        if (theme.isNone()) {
            return RestUtils.notFound((String)"Cannot find a theme with id '%s'", (Object[])new Object[]{id});
        }
        return RestUtils.okJson((JValue)this.themeToJSON((IndexTheme)theme.get(), true));
    }

    @GET
    @Path(value="{themeId}/usage.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getThemeUsage", description="Returns the theme usage by the given id as JSON", returnDescription="The theme usage as JSON", pathParameters={@RestParameter(name="themeId", description="The theme id", isRequired=true, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(description="Returns the theme usage as JSON", responseCode=200), @RestResponse(description="Theme with the given id does not exist", responseCode=404)})
    public Response getThemeUsage(@PathParam(value="themeId") long themeId) throws Exception {
        Opt<IndexTheme> theme = this.getTheme(themeId);
        if (theme.isNone()) {
            return RestUtils.notFound((String)"Cannot find a theme with id {}", (Object[])new Object[]{themeId});
        }
        SeriesSearchQuery query = new SeriesSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser()).withTheme(themeId);
        SearchResult results = null;
        try {
            results = this.searchIndex.getByQuery(query);
        }
        catch (SearchIndexException e) {
            logger.error("The admin UI Search Index was not able to get the series with theme '{}':", (Object)themeId, (Object)e);
            return RestUtil.R.serverError();
        }
        ArrayList<JObject> seriesValues = new ArrayList<JObject>();
        for (SearchResultItem item : results.getItems()) {
            Series series = (Series)item.getSource();
            seriesValues.add(Jsons.obj((Field[])new Field[]{Jsons.f((String)"id", (JValue)Jsons.v((String)series.getIdentifier())), Jsons.f((String)"title", (JValue)Jsons.v((String)series.getTitle()))}));
        }
        return RestUtils.okJson((JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"series", (JValue)Jsons.arr(seriesValues))}));
    }

    @POST
    @Path(value="")
    @RestQuery(name="createTheme", description="Add a theme", returnDescription="Return the created theme", restParameters={@RestParameter(name="default", description="Whether the theme is default", isRequired=true, type=RestParameter.Type.BOOLEAN), @RestParameter(name="name", description="The theme name", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="description", description="The theme description", isRequired=false, type=RestParameter.Type.TEXT), @RestParameter(name="bumperActive", description="Whether the theme bumper is active", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="trailerActive", description="Whether the theme trailer is active", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="titleSlideActive", description="Whether the theme title slide is active", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="licenseSlideActive", description="Whether the theme license slide is active", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="watermarkActive", description="Whether the theme watermark is active", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="bumperFile", description="The theme bumper file", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="trailerFile", description="The theme trailer file", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="watermarkFile", description="The theme watermark file", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="titleSlideBackground", description="The theme title slide background file", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="licenseSlideBackground", description="The theme license slide background file", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="titleSlideMetadata", description="The theme title slide metadata", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="licenseSlideDescription", description="The theme license slide description", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="watermarkPosition", description="The theme watermark position", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Theme created"), @RestResponse(responseCode=400, description="The theme references a non-existing file")})
    public Response createTheme(@FormParam(value="default") boolean isDefault, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="bumperActive") Boolean bumperActive, @FormParam(value="trailerActive") Boolean trailerActive, @FormParam(value="titleSlideActive") Boolean titleSlideActive, @FormParam(value="licenseSlideActive") Boolean licenseSlideActive, @FormParam(value="watermarkActive") Boolean watermarkActive, @FormParam(value="bumperFile") String bumperFile, @FormParam(value="trailerFile") String trailerFile, @FormParam(value="watermarkFile") String watermarkFile, @FormParam(value="titleSlideBackground") String titleSlideBackground, @FormParam(value="licenseSlideBackground") String licenseSlideBackground, @FormParam(value="titleSlideMetadata") String titleSlideMetadata, @FormParam(value="licenseSlideDescription") String licenseSlideDescription, @FormParam(value="watermarkPosition") String watermarkPosition) {
        User creator = this.securityService.getUser();
        Theme theme = new Theme(Option.none(), new Date(), isDefault, creator, name, StringUtils.trimToNull((String)description), BooleanUtils.toBoolean((Boolean)bumperActive), StringUtils.trimToNull((String)bumperFile), BooleanUtils.toBoolean((Boolean)trailerActive), StringUtils.trimToNull((String)trailerFile), BooleanUtils.toBoolean((Boolean)titleSlideActive), StringUtils.trimToNull((String)titleSlideMetadata), StringUtils.trimToNull((String)titleSlideBackground), BooleanUtils.toBoolean((Boolean)licenseSlideActive), StringUtils.trimToNull((String)licenseSlideBackground), StringUtils.trimToNull((String)licenseSlideDescription), BooleanUtils.toBoolean((Boolean)watermarkActive), StringUtils.trimToNull((String)watermarkFile), StringUtils.trimToNull((String)watermarkPosition));
        try {
            this.persistReferencedFiles(theme);
        }
        catch (NotFoundException e) {
            logger.warn("A file that is referenced in theme '{}' was not found: {}", (Object)theme, (Object)e.getMessage());
            return RestUtil.R.badRequest((String)"Referenced non-existing file");
        }
        catch (IOException e) {
            logger.warn("Error while persisting file: {}", (Object)e.getMessage());
            return RestUtil.R.serverError();
        }
        try {
            Theme createdTheme = this.themesServiceDatabase.updateTheme(theme);
            return RestUtils.okJson((JValue)this.themeToJSON(createdTheme));
        }
        catch (ThemesServiceDatabaseException e) {
            logger.error("Unable to create a theme");
            return RestUtil.R.serverError();
        }
    }

    @PUT
    @Path(value="{themeId}")
    @RestQuery(name="updateTheme", description="Updates a theme", returnDescription="Return the updated theme", pathParameters={@RestParameter(name="themeId", description="The theme identifier", isRequired=true, type=RestParameter.Type.INTEGER)}, restParameters={@RestParameter(name="default", description="Whether the theme is default", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="name", description="The theme name", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="description", description="The theme description", isRequired=false, type=RestParameter.Type.TEXT), @RestParameter(name="bumperActive", description="Whether the theme bumper is active", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="trailerActive", description="Whether the theme trailer is active", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="titleSlideActive", description="Whether the theme title slide is active", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="licenseSlideActive", description="Whether the theme license slide is active", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="watermarkActive", description="Whether the theme watermark is active", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="bumperFile", description="The theme bumper file", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="trailerFile", description="The theme trailer file", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="watermarkFile", description="The theme watermark file", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="titleSlideBackground", description="The theme title slide background file", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="licenseSlideBackground", description="The theme license slide background file", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="titleSlideMetadata", description="The theme title slide metadata", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="licenseSlideDescription", description="The theme license slide description", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="watermarkPosition", description="The theme watermark position", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Theme updated"), @RestResponse(responseCode=404, description="If the theme has not been found.")})
    public Response updateTheme(@PathParam(value="themeId") long themeId, @FormParam(value="default") Boolean isDefault, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="bumperActive") Boolean bumperActive, @FormParam(value="trailerActive") Boolean trailerActive, @FormParam(value="titleSlideActive") Boolean titleSlideActive, @FormParam(value="licenseSlideActive") Boolean licenseSlideActive, @FormParam(value="watermarkActive") Boolean watermarkActive, @FormParam(value="bumperFile") String bumperFile, @FormParam(value="trailerFile") String trailerFile, @FormParam(value="watermarkFile") String watermarkFile, @FormParam(value="titleSlideBackground") String titleSlideBackground, @FormParam(value="licenseSlideBackground") String licenseSlideBackground, @FormParam(value="titleSlideMetadata") String titleSlideMetadata, @FormParam(value="licenseSlideDescription") String licenseSlideDescription, @FormParam(value="watermarkPosition") String watermarkPosition) throws NotFoundException {
        try {
            Theme origTheme = this.themesServiceDatabase.getTheme(themeId);
            if (isDefault == null) {
                isDefault = origTheme.isDefault();
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                name = origTheme.getName();
            }
            if (StringUtils.isEmpty((CharSequence)description)) {
                description = origTheme.getDescription();
            }
            if (bumperActive == null) {
                bumperActive = origTheme.isBumperActive();
            }
            if (StringUtils.isEmpty((CharSequence)bumperFile)) {
                bumperFile = origTheme.getBumperFile();
            }
            if (trailerActive == null) {
                trailerActive = origTheme.isTrailerActive();
            }
            if (StringUtils.isEmpty((CharSequence)trailerFile)) {
                trailerFile = origTheme.getTrailerFile();
            }
            if (titleSlideActive == null) {
                titleSlideActive = origTheme.isTitleSlideActive();
            }
            if (StringUtils.isEmpty((CharSequence)titleSlideMetadata)) {
                titleSlideMetadata = origTheme.getTitleSlideMetadata();
            }
            if (StringUtils.isEmpty((CharSequence)titleSlideBackground)) {
                titleSlideBackground = origTheme.getTitleSlideBackground();
            }
            if (licenseSlideActive == null) {
                licenseSlideActive = origTheme.isLicenseSlideActive();
            }
            if (StringUtils.isEmpty((CharSequence)licenseSlideBackground)) {
                licenseSlideBackground = origTheme.getLicenseSlideBackground();
            }
            if (StringUtils.isEmpty((CharSequence)licenseSlideDescription)) {
                licenseSlideDescription = origTheme.getLicenseSlideDescription();
            }
            if (watermarkActive == null) {
                watermarkActive = origTheme.isWatermarkActive();
            }
            if (StringUtils.isEmpty((CharSequence)watermarkFile)) {
                watermarkFile = origTheme.getWatermarkFile();
            }
            if (StringUtils.isEmpty((CharSequence)watermarkPosition)) {
                watermarkPosition = origTheme.getWatermarkPosition();
            }
            Theme theme = new Theme(origTheme.getId(), origTheme.getCreationDate(), isDefault.booleanValue(), origTheme.getCreator(), name, StringUtils.trimToNull((String)description), BooleanUtils.toBoolean((Boolean)bumperActive), StringUtils.trimToNull((String)bumperFile), BooleanUtils.toBoolean((Boolean)trailerActive), StringUtils.trimToNull((String)trailerFile), BooleanUtils.toBoolean((Boolean)titleSlideActive), StringUtils.trimToNull((String)titleSlideMetadata), StringUtils.trimToNull((String)titleSlideBackground), BooleanUtils.toBoolean((Boolean)licenseSlideActive), StringUtils.trimToNull((String)licenseSlideBackground), StringUtils.trimToNull((String)licenseSlideDescription), BooleanUtils.toBoolean((Boolean)watermarkActive), StringUtils.trimToNull((String)watermarkFile), StringUtils.trimToNull((String)watermarkPosition));
            try {
                this.updateReferencedFiles(origTheme, theme);
            }
            catch (IOException e) {
                logger.warn("Error while persisting file: {}", (Object)e.getMessage());
                return RestUtil.R.serverError();
            }
            catch (NotFoundException e) {
                logger.warn("A file that is referenced in theme '{}' was not found: {}", (Object)theme, (Object)e.getMessage());
                return RestUtil.R.badRequest((String)"Referenced non-existing file");
            }
            Theme updatedTheme = this.themesServiceDatabase.updateTheme(theme);
            return RestUtils.okJson((JValue)this.themeToJSON(updatedTheme));
        }
        catch (ThemesServiceDatabaseException e) {
            logger.error("Unable to update theme {}", (Object)themeId, (Object)e);
            return RestUtil.R.serverError();
        }
    }

    @DELETE
    @Path(value="{themeId}")
    @RestQuery(name="deleteTheme", description="Deletes a theme", returnDescription="The method doesn't return any content", pathParameters={@RestParameter(name="themeId", isRequired=true, description="The theme identifier", type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=404, description="If the theme has not been found."), @RestResponse(responseCode=204, description="The method does not return any content"), @RestResponse(responseCode=401, description="If the current user is not authorized to perform this action")})
    public Response deleteTheme(@PathParam(value="themeId") long themeId) throws NotFoundException, UnauthorizedException {
        try {
            Theme theme = this.themesServiceDatabase.getTheme(themeId);
            try {
                this.deleteReferencedFiles(theme);
            }
            catch (IOException e) {
                logger.warn("Error while deleting referenced file: {}", (Object)e.getMessage());
                return RestUtil.R.serverError();
            }
            this.themesServiceDatabase.deleteTheme(themeId);
            this.deleteThemeOnSeries(themeId);
            return RestUtil.R.noContent();
        }
        catch (NotFoundException e) {
            logger.warn("Unable to find a theme with id " + themeId);
            throw e;
        }
        catch (ThemesServiceDatabaseException e) {
            logger.error("Error getting theme {} during delete operation because:", (Object)themeId, (Object)e);
            return RestUtil.R.serverError();
        }
    }

    private void deleteThemeOnSeries(long themeId) throws UnauthorizedException {
        SeriesSearchQuery query = new SeriesSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser()).withTheme(themeId);
        SearchResult results = null;
        try {
            results = this.searchIndex.getByQuery(query);
        }
        catch (SearchIndexException e) {
            logger.error("The admin UI Search Index was not able to get the series with theme '{}':", (Object)themeId, (Object)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        for (SearchResultItem item : results.getItems()) {
            String seriesId = ((Series)item.getSource()).getIdentifier();
            try {
                this.seriesService.deleteSeriesProperty(seriesId, "theme");
            }
            catch (NotFoundException e) {
                logger.warn("Theme {} already deleted on series {}", (Object)themeId, (Object)seriesId);
            }
            catch (SeriesException e) {
                logger.error("Unable to remove theme from series {}", (Object)seriesId, (Object)e);
                throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
    }

    private Opt<IndexTheme> getTheme(long id) throws SearchIndexException {
        SearchResult result = this.searchIndex.getByQuery(new ThemeSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser()).withIdentifier(id));
        if (result.getPageSize() == 0L) {
            logger.debug("Didn't find theme with id {}", (Object)id);
            return Opt.none();
        }
        return Opt.some((Object)((IndexTheme)result.getItems()[0].getSource()));
    }

    private JValue themeToJSON(IndexTheme theme, boolean editResponse) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(Jsons.f((String)"id", (JValue)Jsons.v((Number)theme.getIdentifier())));
        fields.add(Jsons.f((String)"creationDate", (JValue)Jsons.v((String)DateTimeSupport.toUTC((long)theme.getCreationDate().getTime()))));
        fields.add(Jsons.f((String)"default", (JValue)Jsons.v((Boolean)theme.isDefault())));
        fields.add(Jsons.f((String)"name", (JValue)Jsons.v((String)theme.getName())));
        fields.add(Jsons.f((String)"creator", (JValue)Jsons.v((String)theme.getCreator())));
        fields.add(Jsons.f((String)"description", (JValue)Jsons.v((Object)theme.getDescription(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"bumperActive", (JValue)Jsons.v((Boolean)theme.isBumperActive())));
        fields.add(Jsons.f((String)"bumperFile", (JValue)Jsons.v((Object)theme.getBumperFile(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"trailerActive", (JValue)Jsons.v((Boolean)theme.isTrailerActive())));
        fields.add(Jsons.f((String)"trailerFile", (JValue)Jsons.v((Object)theme.getTrailerFile(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"titleSlideActive", (JValue)Jsons.v((Boolean)theme.isTitleSlideActive())));
        fields.add(Jsons.f((String)"titleSlideMetadata", (JValue)Jsons.v((Object)theme.getTitleSlideMetadata(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"titleSlideBackground", (JValue)Jsons.v((Object)theme.getTitleSlideBackground(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"licenseSlideActive", (JValue)Jsons.v((Boolean)theme.isLicenseSlideActive())));
        fields.add(Jsons.f((String)"licenseSlideDescription", (JValue)Jsons.v((Object)theme.getLicenseSlideDescription(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"licenseSlideBackground", (JValue)Jsons.v((Object)theme.getLicenseSlideBackground(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"watermarkActive", (JValue)Jsons.v((Boolean)theme.isWatermarkActive())));
        fields.add(Jsons.f((String)"watermarkFile", (JValue)Jsons.v((Object)theme.getWatermarkFile(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"watermarkPosition", (JValue)Jsons.v((Object)theme.getWatermarkPosition(), (JValue)Jsons.BLANK)));
        if (editResponse) {
            this.extendStaticFileInfo("bumperFile", theme.getBumperFile(), fields);
            this.extendStaticFileInfo("trailerFile", theme.getTrailerFile(), fields);
            this.extendStaticFileInfo("titleSlideBackground", theme.getTitleSlideBackground(), fields);
            this.extendStaticFileInfo("licenseSlideBackground", theme.getLicenseSlideBackground(), fields);
            this.extendStaticFileInfo("watermarkFile", theme.getWatermarkFile(), fields);
        }
        return Jsons.obj(fields);
    }

    private void extendStaticFileInfo(String fieldName, String staticFileId, List<Field> fields) {
        if (StringUtils.isNotBlank((CharSequence)staticFileId)) {
            try {
                fields.add(Jsons.f((String)fieldName.concat("Name"), (JValue)Jsons.v((String)this.staticFileService.getFileName(staticFileId))));
                fields.add(Jsons.f((String)fieldName.concat("Url"), (JValue)Jsons.v((Object)this.staticFileRestService.getStaticFileURL(staticFileId).toString(), (JValue)Jsons.BLANK)));
            }
            catch (IllegalStateException | NotFoundException e) {
                logger.error("Error retreiving static file '{}' ", (Object)staticFileId, (Object)e);
            }
        }
    }

    private JValue themeToJSON(Theme theme) {
        String creator = StringUtils.isNotBlank((CharSequence)theme.getCreator().getName()) ? theme.getCreator().getName() : theme.getCreator().getUsername();
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(Jsons.f((String)"id", (JValue)Jsons.v((Number)((Number)theme.getId().getOrElse((Object)-1L)))));
        fields.add(Jsons.f((String)"creationDate", (JValue)Jsons.v((String)DateTimeSupport.toUTC((long)theme.getCreationDate().getTime()))));
        fields.add(Jsons.f((String)"default", (JValue)Jsons.v((Boolean)theme.isDefault())));
        fields.add(Jsons.f((String)"name", (JValue)Jsons.v((String)theme.getName())));
        fields.add(Jsons.f((String)"creator", (JValue)Jsons.v((String)creator)));
        fields.add(Jsons.f((String)"description", (JValue)Jsons.v((Object)theme.getDescription(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"bumperActive", (JValue)Jsons.v((Boolean)theme.isBumperActive())));
        fields.add(Jsons.f((String)"bumperFile", (JValue)Jsons.v((Object)theme.getBumperFile(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"trailerActive", (JValue)Jsons.v((Boolean)theme.isTrailerActive())));
        fields.add(Jsons.f((String)"trailerFile", (JValue)Jsons.v((Object)theme.getTrailerFile(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"titleSlideActive", (JValue)Jsons.v((Boolean)theme.isTitleSlideActive())));
        fields.add(Jsons.f((String)"titleSlideMetadata", (JValue)Jsons.v((Object)theme.getTitleSlideMetadata(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"titleSlideBackground", (JValue)Jsons.v((Object)theme.getTitleSlideBackground(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"licenseSlideActive", (JValue)Jsons.v((Boolean)theme.isLicenseSlideActive())));
        fields.add(Jsons.f((String)"licenseSlideDescription", (JValue)Jsons.v((Object)theme.getLicenseSlideDescription(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"licenseSlideBackground", (JValue)Jsons.v((Object)theme.getLicenseSlideBackground(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"watermarkActive", (JValue)Jsons.v((Boolean)theme.isWatermarkActive())));
        fields.add(Jsons.f((String)"watermarkFile", (JValue)Jsons.v((Object)theme.getWatermarkFile(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"watermarkPosition", (JValue)Jsons.v((Object)theme.getWatermarkPosition(), (JValue)Jsons.BLANK)));
        return Jsons.obj(fields);
    }

    private void persistReferencedFiles(Theme theme) throws NotFoundException, IOException {
        if (StringUtils.isNotBlank((CharSequence)theme.getBumperFile())) {
            this.staticFileService.persistFile(theme.getBumperFile());
        }
        if (StringUtils.isNotBlank((CharSequence)theme.getLicenseSlideBackground())) {
            this.staticFileService.persistFile(theme.getLicenseSlideBackground());
        }
        if (StringUtils.isNotBlank((CharSequence)theme.getTitleSlideBackground())) {
            this.staticFileService.persistFile(theme.getTitleSlideBackground());
        }
        if (StringUtils.isNotBlank((CharSequence)theme.getTrailerFile())) {
            this.staticFileService.persistFile(theme.getTrailerFile());
        }
        if (StringUtils.isNotBlank((CharSequence)theme.getWatermarkFile())) {
            this.staticFileService.persistFile(theme.getWatermarkFile());
        }
    }

    private void deleteReferencedFiles(Theme theme) throws NotFoundException, IOException {
        if (StringUtils.isNotBlank((CharSequence)theme.getBumperFile())) {
            this.staticFileService.deleteFile(theme.getBumperFile());
        }
        if (StringUtils.isNotBlank((CharSequence)theme.getLicenseSlideBackground())) {
            this.staticFileService.deleteFile(theme.getLicenseSlideBackground());
        }
        if (StringUtils.isNotBlank((CharSequence)theme.getTitleSlideBackground())) {
            this.staticFileService.deleteFile(theme.getTitleSlideBackground());
        }
        if (StringUtils.isNotBlank((CharSequence)theme.getTrailerFile())) {
            this.staticFileService.deleteFile(theme.getTrailerFile());
        }
        if (StringUtils.isNotBlank((CharSequence)theme.getWatermarkFile())) {
            this.staticFileService.deleteFile(theme.getWatermarkFile());
        }
    }

    private void updateReferencedFiles(Theme original, Theme updated) throws NotFoundException, IOException {
        this.updateReferencedFile(original.getBumperFile(), updated.getBumperFile());
        this.updateReferencedFile(original.getLicenseSlideBackground(), updated.getLicenseSlideBackground());
        this.updateReferencedFile(original.getTitleSlideBackground(), updated.getTitleSlideBackground());
        this.updateReferencedFile(original.getTrailerFile(), updated.getTrailerFile());
        this.updateReferencedFile(original.getWatermarkFile(), updated.getWatermarkFile());
    }

    private void updateReferencedFile(String original, String updated) throws NotFoundException, IOException {
        if (EqualsUtil.ne((Object)original, (Object)updated)) {
            if (StringUtils.isNotBlank((CharSequence)original)) {
                this.staticFileService.deleteFile(original);
            }
            if (StringUtils.isNotBlank((CharSequence)updated)) {
                this.staticFileService.persistFile(updated);
            }
        }
    }
}

