/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.StreamOp;
import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JObject;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opencastproject.adminui.util.TextFilter;
import org.opencastproject.authorization.xacml.manager.api.AclService;
import org.opencastproject.authorization.xacml.manager.api.AclServiceException;
import org.opencastproject.authorization.xacml.manager.api.AclServiceFactory;
import org.opencastproject.authorization.xacml.manager.api.ManagedAcl;
import org.opencastproject.authorization.xacml.manager.impl.ManagedAclImpl;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.userdirectory.UserIdRoleProvider;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.util.requests.SortCriterion;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin-ng/acl")
@RestService(name="acl", title="Acl service", abstractText="Provides operations for acl", notes={"This service offers the default acl CRUD Operations for the admin UI.", "<strong>Important:</strong> <em>This service is for exclusive use by the module admin-ui. Its API might change anytime without prior notice. Any dependencies other than the admin UI will be strictly ignored. DO NOT use this for integration of third-party applications.<em>"})
@Component(immediate=true, service={AclEndpoint.class}, property={"service.description=Admin UI - ACL Endpoint", "opencast.service.type=org.opencastproject.adminui.AclEndpoint", "opencast.service.path=/admin-ng/acl"})
@JaxrsResource
public class AclEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(AclEndpoint.class);
    private AclServiceFactory aclServiceFactory;
    private SecurityService securityService;
    private RoleDirectoryService roleDirectoryService;
    protected UserDirectoryService userDirectoryService;
    private static final Fn<String, AccessControlList> parseAcl = new Fn<String, AccessControlList>(){

        public AccessControlList apply(String acl) {
            try {
                return AccessControlParser.parseAcl((String)acl);
            }
            catch (Exception e) {
                logger.warn("Unable to parse ACL");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
        }
    };
    private final Fn<AccessControlEntry, JValue> fullAccessControlEntry = new Fn<AccessControlEntry, JValue>(){

        public JValue apply(AccessControlEntry ace) {
            return AclEndpoint.this.full(ace);
        }
    };
    private final Fn<ManagedAcl, JValue> fullManagedAcl = new Fn<ManagedAcl, JValue>(){

        public JValue apply(ManagedAcl acl) {
            return AclEndpoint.this.full(acl);
        }
    };

    @Reference
    public void setAclServiceFactory(AclServiceFactory aclServiceFactory) {
        this.aclServiceFactory = aclServiceFactory;
    }

    @Reference
    public void setRoleDirectoryService(RoleDirectoryService roleDirectoryService) {
        this.roleDirectoryService = roleDirectoryService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        logger.info("Activate the Admin ui - Acl facade endpoint");
    }

    private AclService aclService() {
        return this.aclServiceFactory.serviceFor(this.securityService.getOrganization());
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @GET
    @Path(value="acls.json")
    @Produces(value={"application/json"})
    @RestQuery(name="allaclasjson", description="Returns a list of acls", returnDescription="Returns a JSON representation of the list of acls available the current user's organization", restParameters={@RestParameter(name="filter", isRequired=false, description="The filter used for the query. They should be formated like that: 'filter1:value1,filter2:value2'", type=RestParameter.Type.STRING), @RestParameter(name="sort", isRequired=false, description="The sort order. May include any of the following: NAME. Add '_DESC' to reverse the sort order (e.g. NAME_DESC).", type=RestParameter.Type.STRING), @RestParameter(defaultValue="100", description="The maximum number of items to return per page.", isRequired=false, name="limit", type=RestParameter.Type.STRING), @RestParameter(defaultValue="0", description="The page number.", isRequired=false, name="offset", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The list of ACL's has successfully been returned")})
    public Response getAclsAsJson(@QueryParam(value="filter") String filter, @QueryParam(value="sort") String sort, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit) throws IOException {
        if (limit < 1) {
            limit = 100;
        }
        Opt optSort = Opt.nul((Object)StringUtils.trimToNull((String)sort));
        Option filterName = Option.none();
        Option filterText = Option.none();
        Map filters = RestUtils.parseFilter((String)filter);
        for (Object name : filters.keySet()) {
            String value = (String)filters.get(name);
            if ("Name".equals(name)) {
                filterName = Option.some((Object)value);
                continue;
            }
            if (!"textFilter".equals(name) || !StringUtils.isNotBlank((CharSequence)value)) continue;
            filterText = Option.some((Object)value);
        }
        ArrayList<ManagedAcl> filteredAcls = new ArrayList<ManagedAcl>();
        for (ManagedAcl acl : this.aclService().getAcls()) {
            if (filterName.isSome() && !((String)filterName.get()).equals(acl.getName()) || filterText.isSome() && !TextFilter.match((String)filterText.get(), acl.getName())) continue;
            filteredAcls.add(acl);
        }
        int total = filteredAcls.size();
        if (optSort.isSome()) {
            final ArrayList sortCriteria = RestUtils.parseSortQueryParameter((String)((String)optSort.get()));
            Collections.sort(filteredAcls, new Comparator<ManagedAcl>(){

                @Override
                public int compare(ManagedAcl acl1, ManagedAcl acl2) {
                    Iterator iterator = sortCriteria.iterator();
                    if (iterator.hasNext()) {
                        SortCriterion criterion = (SortCriterion)iterator.next();
                        SortCriterion.Order order = criterion.getOrder();
                        switch (criterion.getFieldName()) {
                            case "name": {
                                if (order.equals((Object)SortCriterion.Order.Descending)) {
                                    return ObjectUtils.compare((Comparable)((Object)acl2.getName()), (Comparable)((Object)acl1.getName()));
                                }
                                return ObjectUtils.compare((Comparable)((Object)acl1.getName()), (Comparable)((Object)acl2.getName()));
                            }
                        }
                        logger.info("Unkown sort type: {}", (Object)criterion.getFieldName());
                        return 0;
                    }
                    return 0;
                }
            });
        }
        List aclJSON = Stream.$(filteredAcls).drop(offset).apply(limit > 0 ? StreamOp.id().take(limit) : StreamOp.id()).map(this.fullManagedAcl).toList();
        return RestUtils.okJsonList((List)aclJSON, (int)offset, (int)limit, (long)total);
    }

    @GET
    @Path(value="roles.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getRoles", description="Returns a list of roles", returnDescription="Returns a JSON representation of the roles with the given parameters under the current user's organization.", restParameters={@RestParameter(name="query", isRequired=false, description="The query.", type=RestParameter.Type.STRING), @RestParameter(name="target", isRequired=false, description="The target of the roles.", type=RestParameter.Type.STRING), @RestParameter(name="limit", defaultValue="100", description="The maximum number of items to return per page.", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="offset", defaultValue="0", description="The page number.", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The list of roles.")})
    public Response getRoles(@QueryParam(value="query") String query, @QueryParam(value="target") String target, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit) {
        Object roleQuery = "%";
        if (StringUtils.isNotBlank((CharSequence)query)) {
            roleQuery = query.trim() + "%";
        }
        Role.Target roleTarget = Role.Target.ALL;
        if (StringUtils.isNotBlank((CharSequence)target)) {
            try {
                roleTarget = Role.Target.valueOf((String)target.trim());
            }
            catch (Exception e) {
                logger.warn("Invalid target filter value {}", (Object)target);
            }
        }
        List roles = this.roleDirectoryService.findRoles((String)roleQuery, roleTarget, offset, limit);
        JSONArray jsonRoles = new JSONArray();
        for (Role role : roles) {
            User user;
            JSONObject jsonRole = new JSONObject();
            jsonRole.put((Object)"name", (Object)role.getName());
            jsonRole.put((Object)"type", (Object)role.getType().toString());
            jsonRole.put((Object)"description", (Object)role.getDescription());
            jsonRole.put((Object)"organization", (Object)role.getOrganizationId());
            jsonRole.put((Object)"isSanitize", (Object)UserIdRoleProvider.isSanitize());
            if (!UserIdRoleProvider.isSanitize() && (user = this.userDirectoryService.loadUser(role.getName().replaceFirst(UserIdRoleProvider.getUserRolePrefix(), ""))) != null) {
                jsonRole.put((Object)"user", this.generateJsonUser(user));
            }
            jsonRoles.add((Object)jsonRole);
        }
        return Response.ok((Object)jsonRoles.toJSONString()).build();
    }

    @DELETE
    @Path(value="{id}")
    @RestQuery(name="deleteacl", description="Delete an ACL", returnDescription="Delete an ACL", pathParameters={@RestParameter(name="id", isRequired=true, description="The ACL identifier", type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=200, description="The ACL has successfully been deleted"), @RestResponse(responseCode=404, description="The ACL has not been found"), @RestResponse(responseCode=409, description="The ACL could not be deleted, there are still references on it")})
    public Response deleteAcl(@PathParam(value="id") long aclId) throws NotFoundException {
        try {
            if (!this.aclService().deleteAcl(aclId)) {
                return RestUtil.R.conflict();
            }
        }
        catch (AclServiceException e) {
            logger.warn("Error deleting manged acl with id '{}'", (Object)aclId, (Object)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return RestUtil.R.noContent();
    }

    @POST
    @Path(value="")
    @Produces(value={"application/json"})
    @RestQuery(name="createacl", description="Create an ACL", returnDescription="Create an ACL", restParameters={@RestParameter(name="name", isRequired=true, description="The ACL name", type=RestParameter.Type.STRING), @RestParameter(name="acl", isRequired=true, description="The access control list", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The ACL has successfully been added"), @RestResponse(responseCode=409, description="An ACL with the same name already exists"), @RestResponse(responseCode=400, description="Unable to parse the ACL")})
    public Response createAcl(@FormParam(value="name") String name, @FormParam(value="acl") String accessControlList) {
        AccessControlList acl = (AccessControlList)parseAcl.apply((Object)accessControlList);
        Optional managedAcl = this.aclService().createAcl(acl, name);
        if (managedAcl.isEmpty()) {
            logger.info("An ACL with the same name '{}' already exists", (Object)name);
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        return RestUtils.okJson((JValue)this.full((ManagedAcl)managedAcl.get()));
    }

    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RestQuery(name="updateacl", description="Update an ACL", returnDescription="Update an ACL", pathParameters={@RestParameter(name="id", isRequired=true, description="The ACL identifier", type=RestParameter.Type.INTEGER)}, restParameters={@RestParameter(name="name", isRequired=true, description="The ACL name", type=RestParameter.Type.STRING), @RestParameter(name="acl", isRequired=true, description="The access control list", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The ACL has successfully been updated"), @RestResponse(responseCode=404, description="The ACL has not been found"), @RestResponse(responseCode=400, description="Unable to parse the ACL")})
    public Response updateAcl(@PathParam(value="id") long aclId, @FormParam(value="name") String name, @FormParam(value="acl") String accessControlList) throws NotFoundException {
        Organization org = this.securityService.getOrganization();
        AccessControlList acl = (AccessControlList)parseAcl.apply((Object)accessControlList);
        ManagedAclImpl managedAcl = new ManagedAclImpl(Long.valueOf(aclId), name, org.getId(), acl);
        if (!this.aclService().updateAcl((ManagedAcl)managedAcl)) {
            logger.info("No ACL with id '{}' could be found under organization '{}'", (Object)aclId, (Object)org.getId());
            throw new NotFoundException();
        }
        return RestUtils.okJson((JValue)this.full((ManagedAcl)managedAcl));
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RestQuery(name="getacl", description="Return the ACL by the given id", returnDescription="Return the ACL by the given id", pathParameters={@RestParameter(name="id", isRequired=true, description="The ACL identifier", type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=200, description="The ACL has successfully been returned"), @RestResponse(responseCode=404, description="The ACL has not been found")})
    public Response getAcl(@PathParam(value="id") long aclId) throws NotFoundException {
        Optional managedAcl = this.aclService().getAcl(aclId);
        if (managedAcl.isPresent()) {
            return RestUtils.okJson((JValue)this.full((ManagedAcl)managedAcl.get()));
        }
        logger.info("No ACL with id '{}' could by found", (Object)aclId);
        throw new NotFoundException();
    }

    public JObject full(AccessControlEntry ace) {
        return Jsons.obj((Field[])new Field[]{Jsons.f((String)"role", (JValue)Jsons.v((String)ace.getRole())), Jsons.f((String)"action", (JValue)Jsons.v((String)ace.getAction())), Jsons.f((String)"allow", (JValue)Jsons.v((Boolean)ace.isAllow()))});
    }

    public JObject full(AccessControlList acl) {
        return Jsons.obj((Field[])new Field[]{Jsons.f((String)"ace", (JValue)Jsons.arr((Iterable)Stream.$((Iterable)acl.getEntries()).map(this.fullAccessControlEntry)))});
    }

    public JObject full(ManagedAcl acl) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(Jsons.f((String)"id", (JValue)Jsons.v((Number)acl.getId())));
        fields.add(Jsons.f((String)"name", (JValue)Jsons.v((String)acl.getName())));
        fields.add(Jsons.f((String)"organizationId", (JValue)Jsons.v((String)acl.getOrganizationId())));
        fields.add(Jsons.f((String)"acl", (JValue)this.full(acl.getAcl())));
        return Jsons.obj(fields);
    }

    public Map<String, Object> generateJsonUser(User user) {
        HashMap<String, Object> userData = new HashMap<String, Object>();
        userData.put("username", user.getUsername());
        userData.put("name", user.getName());
        userData.put("email", user.getEmail());
        return userData;
    }
}

