/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opencastproject.adminui.impl.AdminUIConfiguration;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.util.WorkflowPropertiesUtil;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.distribution.api.DistributionException;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.attachment.AttachmentImpl;
import org.opencastproject.publication.api.ConfigurablePublicationService;
import org.opencastproject.publication.api.OaiPmhPublicationService;
import org.opencastproject.publication.api.PublicationException;
import org.opencastproject.security.urlsigning.exception.UrlSigningException;
import org.opencastproject.security.urlsigning.service.UrlSigningService;
import org.opencastproject.util.MimeType;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.UnknownFileTypeException;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThumbnailImpl {
    private static final String THUMBNAIL_PROPERTY_TYPE = "thumbnailType";
    private static final String THUMBNAIL_PROPERTY_POSITION = "thumbnailPosition";
    private static final String THUMBNAIL_PROPERTY_TRACK = "thumbnailTrack";
    private static final Logger logger = LoggerFactory.getLogger(ThumbnailImpl.class);
    private final MediaPackageElementFlavor previewFlavor;
    private final String masterProfile;
    private final String previewProfile;
    private final String previewProfileDownscale;
    private final MediaPackageElementFlavor uploadedFlavor;
    private final List<String> uploadedTags;
    private final Workspace workspace;
    private final OaiPmhPublicationService oaiPmhPublicationService;
    private final AssetManager assetManager;
    private final ConfigurablePublicationService configurablePublicationService;
    private final ComposerService composerService;
    private final double defaultPosition;
    private final String sourceFlavorSubtype;
    private final MediaPackageElementFlavor sourceFlavorPrimary;
    private final MediaPackageElementFlavor sourceFlavorSecondary;
    private String tempThumbnailFileName;
    private final String tempThumbnailId;
    private URI tempThumbnail;
    private MimeType tempThumbnailMimeType;
    private AdminUIConfiguration.ThumbnailDistributionSettings distributionOaiPmh;
    private AdminUIConfiguration.ThumbnailDistributionSettings distributionConfigurable;

    public ThumbnailImpl(AdminUIConfiguration config, Workspace workspace, OaiPmhPublicationService oaiPmhPublicationService, ConfigurablePublicationService configurablePublicationService, AssetManager assetManager, ComposerService composerService) {
        this.masterProfile = config.getThumbnailMasterProfile();
        this.previewFlavor = MediaPackageElementFlavor.parseFlavor((String)config.getThumbnailPreviewFlavor());
        this.previewProfile = config.getThumbnailPreviewProfile();
        this.previewProfileDownscale = config.getThumbnailPreviewProfileDownscale();
        this.uploadedFlavor = MediaPackageElementFlavor.parseFlavor((String)config.getThumbnailUploadedFlavor());
        this.uploadedTags = Arrays.asList(config.getThumbnailUploadedTags().split(","));
        this.defaultPosition = config.getThumbnailDefaultPosition();
        this.sourceFlavorSubtype = config.getThumbnailSourceFlavorSubtype();
        this.sourceFlavorPrimary = MediaPackageElementFlavor.flavor((String)config.getThumbnailSourceFlavorTypePrimary(), (String)config.getThumbnailSourceFlavorSubtype());
        this.sourceFlavorSecondary = MediaPackageElementFlavor.flavor((String)config.getThumbnailSourceFlavorTypeSecondary(), (String)config.getThumbnailSourceFlavorSubtype());
        this.workspace = workspace;
        this.oaiPmhPublicationService = oaiPmhPublicationService;
        this.assetManager = assetManager;
        this.composerService = composerService;
        this.configurablePublicationService = configurablePublicationService;
        this.tempThumbnail = null;
        this.tempThumbnailId = null;
        this.tempThumbnailMimeType = null;
        this.tempThumbnailFileName = null;
        this.distributionOaiPmh = config.getThumbnailDistributionOaiPmh();
        this.distributionConfigurable = config.getThumbnailDistributionConfigurable();
    }

    private Optional<Attachment> getThumbnailPreviewForMediaPackage(MediaPackage mp) {
        Optional<Publication> internalPublication = this.getPublication(mp, "internal");
        if (internalPublication.isPresent()) {
            return Arrays.stream(internalPublication.get().getAttachments()).filter(attachment -> this.previewFlavor.matches(attachment.getFlavor())).findFirst();
        }
        throw new IllegalStateException("Expected internal publication, but found none for mp " + mp.getIdentifier());
    }

    public double getDefaultPosition() {
        return this.defaultPosition;
    }

    public Optional<Thumbnail> getThumbnail(MediaPackage mp, UrlSigningService urlSigningService, Long expireSeconds) throws UrlSigningException, URISyntaxException {
        Optional<Attachment> optThumbnail = this.getThumbnailPreviewForMediaPackage(mp);
        if (!optThumbnail.isPresent()) {
            return Optional.empty();
        }
        Attachment thumbnail = optThumbnail.get();
        URI url = urlSigningService.accepts(thumbnail.getURI().toString()) ? new URI(urlSigningService.sign(optThumbnail.get().getURI().toString(), expireSeconds, null, null)) : thumbnail.getURI();
        Map ps = WorkflowPropertiesUtil.getLatestWorkflowProperties((AssetManager)this.assetManager, (String)mp.getIdentifier().toString());
        ThumbnailSource source = ps.entrySet().stream().filter(p -> THUMBNAIL_PROPERTY_TYPE.equals(p.getKey())).map(Map.Entry::getValue).map(Long::parseLong).map(ThumbnailSource::byNumber).findAny().orElse(ThumbnailSource.DEFAULT);
        Double position = ps.entrySet().stream().filter(p -> THUMBNAIL_PROPERTY_POSITION.equals(p.getKey())).map(Map.Entry::getValue).map(Double::parseDouble).findAny().orElse(this.defaultPosition);
        String track = ps.entrySet().stream().filter(p -> THUMBNAIL_PROPERTY_TRACK.equals(p.getKey())).map(Map.Entry::getValue).findAny().orElse(null);
        return Optional.of(new Thumbnail(source, position, track, url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaPackageElement upload(MediaPackage mp, InputStream inputStream, String contentType) throws IOException, NotFoundException, MediaPackageException, PublicationException, EncoderException, DistributionException {
        this.createTempThumbnail(mp, inputStream, contentType);
        ArrayList<URI> deletionUris = new ArrayList<URI>(0);
        try {
            this.archive(mp);
            MediaPackageElementFlavor trackFlavor = this.getPrimaryOrSecondaryTrack(mp).getFlavor();
            Tuple<URI, List<MediaPackageElement>> internalPublicationResult = this.updateInternalPublication(mp, false);
            deletionUris.add((URI)internalPublicationResult.getA());
            if (this.distributionConfigurable.getEnabled()) {
                deletionUris.add(this.updateConfigurablePublication(mp, trackFlavor));
            }
            if (this.distributionOaiPmh.getEnabled()) {
                deletionUris.add(this.updateOaiPmh(mp, trackFlavor));
            }
            this.assetManager.takeSnapshot(mp);
            WorkflowPropertiesUtil.storeProperty((AssetManager)this.assetManager, (MediaPackage)mp, (String)THUMBNAIL_PROPERTY_TYPE, (String)Long.toString(ThumbnailSource.UPLOAD.getNumber()));
            MediaPackageElement mediaPackageElement = (MediaPackageElement)((List)internalPublicationResult.getB()).get(0);
            return mediaPackageElement;
        }
        finally {
            inputStream.close();
            this.workspace.cleanup(mp.getIdentifier());
            for (URI uri : deletionUris) {
                if (uri == null) continue;
                this.workspace.delete(uri);
            }
        }
    }

    private Track getPrimaryOrSecondaryTrack(MediaPackage mp) throws MediaPackageException {
        Optional<Track> track = Optional.ofNullable(Arrays.stream(mp.getTracks(this.sourceFlavorPrimary)).findFirst().orElse(Arrays.stream(mp.getTracks(this.sourceFlavorSecondary)).findFirst().orElse(null)));
        if (track.isPresent()) {
            return track.get();
        }
        throw new MediaPackageException("Cannot find track with primary or secondary source flavor.");
    }

    private void archive(MediaPackage mp) {
        Attachment attachment = AttachmentImpl.fromURI((URI)this.tempThumbnail);
        attachment.setIdentifier(this.tempThumbnailId);
        attachment.setFlavor(this.uploadedFlavor);
        attachment.setMimeType(this.tempThumbnailMimeType);
        this.uploadedTags.forEach(arg_0 -> ((Attachment)attachment).addTag(arg_0));
        Arrays.stream(mp.getElementsByFlavor(this.uploadedFlavor)).forEach(arg_0 -> ((MediaPackage)mp).remove(arg_0));
        mp.add(attachment);
    }

    private Tuple<URI, List<MediaPackageElement>> updateInternalPublication(MediaPackage mp, boolean downscale) throws DistributionException, NotFoundException, IOException, MediaPackageException, PublicationException, EncoderException {
        Predicate<Attachment> priorFilter = attachment -> this.previewFlavor.matches(attachment.getFlavor());
        if (downscale) {
            return this.updatePublication(mp, "internal", priorFilter, this.previewFlavor, Collections.emptyList(), this.previewProfileDownscale);
        }
        return this.updatePublication(mp, "internal", priorFilter, this.previewFlavor, Collections.emptyList(), new String[0]);
    }

    private URI updateOaiPmh(MediaPackage mp, MediaPackageElementFlavor trackFlavor) throws NotFoundException, IOException, PublicationException, MediaPackageException, DistributionException, EncoderException {
        Optional<Publication> oldOaiPmhPub = this.getPublication(mp, this.distributionOaiPmh.getChannelId());
        if (!oldOaiPmhPub.isPresent()) {
            logger.debug("Thumbnail auto-distribution: No publications found for OAI-PMH publication channel {}", (Object)this.distributionOaiPmh.getChannelId());
            return null;
        }
        logger.debug("Thumbnail auto-distribution: Updating thumbnail of OAI-PMH publication channel {}", (Object)this.distributionOaiPmh.getChannelId());
        Optional<Publication> configurablePublicationOpt = this.getPublication(mp, this.distributionConfigurable.getChannelId());
        HashSet publicationsToUpdate = new HashSet();
        configurablePublicationOpt.ifPresent(publicationsToUpdate::add);
        String publishThumbnailId = UUID.randomUUID().toString();
        InputStream inputStream = this.tempInputStream();
        URI publishThumbnailUri = this.workspace.put(mp.getIdentifier().toString(), publishThumbnailId, this.tempThumbnailFileName, inputStream);
        inputStream.close();
        Attachment publishAttachment = AttachmentImpl.fromURI((URI)publishThumbnailUri);
        publishAttachment.setIdentifier(UUID.randomUUID().toString());
        publishAttachment.setFlavor(this.distributionOaiPmh.getFlavor().applyTo(trackFlavor));
        for (String tag : this.distributionOaiPmh.getTags()) {
            publishAttachment.addTag(tag);
        }
        publishAttachment.setMimeType(this.tempThumbnailMimeType);
        HashSet<Attachment> addElements = new HashSet<Attachment>();
        if (this.distributionOaiPmh.getProfiles().length > 0) {
            addElements.addAll(this.downscaleAttachment(publishAttachment, this.distributionOaiPmh.getProfiles()));
        } else {
            addElements.add(publishAttachment);
        }
        Publication oaiPmhPub = this.oaiPmhPublicationService.replaceSync(mp, this.getRepositoryName(this.distributionOaiPmh.getChannelId()), addElements, Collections.emptySet(), Collections.singleton(this.distributionOaiPmh.getFlavor()), Collections.emptySet(), publicationsToUpdate, false);
        mp.remove((MediaPackageElement)oldOaiPmhPub.get());
        mp.add((MediaPackageElement)oaiPmhPub);
        return publishThumbnailUri;
    }

    private Tuple<URI, List<MediaPackageElement>> updatePublication(MediaPackage mp, String channelId, Predicate<Attachment> priorFilter, MediaPackageElementFlavor flavor, Collection<String> tags, String ... conversionProfiles) throws DistributionException, NotFoundException, IOException, MediaPackageException, PublicationException, EncoderException {
        logger.debug("Updating thumnbail of flavor '{}' in publication channel '{}'", (Object)flavor, (Object)channelId);
        Optional<Publication> pubOpt = this.getPublication(mp, channelId);
        if (!pubOpt.isPresent()) {
            return null;
        }
        Publication pub = pubOpt.get();
        String aid = UUID.randomUUID().toString();
        InputStream inputStream = this.tempInputStream();
        URI aUri = this.workspace.put(mp.getIdentifier().toString(), aid, this.tempThumbnailFileName, inputStream);
        inputStream.close();
        Attachment attachment = AttachmentImpl.fromURI((URI)aUri);
        attachment.setIdentifier(aid);
        attachment.setFlavor(flavor);
        tags.forEach(arg_0 -> ((Attachment)attachment).addTag(arg_0));
        attachment.setMimeType(this.tempThumbnailMimeType);
        ArrayList<Attachment> addElements = new ArrayList<Attachment>();
        if (conversionProfiles != null && conversionProfiles.length > 0) {
            addElements.addAll(this.downscaleAttachment(attachment, conversionProfiles));
        } else {
            addElements.add(attachment);
        }
        Set removeElementsIds = Arrays.stream(pub.getAttachments()).filter(priorFilter).map(MediaPackageElement::getIdentifier).collect(Collectors.toSet());
        Publication newPublication = this.configurablePublicationService.replaceSync(mp, channelId, addElements, removeElementsIds);
        mp.remove((MediaPackageElement)pub);
        mp.add((MediaPackageElement)newPublication);
        Set newAttachmentIds = addElements.stream().map(MediaPackageElement::getIdentifier).collect(Collectors.toSet());
        return Tuple.tuple((Object)aUri, Arrays.stream(newPublication.getAttachments()).filter(att -> newAttachmentIds.contains(att.getIdentifier())).collect(Collectors.toList()));
    }

    private List<Attachment> downscaleAttachment(Attachment attachment, String ... conversionProfiles) throws DistributionException, EncoderException, MediaPackageException {
        List downscaled = this.composerService.convertImageSync(attachment, conversionProfiles);
        return downscaled.stream().map(a -> ThumbnailImpl.cloneAttachment(attachment, a.getURI())).collect(Collectors.toList());
    }

    private URI updateConfigurablePublication(MediaPackage mp, MediaPackageElementFlavor trackFlavor) throws IOException, NotFoundException, MediaPackageException, PublicationException, EncoderException, DistributionException {
        Predicate<Attachment> flavorFilter = a -> a.getFlavor().matches(this.distributionConfigurable.getFlavor());
        Predicate<Attachment> tagsFilter = a -> Arrays.asList(this.distributionConfigurable.getTags()).stream().allMatch(t -> Arrays.asList(a.getTags()).contains(t));
        Predicate<Attachment> priorFilter = flavorFilter.and(tagsFilter);
        Tuple<URI, List<MediaPackageElement>> result = this.updatePublication(mp, this.distributionConfigurable.getChannelId(), priorFilter, this.distributionConfigurable.getFlavor().applyTo(trackFlavor), Arrays.asList(this.distributionConfigurable.getTags()), this.distributionConfigurable.getProfiles());
        if (result != null) {
            return (URI)result.getA();
        }
        return null;
    }

    private InputStream tempInputStream() throws NotFoundException, IOException {
        return this.workspace.read(this.tempThumbnail);
    }

    private void createTempThumbnail(MediaPackage mp, InputStream inputStream, String contentType) throws IOException {
        this.tempThumbnailMimeType = MimeTypes.parseMimeType((String)contentType);
        String filename = "uploaded_thumbnail." + (String)this.tempThumbnailMimeType.getSuffix().getOrElse((Object)"unknown");
        String originalThumbnailId = UUID.randomUUID().toString();
        this.tempThumbnail = this.workspace.put(mp.getIdentifier().toString(), originalThumbnailId, filename, inputStream);
        this.tempThumbnailFileName = "uploaded_thumbnail." + (String)this.tempThumbnailMimeType.getSuffix().getOrElse((Object)"unknown");
    }

    private Optional<Publication> getPublication(MediaPackage mp, String channelId) {
        return Arrays.stream(mp.getPublications()).filter(p -> p.getChannel().equalsIgnoreCase(channelId)).findAny();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaPackageElement chooseThumbnail(MediaPackage mp, Track track, double position, Optional<Tuple<InputStream, String>> optPreview) throws PublicationException, MediaPackageException, EncoderException, IOException, NotFoundException, UnknownFileTypeException, DistributionException {
        ArrayList<URI> deletionUris = new ArrayList<URI>(0);
        try {
            boolean downscale;
            if (optPreview.isPresent()) {
                this.createTempThumbnail(mp, (InputStream)optPreview.get().getA(), (String)optPreview.get().getB());
                this.archive(mp);
                downscale = false;
            } else {
                this.tempThumbnail = ((Attachment)this.composerService.imageSync(track, this.masterProfile, new double[]{position}).get(0)).getURI();
                this.tempThumbnailMimeType = MimeTypes.fromURI((URI)this.tempThumbnail);
                this.tempThumbnailFileName = this.tempThumbnail.getPath().substring(this.tempThumbnail.getPath().lastIndexOf(47) + 1);
                downscale = true;
            }
            Arrays.stream(mp.getElementsByFlavor(this.uploadedFlavor)).forEach(arg_0 -> ((MediaPackage)mp).remove(arg_0));
            Tuple<URI, List<MediaPackageElement>> internalPublicationResult = this.updateInternalPublication(mp, downscale);
            deletionUris.add((URI)internalPublicationResult.getA());
            if (this.distributionConfigurable.getEnabled()) {
                deletionUris.add(this.updateConfigurablePublication(mp, track.getFlavor()));
            }
            if (this.distributionOaiPmh.getEnabled()) {
                deletionUris.add(this.updateOaiPmh(mp, track.getFlavor()));
            }
            this.assetManager.takeSnapshot(mp);
            MediaPackageElement mediaPackageElement = (MediaPackageElement)((List)internalPublicationResult.getB()).get(0);
            return mediaPackageElement;
        }
        finally {
            this.workspace.cleanup(mp.getIdentifier());
            for (URI uri : deletionUris) {
                if (uri == null) continue;
                this.workspace.delete(uri);
            }
        }
    }

    public MediaPackageElement chooseDefaultThumbnail(MediaPackage mp, double position, Optional<Tuple<InputStream, String>> optPreview) throws PublicationException, MediaPackageException, EncoderException, IOException, NotFoundException, UnknownFileTypeException, DistributionException {
        MediaPackageElement result = this.chooseThumbnail(mp, this.getPrimaryOrSecondaryTrack(mp), position, optPreview);
        WorkflowPropertiesUtil.storeProperty((AssetManager)this.assetManager, (MediaPackage)mp, (String)THUMBNAIL_PROPERTY_TYPE, (String)Long.toString(ThumbnailSource.DEFAULT.getNumber()));
        WorkflowPropertiesUtil.storeProperty((AssetManager)this.assetManager, (MediaPackage)mp, (String)THUMBNAIL_PROPERTY_POSITION, (String)Double.toString(position));
        return result;
    }

    public MediaPackageElement chooseThumbnail(MediaPackage mp, String trackFlavorType, double position, Optional<Tuple<InputStream, String>> optPreview) throws PublicationException, MediaPackageException, EncoderException, IOException, NotFoundException, UnknownFileTypeException, DistributionException {
        MediaPackageElementFlavor trackFlavor = MediaPackageElementFlavor.flavor((String)trackFlavorType, (String)this.sourceFlavorSubtype);
        Optional<Track> track = Arrays.stream(mp.getTracks(trackFlavor)).findFirst();
        if (!track.isPresent()) {
            throw new MediaPackageException("Cannot find stream with flavor " + trackFlavor + " to extract thumbnail.");
        }
        MediaPackageElement result = this.chooseThumbnail(mp, track.get(), position, optPreview);
        WorkflowPropertiesUtil.storeProperty((AssetManager)this.assetManager, (MediaPackage)mp, (String)THUMBNAIL_PROPERTY_TYPE, (String)Long.toString(ThumbnailSource.SNAPSHOT.getNumber()));
        WorkflowPropertiesUtil.storeProperty((AssetManager)this.assetManager, (MediaPackage)mp, (String)THUMBNAIL_PROPERTY_POSITION, (String)Double.toString(position));
        WorkflowPropertiesUtil.storeProperty((AssetManager)this.assetManager, (MediaPackage)mp, (String)THUMBNAIL_PROPERTY_TRACK, (String)trackFlavor.getType());
        return result;
    }

    private static Attachment cloneAttachment(Attachment attachmentToClone, URI newUri) {
        try {
            Attachment result = (Attachment)MediaPackageElementParser.getFromXml((String)MediaPackageElementParser.getAsXml((MediaPackageElement)attachmentToClone));
            result.setIdentifier(UUID.randomUUID().toString());
            result.setURI(newUri);
            return result;
        }
        catch (MediaPackageException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isAutoDistributionEnabled() {
        return this.distributionOaiPmh.getEnabled() || this.distributionConfigurable.getEnabled();
    }

    private String getRepositoryName(String publicationChannelId) {
        return publicationChannelId.replaceFirst("oaipmh-", "");
    }

    public static class Thumbnail {
        private final ThumbnailSource type;
        private final Double position;
        private final String track;
        private final URI url;

        public Thumbnail(ThumbnailSource type, Double position, String track, URI url) {
            this.type = type;
            this.position = position;
            this.track = track;
            this.url = url;
        }

        public ThumbnailSource getType() {
            return this.type;
        }

        public OptionalDouble getPosition() {
            if (this.position != null) {
                return OptionalDouble.of(this.position);
            }
            return OptionalDouble.empty();
        }

        public Optional<String> getTrack() {
            if (this.track != null) {
                return Optional.of(this.track);
            }
            return Optional.empty();
        }

        public URI getUrl() {
            return this.url;
        }
    }

    public static enum ThumbnailSource {
        DEFAULT(0L),
        UPLOAD(1L),
        SNAPSHOT(2L);

        private final long number;

        private ThumbnailSource(long number) {
            this.number = number;
        }

        public long getNumber() {
            return this.number;
        }

        public static ThumbnailSource byNumber(long number) {
            return Arrays.stream(ThumbnailSource.values()).filter(v -> v.number == number).findFirst().orElse(DEFAULT);
        }
    }
}

