/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import com.google.gson.Gson;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.serviceregistry.api.HostRegistration;
import org.opencastproject.serviceregistry.api.HostStatistics;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.util.requests.SortCriterion;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="ServerProxyService", title="UI Servers", abstractText="This service provides the server data for the UI.", notes={"These Endpoints deliver informations about the server required for the UI.", "<strong>Important:</strong> <em>This service is for exclusive use by the module admin-ui. Its API might change anytime without prior notice. Any dependencies other than the admin UI will be strictly ignored. DO NOT use this for integration of third-party applications.<em>"})
@Component(immediate=true, service={ServerEndpoint.class}, property={"service.description=Admin UI - Server facade Endpoint", "opencast.service.type=org.opencastproject.adminui.endpoint.ServerEndpoint", "opencast.service.path=/admin-ng/server"})
public class ServerEndpoint {
    private static final Gson gson = new Gson();
    private static final String KEY_HOSTNAME = "hostname";
    private static final String KEY_NODE_NAME = "nodeName";
    private static final String KEY_STATUS = "status";
    private static final String KEY_TEXT_FILTER = "textFilter";
    private static final long CACHE_SECONDS = 60L;
    private static final Logger logger = LoggerFactory.getLogger(ServerEndpoint.class);
    private ServiceRegistry serviceRegistry;
    private long lastUpdated = 0L;
    private final List<Server> serverData = new ArrayList<Server>();

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        logger.info("Activate job endpoint");
    }

    @GET
    @Path(value="servers.json")
    @Produces(value={"application/json"})
    @RestQuery(description="Returns the list of servers", name="servers", restParameters={@RestParameter(name="limit", description="The maximum number of items to return per page", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", description="The offset", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="filter", description="Filter results by hostname, status or free text query", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="sort", description="The sort order.  May include any of the following: CORES, HOSTNAME, MAINTENANCE, ONLINE, QUEUED (jobs), RUNNING (jobs).The suffix must be :ASC for ascending or :DESC for descending sort order (e.g. HOSTNAME:DESC).", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the list of jobs from Opencast", responseCode=200)}, returnDescription="The list of servers")
    public Response getServers(@QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset, @QueryParam(value="filter") String filter, @QueryParam(value="sort") String sort) throws Exception {
        List serverResults;
        Map<String, String> filters;
        try {
            filters = Arrays.stream(StringUtils.split((String)Objects.toString(filter, ""), (String)",")).map(f -> f.split(":", 2)).collect(Collectors.toMap(f -> f[0], f -> f[1]));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.badRequest("Invalid filter string", e);
        }
        ArrayList<Server> servers = new ArrayList<Server>();
        for (Server server : this.getServerData()) {
            Status status;
            if (!filters.getOrDefault(KEY_HOSTNAME, server.hostname).equalsIgnoreCase(server.hostname) || !StringUtils.equalsIgnoreCase((CharSequence)filters.getOrDefault(KEY_NODE_NAME, server.nodeName), (CharSequence)server.nodeName) || filters.containsKey(KEY_STATUS) && (Status.ONLINE.equals((Object)(status = Status.valueOf(filters.get(KEY_STATUS).toUpperCase()))) && !server.online || Status.OFFLINE.equals((Object)status) && server.online || Status.MAINTENANCE.equals((Object)status) && !server.maintenance)) continue;
            String text = filters.getOrDefault(KEY_TEXT_FILTER, "");
            if (Stream.of(server.hostname, server.nodeName).noneMatch(v -> StringUtils.containsIgnoreCase((CharSequence)v, (CharSequence)text))) continue;
            servers.add(server);
        }
        Sort sortKey = Sort.HOSTNAME;
        boolean ascending = true;
        if (StringUtils.isNotBlank((CharSequence)sort)) {
            try {
                SortCriterion sortCriterion = (SortCriterion)RestUtils.parseSortQueryParameter((String)sort).iterator().next();
                sortKey = Sort.valueOf(sortCriterion.getFieldName().toUpperCase());
                ascending = SortCriterion.Order.Ascending == sortCriterion.getOrder() || SortCriterion.Order.None == sortCriterion.getOrder();
            }
            catch (IllegalArgumentException | WebApplicationException e) {
                return this.badRequest(String.format("Invalid sort parameter `%s`", sort), (Exception)e);
            }
        }
        servers.sort(new ServerComparator(sortKey, ascending));
        offset = Math.min(offset, servers.size());
        try {
            serverResults = servers.subList(offset, Math.min(servers.size(), limit + offset));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            return this.badRequest("Invalid offset and limit", e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("total", servers.size());
        result.put("offset", offset);
        result.put("count", serverResults.size());
        result.put("limit", limit);
        result.put("results", serverResults);
        return Response.ok((Object)gson.toJson(result)).build();
    }

    private synchronized List<Server> getServerData() throws ServiceRegistryException {
        if (this.lastUpdated + 60L > Instant.now().getEpochSecond()) {
            logger.debug("Using server data cache.");
            return this.serverData;
        }
        this.serverData.clear();
        logger.debug("Updating server data");
        HostStatistics statistics = this.serviceRegistry.getHostStatistics();
        for (HostRegistration host : this.serviceRegistry.getHostRegistrations()) {
            Server server = new Server();
            server.online = host.isOnline();
            server.maintenance = host.isMaintenanceMode();
            server.hostname = host.getBaseUrl();
            server.nodeName = host.getNodeName();
            server.cores = host.getCores();
            server.running = statistics.runningJobs(host.getId().longValue());
            server.queued = statistics.queuedJobs(host.getId().longValue());
            this.serverData.add(server);
        }
        this.lastUpdated = Instant.now().getEpochSecond();
        return this.serverData;
    }

    private Response badRequest(String message, Exception e) {
        logger.debug(message, (Throwable)(e == null && logger.isDebugEnabled() ? new IllegalArgumentException(message) : e));
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)gson.toJson((Object)message)).build();
    }

    private class Server {
        protected boolean online;
        protected boolean maintenance;
        protected String hostname;
        protected String nodeName;
        protected long cores;
        protected long running;
        protected long queued;

        private Server() {
        }
    }

    private class ServerComparator
    implements Comparator<Server> {
        private final Sort sortType;
        private final boolean ascending;

        ServerComparator(Sort sortType, Boolean ascending) {
            this.sortType = sortType;
            this.ascending = ascending;
        }

        @Override
        public int compare(Server host1, Server host2) {
            return (this.ascending ? 1 : -1) * this.compareByType(host1, host2);
        }

        private int compareByType(Server host1, Server host2) {
            switch (this.sortType) {
                case ONLINE: {
                    return Boolean.compare(host1.online, host2.online);
                }
                case CORES: {
                    return Long.compare(host1.cores, host2.cores);
                }
                case QUEUED: {
                    return Long.compare(host1.queued, host2.queued);
                }
                case MAINTENANCE: {
                    return Boolean.compare(host1.maintenance, host2.maintenance);
                }
                case RUNNING: {
                    return Long.compare(host1.running, host2.running);
                }
                case NODENAME: {
                    return host1.nodeName.compareTo(host2.nodeName);
                }
            }
            return host1.hostname.compareTo(host2.hostname);
        }
    }

    private static enum Status {
        ONLINE,
        OFFLINE,
        MAINTENANCE;

    }

    private static enum Sort {
        CORES,
        HOSTNAME,
        MAINTENANCE,
        NODENAME,
        ONLINE,
        QUEUED,
        RUNNING;

    }
}

