/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.iface;

import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Shutdownable {
    public void shutdown();

    public static void registerShutdownHook(Shutdownable shutdownable) {
        Runtime.getRuntime().addShutdownHook(new ShutdownDeamon(shutdownable));
    }

    public static class ShutdownDeamon
    extends Thread {
        private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownDeamon.class);
        private final Shutdownable shutdownable;

        public ShutdownDeamon(Shutdownable shutdownable) {
            this.shutdownable = shutdownable;
        }

        @Override
        public void run() {
            try {
                this.shutdownable.shutdown();
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((String)("Could not shutdown " + this.shutdownable + "!"), (Throwable)ex, (Logger)LOGGER);
            }
        }
    }
}

