/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.exception.printer;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.printer.ElementGenerator;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.exception.printer.LogPrinter;
import org.openbase.jul.exception.printer.MultiExceptionElementGenerator;
import org.openbase.jul.exception.printer.Printer;
import org.openbase.jul.exception.printer.SystemPrinter;
import org.openbase.jul.exception.printer.ThrowableElementGenerator;
import org.openbase.jul.exception.printer.VariablePrinter;
import org.slf4j.Logger;

public class ExceptionPrinter {
    private static final String SEPARATOR = "=====================================";
    private static final ElementGenerator<MultiException.SourceExceptionEntry> MULTI_EXCEPTION_ELEMENT_GENERATOR = new MultiExceptionElementGenerator();
    private static final ElementGenerator<Throwable> THROWABLE_ELEMENT_GENERATOR = new ThrowableElementGenerator();
    private static Boolean beQuiet = false;

    public static void setBeQuit(Boolean beQuiet) {
        ExceptionPrinter.beQuiet = beQuiet;
    }

    public static <T extends Throwable> T printHistoryAndReturnThrowable(T th, Logger logger) {
        return ExceptionPrinter.printHistoryAndReturnThrowable(th, logger, LogLevel.ERROR);
    }

    public static <T extends Throwable> T printHistoryAndReturnThrowable(T th, Logger logger, LogLevel level) {
        ExceptionPrinter.printHistory(th, new LogPrinter(logger, level));
        return th;
    }

    public static <T extends Throwable> void printHistory(T th, Logger logger, LogLevel level) {
        ExceptionPrinter.printHistory(th, new LogPrinter(logger, level));
    }

    public static <T extends Throwable> void printHistory(T th, Logger logger) {
        ExceptionPrinter.printHistory(th, logger, LogLevel.ERROR);
    }

    public static <T extends Throwable> void printHistoryAndExit(T th, Logger logger) {
        ExceptionPrinter.printHistory(th, logger, LogLevel.ERROR);
        ExceptionPrinter.exit(255);
    }

    public static <T extends Throwable> void printHistory(String message, T th, Logger logger) {
        ExceptionPrinter.printHistory(new CouldNotPerformException(message, th), logger, LogLevel.ERROR);
    }

    public static <T extends Throwable> void printHistoryAndExit(String message, T th, Logger logger) {
        ExceptionPrinter.printHistory(new CouldNotPerformException(message, th), logger, LogLevel.ERROR);
        ExceptionPrinter.exit(255);
    }

    public static <T extends Throwable> void printHistory(T th, PrintStream stream) {
        ExceptionPrinter.printHistory(th, new SystemPrinter(stream));
    }

    public static <T extends Throwable> void printHistoryAndExit(T th, PrintStream stream) {
        ExceptionPrinter.printHistory(th, new SystemPrinter(stream));
        ExceptionPrinter.exit(255);
    }

    public static <T extends Throwable> void printHistory(String message, T th, PrintStream stream) {
        ExceptionPrinter.printHistory(new CouldNotPerformException(message, th), new SystemPrinter(stream));
    }

    public static <T extends Throwable> void printHistoryAndExit(String message, T th, PrintStream stream) {
        ExceptionPrinter.printHistory(new CouldNotPerformException(message, th), new SystemPrinter(stream));
        ExceptionPrinter.exit(255);
    }

    private static void exit(int errorCode) {
        if (JPService.testMode()) {
            throw new RuntimeException("System exit called in test mode!");
        }
        System.exit(errorCode);
    }

    public static <T extends Throwable> T printHistoryAndReturnThrowable(T th, PrintStream stream) {
        ExceptionPrinter.printHistory(th, new SystemPrinter(stream));
        return th;
    }

    public static <T extends Throwable> T printHistoryAndReturnThrowable(T th, Printer printer) {
        ExceptionPrinter.printHistory(th, printer);
        return th;
    }

    public static <T extends Throwable> void printHistory(T th, Printer printer) {
        if (beQuiet.booleanValue()) {
            return;
        }
        ExceptionPrinter.printHistory(th, printer, "", "");
        if (printer.isDebugEnabled()) {
            printer.print(SEPARATOR);
            printer.print(ExceptionPrinter.getContext(th), th);
        }
        printer.print(SEPARATOR);
    }

    public static String getHistory(Throwable th) {
        VariablePrinter printer = new VariablePrinter();
        ExceptionPrinter.printHistory(th, printer);
        return printer.getMessages();
    }

    static void printHistory(Throwable th, Printer printer, String rootPrefix, String childPrefix) {
        if (beQuiet.booleanValue()) {
            return;
        }
        if (th instanceof MultiException) {
            ExceptionPrinter.printFlatTree(new MultiException.SourceExceptionEntry(ExceptionPrinter.class, th), ((MultiException)th).getExceptionStack(), MULTI_EXCEPTION_ELEMENT_GENERATOR, printer, rootPrefix, childPrefix);
        } else {
            ExceptionPrinter.printSequenze(ExceptionPrinter.buildThrowableList(th), THROWABLE_ELEMENT_GENERATOR, printer, rootPrefix, childPrefix);
        }
    }

    private static List<Throwable> buildThrowableList(Throwable ex) {
        ArrayList<Throwable> throwableList = new ArrayList<Throwable>();
        if (ex == null) {
            return throwableList;
        }
        throwableList.add(ex);
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            throwableList.add(cause);
        }
        return throwableList;
    }

    private static <T> void printSequenze(List<T> elementList, ElementGenerator<T> generator, Printer printer, String rootPrefix, String childPrefix) {
        if (elementList.isEmpty()) {
            return;
        }
        if (elementList.size() == 1) {
            generator.printElement(elementList.get(0), printer, rootPrefix + "\u2550\u2550\u2550", childPrefix);
            return;
        }
        generator.printElement(elementList.get(0), printer, rootPrefix + "\u2550\u2566\u2550", childPrefix);
        String offset = "";
        for (int i = 1; i < elementList.size(); ++i) {
            offset = offset + " ";
            if (i + 1 == elementList.size()) {
                generator.printElement(elementList.get(i), printer, childPrefix + offset + "\u255a\u2550\u2550", childPrefix + offset);
                continue;
            }
            generator.printElement(elementList.get(i), printer, childPrefix + offset + "\u255a\u2566\u2550", childPrefix + offset);
        }
    }

    private static <T> void printFlatTree(T rootElement, List<T> elementList, ElementGenerator<T> generator, Printer printer, String rootPrefix, String childPrefix) {
        if (rootElement == null) {
            return;
        }
        if (elementList.isEmpty()) {
            generator.printRootElement(rootElement, printer, rootPrefix + "\u2550\u2550 ", childPrefix);
            return;
        }
        generator.printRootElement(rootElement, printer, rootPrefix + "\u2550\u2566\u2550", childPrefix);
        for (int i = 0; i < elementList.size(); ++i) {
            if (i + 1 == elementList.size()) {
                generator.printElement(elementList.get(i), printer, childPrefix + " \u255a\u2550", childPrefix + "   ");
                continue;
            }
            generator.printElement(elementList.get(i), printer, childPrefix + " \u2560\u2550", childPrefix + " \u2551 ");
        }
    }

    public static String getContext(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        if (throwable.getMessage() == null || throwable.getMessage().isEmpty()) {
            return throwable.getClass().getSimpleName();
        }
        return throwable.getMessage().replaceAll("\n", "").trim();
    }
}

