/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.exception;

import java.util.ArrayList;
import org.openbase.jul.exception.CouldNotPerformException;
import org.slf4j.LoggerFactory;

public class MultiException
extends CouldNotPerformException {
    private final ExceptionStack exceptionStack;

    public MultiException(String message, ExceptionStack exceptionStack) {
        super(message, ((SourceExceptionEntry)exceptionStack.get(0)).getException());
        this.exceptionStack = exceptionStack;
    }

    public ExceptionStack getExceptionStack() {
        return this.exceptionStack;
    }

    public void printExceptionStack() {
        for (SourceExceptionEntry entry : this.exceptionStack) {
            LoggerFactory.getLogger(entry.getSource().getClass()).error("Exception from " + entry.getSource().toString() + ":", entry.getException());
        }
    }

    public static ExceptionStack push(Object source, Exception exception, ExceptionStack exceptionStack) {
        if (exceptionStack == null) {
            exceptionStack = new ExceptionStack();
        }
        exceptionStack.push(source, exception);
        return exceptionStack;
    }

    public static void checkAndThrow(String message, ExceptionStack exceptionStack) throws MultiException {
        if (exceptionStack == null || exceptionStack.isEmpty()) {
            return;
        }
        throw new MultiException(message, exceptionStack);
    }

    public static boolean containsException(ExceptionStack exceptionStack) {
        return exceptionStack != null && !exceptionStack.isEmpty();
    }

    public static int size(ExceptionStack exceptionStack) {
        return exceptionStack == null ? 0 : exceptionStack.size();
    }

    public static class SourceExceptionEntry {
        private final Object source;
        private final Throwable exception;

        public SourceExceptionEntry(Object source, Throwable exception) {
            this.source = source;
            this.exception = exception;
        }

        public Object getSource() {
            return this.source;
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    public static class ExceptionStack
    extends ArrayList<SourceExceptionEntry> {
        public void push(Object source, Exception exception) {
            super.add(new SourceExceptionEntry(source, exception));
        }
    }
}

