/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.openbase.bco.authentication.lib.jp.JPBCOShareDirectory;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InvalidStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BCORegistryLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(BCORegistryLoader.class);

    public static synchronized void prepareRegistry(File registryDirectory) throws CouldNotPerformException {
        if (!registryDirectory.exists()) {
            throw new CouldNotPerformException("RegistryDirectory does not exists so nothing to prepare!");
        }
        if (registryDirectory.listFiles().length == 0) {
            BCORegistryLoader.generateNewDatabase(registryDirectory);
        }
    }

    private static void generateNewDatabase(File databaseFile) throws CouldNotPerformException {
        try {
            File dbTemplateDirectory = new File((File)((JPBCOShareDirectory)JPService.getProperty(JPBCOShareDirectory.class)).getValue(), "template");
            if (!dbTemplateDirectory.exists()) {
                throw new InvalidStateException("Database template directory " + dbTemplateDirectory.getAbsolutePath() + " does not exist!");
            }
            File dbTemplate = new File(dbTemplateDirectory, "db");
            try {
                LOGGER.info("Create new registry db at " + databaseFile.getAbsolutePath() + " based on " + dbTemplate.getAbsolutePath() + ".");
                FileUtils.copyDirectory((File)dbTemplate, (File)databaseFile);
            }
            catch (IOException ex) {
                throw new CouldNotPerformException("Could not copy database from template!", (Throwable)ex);
            }
        }
        catch (JPServiceException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not generate new database!", ex);
        }
    }
}

