/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.jp;

import java.io.File;
import org.openbase.bco.authentication.lib.jp.JPBCOVarDirectory;
import org.openbase.bco.registry.lib.util.BCORegistryLoader;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.exception.JPValidationException;
import org.openbase.jps.preset.AbstractJPDirectory;
import org.openbase.jps.preset.JPShareDirectory;
import org.openbase.jps.preset.JPVarDirectory;
import org.openbase.jps.tools.FileHandler;
import org.openbase.jul.exception.CouldNotPerformException;

public class JPBCODatabaseDirectory
extends AbstractJPDirectory {
    public static final String DEFAULT_DB_PATH = "registry/db";
    public static final String[] COMMAND_IDENTIFIERS = new String[]{"--db", "--database"};
    public static final FileHandler.ExistenceHandling EXISTENCE_HANDLING = FileHandler.ExistenceHandling.Must;
    public static final FileHandler.AutoMode AUTO_MODE = FileHandler.AutoMode.On;

    public JPBCODatabaseDirectory() {
        super(COMMAND_IDENTIFIERS, EXISTENCE_HANDLING, AUTO_MODE);
        this.registerDependingProperty(JPBCOVarDirectory.class);
        this.registerDependingProperty(JPVarDirectory.class);
        this.registerDependingProperty(JPShareDirectory.class);
    }

    public File getParentDirectory() throws JPServiceException {
        File bcoVar2;
        try {
            bcoVar2 = (File)((JPBCOVarDirectory)JPService.getProperty(JPBCOVarDirectory.class)).getValue();
            if (JPService.testMode() || bcoVar2.exists() && new File(bcoVar2, DEFAULT_DB_PATH).exists()) {
                return bcoVar2;
            }
        }
        catch (JPNotAvailableException bcoVar2) {
            // empty catch block
        }
        try {
            File prefixVar = new File((File)((JPVarDirectory)JPService.getProperty(JPVarDirectory.class)).getValue(), "bco");
            if (prefixVar.exists() && new File(prefixVar, DEFAULT_DB_PATH).exists()) {
                return prefixVar;
            }
        }
        catch (JPNotAvailableException prefixVar) {
            // empty catch block
        }
        try {
            File prefixShare = new File((File)((JPShareDirectory)JPService.getProperty(JPShareDirectory.class)).getValue(), "bco");
            if (prefixShare.exists() && new File(prefixShare, DEFAULT_DB_PATH).exists()) {
                return prefixShare;
            }
        }
        catch (JPNotAvailableException prefixShare) {
            // empty catch block
        }
        try {
            bcoVar2 = (File)((JPBCOVarDirectory)JPService.getProperty(JPBCOVarDirectory.class)).getValue();
            if (bcoVar2.exists()) {
                return bcoVar2;
            }
        }
        catch (JPNotAvailableException jPNotAvailableException) {
            // empty catch block
        }
        throw new JPServiceException("Could not auto detect database location!");
    }

    protected File getPropertyDefaultValue() {
        return new File(DEFAULT_DB_PATH);
    }

    public void validate() throws JPValidationException {
        super.validate();
        if (!JPService.testMode()) {
            try {
                BCORegistryLoader.prepareRegistry((File)this.getValue());
            }
            catch (CouldNotPerformException ex) {
                throw new JPValidationException((Throwable)ex);
            }
        }
    }

    public String getDescription() {
        return "Specifies the bco database directory. If not already exist, this database directory is auto generated from provided templates during startup.";
    }
}

